/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.decision.included.components;

import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLHeadingElement;
import elemental2.dom.HTMLImageElement;
import elemental2.dom.HTMLParagraphElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement;
import org.kie.workbench.common.dmn.api.definition.v1_1.DRGElement;
import org.kie.workbench.common.dmn.api.definition.v1_1.Definitions;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.client.DMNShapeSet;
import org.kie.workbench.common.dmn.client.decision.included.components.DecisionComponentsItem;
import org.kie.workbench.common.dmn.client.decision.included.components.DecisionComponentsItemView;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.dmn.client.shape.factory.DMNShapeFactory;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.event.BuildCanvasShapeEvent;
import org.kie.workbench.common.stunner.core.client.components.drag.DragProxyCallback;
import org.kie.workbench.common.stunner.core.client.components.glyph.ShapeGlyphDragHandler;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeFactory;
import org.kie.workbench.common.stunner.core.definition.shape.Glyph;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionComponentsItemViewTest {
    @Mock
    private HTMLImageElement icon;
    @Mock
    private HTMLHeadingElement name;
    @Mock
    private HTMLDivElement decisionComponentItem;
    @Mock
    private HTMLParagraphElement file;
    @Mock
    private DMNShapeSet dmnShapeSet;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private ShapeGlyphDragHandler<?> shapeGlyphDragHandler;
    @Mock
    private EventSourceMock<BuildCanvasShapeEvent> buildCanvasShapeEvent;
    @Mock
    private EventSourceMock<NotificationEvent> notificationEvent;
    @Mock
    private ClientTranslationService clientTranslationService;
    @Mock
    private DMNGraphUtils dmnGraphUtils;
    @Mock
    private DecisionComponentsItem presenter;
    @Captor
    private ArgumentCaptor<NotificationEvent> notificationEventArgumentCaptor;
    @Captor
    private ArgumentCaptor<BuildCanvasShapeEvent> buildCanvasShapeEventArgumentCaptor;
    private DecisionComponentsItemView view;

    @Before
    public void setup() {
        this.view = (DecisionComponentsItemView)Mockito.spy((Object)new DecisionComponentsItemView(this.icon, this.name, this.file, this.dmnShapeSet, this.sessionManager, this.shapeGlyphDragHandler, this.buildCanvasShapeEvent, this.decisionComponentItem, this.notificationEvent, this.clientTranslationService, this.dmnGraphUtils));
        this.view.init(this.presenter);
    }

    @Test
    public void testSetIcon() {
        String iconURI = "http://src.icon.url";
        this.icon.src = "something";
        this.view.setIcon("http://src.icon.url");
        Assert.assertEquals((Object)"http://src.icon.url", (Object)this.icon.src);
    }

    @Test
    public void testSetName() {
        String name = "name";
        this.name.textContent = "something";
        this.view.setName("name");
        Assert.assertEquals((Object)"name", (Object)this.name.textContent);
    }

    @Test
    public void testSetFile() {
        String file = "file";
        this.file.textContent = "something";
        this.view.setFile("file");
        Assert.assertEquals((Object)"file", (Object)this.file.textContent);
    }

    @Test
    public void testDecisionComponentItemMouseDown() {
        MouseDownEvent mouseDownEvent = (MouseDownEvent)Mockito.mock(MouseDownEvent.class);
        DragProxyCallback proxy = (DragProxyCallback)Mockito.mock(DragProxyCallback.class);
        DRGElement drgElement = (DRGElement)Mockito.mock(DRGElement.class);
        DMNShapeFactory factory = (DMNShapeFactory)Mockito.mock(DMNShapeFactory.class);
        ShapeGlyphDragHandler.Item item = (ShapeGlyphDragHandler.Item)Mockito.mock(ShapeGlyphDragHandler.Item.class);
        Glyph glyph = (Glyph)Mockito.mock(Glyph.class);
        int x = 10;
        int y = 20;
        Mockito.when((Object)this.dmnShapeSet.getShapeFactory()).thenReturn((Object)factory);
        Mockito.when((Object)this.presenter.getDrgElement()).thenReturn((Object)drgElement);
        Mockito.when((Object)factory.getGlyph((String)Matchers.any())).thenReturn((Object)glyph);
        Mockito.when((Object)mouseDownEvent.getX()).thenReturn((Object)10);
        Mockito.when((Object)mouseDownEvent.getY()).thenReturn((Object)20);
        ((DecisionComponentsItemView)Mockito.doReturn((Object)proxy).when((Object)this.view)).makeDragProxyCallbackImpl(drgElement, (ShapeFactory)factory);
        ((DecisionComponentsItemView)Mockito.doReturn((Object)item).when((Object)this.view)).makeDragHandler(glyph);
        this.view.decisionComponentItemMouseDown(mouseDownEvent);
        ((ShapeGlyphDragHandler)Mockito.verify(this.shapeGlyphDragHandler)).show((Object)item, 10, 20, (Object)proxy);
    }

    @Test
    public void testMakeDragProxyCallbackImplWhenNodeIsDuplicated() {
        ShapeFactory factory = (ShapeFactory)Mockito.mock(ShapeFactory.class);
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        DRGElement drgElement1 = (DRGElement)Mockito.mock(DRGElement.class);
        DRGElement drgElement2 = (DRGElement)Mockito.mock(DRGElement.class);
        List<DRGElement> drgElements = Arrays.asList(drgElement1, drgElement2);
        int x = 10;
        int y = 20;
        String expectedWarnMessage = "This 'DRGElement' already exists!";
        NotificationEvent.NotificationType expectedWarnType = NotificationEvent.NotificationType.WARNING;
        Graph graph = (Graph)Mockito.mock(Graph.class);
        ArrayList<Node> nodes = new ArrayList<Node>();
        String namespace1 = "http://something";
        String alias1 = "included1";
        String namespace2 = "http://someotherthing";
        String alias2 = "included2";
        String id1 = "123";
        String id2 = "456";
        nodes.add(this.createNode("included1", "123"));
        nodes.add(this.createNode("included2", "456"));
        HashMap<String, String> nsContext = new HashMap<String, String>();
        nsContext.put("included1", "http://something");
        nsContext.put("included2", "http://someotherthing");
        Mockito.when((Object)drgElement1.getDefaultNamespace()).thenReturn((Object)"http://something");
        Mockito.when((Object)drgElement2.getDefaultNamespace()).thenReturn((Object)"http://someotherthing");
        Mockito.when((Object)graph.nodes()).thenReturn(nodes);
        Mockito.when((Object)drgElement1.getId()).thenReturn((Object)new Id("included1:123"));
        Mockito.when((Object)drgElement2.getId()).thenReturn((Object)new Id("included2:456"));
        Mockito.when((Object)this.clientTranslationService.getValue("DecisionComponentsItemView.DuplicatedNode")).thenReturn((Object)"This 'DRGElement' already exists!");
        Mockito.when((Object)this.dmnGraphUtils.getDefinitions()).thenReturn((Object)definitions);
        Mockito.when((Object)definitions.getDrgElement()).thenReturn(drgElements);
        ((DecisionComponentsItemView)Mockito.doReturn(nsContext).when((Object)this.view)).getNsContext();
        ((DecisionComponentsItemView)Mockito.doReturn((Object)graph).when((Object)this.view)).getGraph();
        this.view.makeDragProxyCallbackImpl(drgElement1, factory).onComplete(10, 20);
        ((EventSourceMock)Mockito.verify(this.buildCanvasShapeEvent, (VerificationMode)Mockito.never())).fire(Matchers.any());
        ((EventSourceMock)Mockito.verify(this.notificationEvent)).fire(this.notificationEventArgumentCaptor.capture());
        NotificationEvent notificationEvent = (NotificationEvent)this.notificationEventArgumentCaptor.getValue();
        Assert.assertEquals((Object)"This 'DRGElement' already exists!", (Object)notificationEvent.getNotification());
        Assert.assertEquals((Object)expectedWarnType, (Object)notificationEvent.getType());
    }

    private Node createNode(String alias, String id) {
        Node n1 = (Node)Mockito.mock(Node.class);
        View v1 = (View)Mockito.mock(View.class);
        DMNElement d1 = (DMNElement)Mockito.mock(DMNElement.class);
        Id id1 = (Id)Mockito.mock(Id.class);
        Mockito.when((Object)n1.getContent()).thenReturn((Object)v1);
        Mockito.when((Object)v1.getDefinition()).thenReturn((Object)d1);
        Mockito.when((Object)d1.getId()).thenReturn((Object)id1);
        Mockito.when((Object)id1.getValue()).thenReturn((Object)(alias + ":" + id));
        return n1;
    }

    @Test
    public void testMakeDragProxyCallbackImplWhenNodeIsNotDuplicated() {
        ShapeFactory factory = (ShapeFactory)Mockito.mock(ShapeFactory.class);
        DRGElement drgElement1 = (DRGElement)Mockito.mock(DRGElement.class);
        DRGElement drgElement2 = (DRGElement)Mockito.mock(DRGElement.class);
        DRGElement drgElement3 = (DRGElement)Mockito.mock(DRGElement.class);
        ClientSession currentSession = (ClientSession)Mockito.mock(ClientSession.class);
        AbstractCanvasHandler canvasHandler = (AbstractCanvasHandler)Mockito.mock(AbstractCanvasHandler.class);
        Graph graph = (Graph)Mockito.mock(Graph.class);
        ArrayList<Node> nodes = new ArrayList<Node>();
        int x = 10;
        int y = 20;
        String namespace1 = "http://something";
        String alias1 = "included1";
        String namespace2 = "http://someotherthing";
        String alias2 = "included2";
        String namespace3 = "http://someNewNamespace";
        String alias3 = "included3";
        String id1 = "123";
        String id2 = "456";
        String id3 = "789";
        nodes.add(this.createNode("included1", "123"));
        nodes.add(this.createNode("included2", "456"));
        HashMap<String, String> nsContext = new HashMap<String, String>();
        nsContext.put("included1", "http://something");
        nsContext.put("included2", "http://someotherthing");
        nsContext.put("included3", "http://someNewNamespace");
        Mockito.when((Object)graph.nodes()).thenReturn(nodes);
        Mockito.when((Object)drgElement1.getId()).thenReturn((Object)new Id("included1:123"));
        Mockito.when((Object)drgElement2.getId()).thenReturn((Object)new Id("included2:456"));
        Mockito.when((Object)drgElement3.getId()).thenReturn((Object)new Id("included3:789"));
        Mockito.when((Object)drgElement1.getDefaultNamespace()).thenReturn((Object)"http://something");
        Mockito.when((Object)drgElement2.getDefaultNamespace()).thenReturn((Object)"http://someotherthing");
        Mockito.when((Object)drgElement3.getDefaultNamespace()).thenReturn((Object)"http://someNewNamespace");
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)currentSession);
        Mockito.when((Object)currentSession.getCanvasHandler()).thenReturn((Object)canvasHandler);
        ((DecisionComponentsItemView)Mockito.doReturn(nsContext).when((Object)this.view)).getNsContext();
        ((DecisionComponentsItemView)Mockito.doReturn((Object)graph).when((Object)this.view)).getGraph();
        this.view.makeDragProxyCallbackImpl(drgElement3, factory).onComplete(10, 20);
        ((EventSourceMock)Mockito.verify(this.notificationEvent, (VerificationMode)Mockito.never())).fire(Matchers.any());
        ((EventSourceMock)Mockito.verify(this.buildCanvasShapeEvent)).fire(this.buildCanvasShapeEventArgumentCaptor.capture());
        BuildCanvasShapeEvent canvasShapeEvent = (BuildCanvasShapeEvent)this.buildCanvasShapeEventArgumentCaptor.getValue();
        Assert.assertEquals((Object)canvasHandler, (Object)canvasShapeEvent.getCanvasHandler());
        Assert.assertEquals((Object)drgElement3, (Object)canvasShapeEvent.getDefinition());
        Assert.assertEquals((Object)factory, (Object)canvasShapeEvent.getShapeFactory());
        Assert.assertEquals((double)10.0, (double)canvasShapeEvent.getClientX(), (double)0.1);
        Assert.assertEquals((double)20.0, (double)canvasShapeEvent.getClientY(), (double)0.1);
    }

    @Test
    public void testMakeDragHandler() {
        Glyph glyph = (Glyph)Mockito.mock(Glyph.class);
        ShapeGlyphDragHandler.Item item = this.view.makeDragHandler(glyph);
        Assert.assertEquals((long)16L, (long)item.getHeight());
        Assert.assertEquals((long)16L, (long)item.getWidth());
        Assert.assertEquals((Object)glyph, (Object)item.getShape());
    }
}

