/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.decision.tree;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.DOMTokenList;
import elemental2.dom.Element;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLUListElement;
import elemental2.dom.Node;
import elemental2.dom.Text;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.elemental2.Elemental2DomUtil;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.decision.DecisionNavigatorItem;
import org.kie.workbench.common.dmn.client.decision.tree.DecisionNavigatorTreeView;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionNavigatorTreeViewTest {
    @Mock
    private HTMLDivElement view;
    @Mock
    private HTMLDivElement items;
    @Mock
    private ManagedInstance<DecisionNavigatorTreeView.TreeItem> managedInstance;
    @Mock
    private Elemental2DomUtil util;
    @Mock
    private HTMLDivElement text;
    @Mock
    private elemental2.dom.HTMLElement icon;
    @Mock
    private HTMLUListElement subItems;
    private DecisionNavigatorTreeView treeView;
    private DecisionNavigatorTreeView.TreeItem treeItem;

    @Before
    public void setup() {
        this.treeView = (DecisionNavigatorTreeView)Mockito.spy((Object)new DecisionNavigatorTreeView(this.view, this.items, this.managedInstance, this.util));
        this.treeItem = (DecisionNavigatorTreeView.TreeItem)Mockito.spy((Object)new DecisionNavigatorTreeView.TreeItem(this.text, this.icon, this.subItems));
    }

    @Test
    public void testClean() {
        Element element = (Element)Mockito.mock(Element.class);
        this.items.firstChild = element;
        Mockito.when((Object)this.items.removeChild((Node)element)).then(a -> {
            this.items.firstChild = null;
            return element;
        });
        this.treeView.clean();
        ((HTMLDivElement)Mockito.verify((Object)this.items)).removeChild((Node)element);
    }

    @Test
    public void testSetup() {
        ArrayList items = new ArrayList();
        Element element = (Element)Mockito.mock(Element.class);
        ((DecisionNavigatorTreeView)Mockito.doReturn((Object)element).when((Object)this.treeView)).makeTree(items);
        this.treeView.setup(items);
        ((HTMLDivElement)Mockito.verify((Object)this.items)).appendChild((Node)element);
    }

    @Test
    public void testAddItemWhenElementExists() {
        DOMTokenList domTokenList;
        String itemUUID = "itemUUID";
        String nextItemUUID = "nextItemUUID";
        String parentUUID = "parentUUID";
        DecisionNavigatorItem item = this.makeItem("itemUUID", "parentUUID");
        DecisionNavigatorItem nextItem = this.makeItem("nextItemUUID", "parentUUID");
        Element parentElement = (Element)Mockito.mock(Element.class);
        Element parentChildrenElement = (Element)Mockito.mock(Element.class);
        Element newChild = (Element)Mockito.mock(Element.class);
        Element refChild = (Element)Mockito.mock(Element.class);
        parentElement.classList = domTokenList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        ((DecisionNavigatorTreeView)Mockito.doReturn((Object)parentElement).when((Object)this.treeView)).findTreeItemElement("parentUUID");
        ((DecisionNavigatorTreeView)Mockito.doReturn((Object)parentChildrenElement).when((Object)this.treeView)).findTreeItemChildrenElement("parentUUID");
        ((DecisionNavigatorTreeView)Mockito.doReturn((Object)newChild).when((Object)this.treeView)).makeTreeItemElement(item);
        ((DecisionNavigatorTreeView)Mockito.doReturn((Object)refChild).when((Object)this.treeView)).findItem(nextItem);
        this.treeView.addItem(item, nextItem);
        ((DOMTokenList)Mockito.verify((Object)domTokenList)).add(new String[]{"parent-node"});
        ((Element)Mockito.verify((Object)parentChildrenElement)).insertBefore((Node)newChild, (Node)refChild);
    }

    @Test
    public void testUpdate() {
        String itemUUID = "itemUUID";
        String nextItemUUID = "nextItemUUID";
        String parentUUID = "parentUUID";
        DecisionNavigatorItem item = this.makeItem("itemUUID", "parentUUID");
        DecisionNavigatorItem nextItem = this.makeItem("nextItemUUID", "parentUUID");
        Element parentElement = (Element)Mockito.mock(Element.class);
        Element oldChild = (Element)Mockito.mock(Element.class);
        Element newChild = (Element)Mockito.mock(Element.class);
        Element refChild = (Element)Mockito.mock(Element.class);
        ((DecisionNavigatorTreeView)Mockito.doReturn((Object)parentElement).when((Object)this.treeView)).findTreeItemChildrenElement("parentUUID");
        ((DecisionNavigatorTreeView)Mockito.doReturn((Object)oldChild).when((Object)this.treeView)).findItem(item);
        ((DecisionNavigatorTreeView)Mockito.doReturn((Object)newChild).when((Object)this.treeView)).makeTreeItemElement(item);
        ((DecisionNavigatorTreeView)Mockito.doReturn((Object)refChild).when((Object)this.treeView)).findItem(nextItem);
        this.treeView.update(item, nextItem);
        ((Element)Mockito.verify((Object)parentElement)).removeChild((Node)oldChild);
        ((Element)Mockito.verify((Object)oldChild, (VerificationMode)Mockito.never())).remove();
        ((Element)Mockito.verify((Object)parentElement)).insertBefore((Node)newChild, (Node)refChild);
    }

    @Test
    public void testMakeTree() {
        DecisionNavigatorItem item = this.makeItem("uuid");
        List<DecisionNavigatorItem> items = Collections.singletonList(item);
        Element expectedTreeElement = (Element)Mockito.mock(Element.class);
        Element treeItemElement = (Element)Mockito.mock(Element.class);
        ((DecisionNavigatorTreeView)Mockito.doReturn((Object)expectedTreeElement).when((Object)this.treeView)).createElement("ul");
        ((DecisionNavigatorTreeView)Mockito.doReturn((Object)treeItemElement).when((Object)this.treeView)).makeTreeItemElement(item);
        Element actualTreeElement = this.treeView.makeTree(items);
        ((Element)Mockito.verify((Object)expectedTreeElement)).appendChild((Node)treeItemElement);
        Assert.assertEquals((Object)expectedTreeElement, (Object)actualTreeElement);
    }

    @Test
    public void testFindTreeItemTextElement() {
        this.treeView.findTreeItemTextElement("123");
        ((DecisionNavigatorTreeView)Mockito.verify((Object)this.treeView)).itemsQuerySelector("[data-uuid=\"123\"] div");
    }

    @Test
    public void testFindTreeItemChildrenElement() {
        this.treeView.findTreeItemChildrenElement("123");
        ((DecisionNavigatorTreeView)Mockito.verify((Object)this.treeView)).itemsQuerySelector("[data-uuid=\"123\"] ul");
    }

    @Test
    public void testFindTreeItemElement() {
        this.treeView.findTreeItemElement("123");
        ((DecisionNavigatorTreeView)Mockito.verify((Object)this.treeView)).itemsQuerySelector("[data-uuid=\"123\"]");
    }

    @Test
    public void testItemsQuerySelector() {
        String selector = "selector";
        this.treeView.itemsQuerySelector("selector");
        ((HTMLDivElement)Mockito.verify((Object)this.items)).querySelector("selector");
    }

    @Test
    public void testMakeTreeItemElement() {
        DecisionNavigatorItem item = this.makeItem("uuid");
        DecisionNavigatorTreeView.TreeItem newTreeItem = (DecisionNavigatorTreeView.TreeItem)Mockito.mock(DecisionNavigatorTreeView.TreeItem.class);
        DecisionNavigatorTreeView.TreeItem treeItem = (DecisionNavigatorTreeView.TreeItem)Mockito.mock(DecisionNavigatorTreeView.TreeItem.class);
        Element childrenTree = (Element)Mockito.mock(Element.class);
        HTMLElement htmlElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        elemental2.dom.HTMLElement expectedHtmlElement = (elemental2.dom.HTMLElement)Mockito.mock(elemental2.dom.HTMLElement.class);
        ((DecisionNavigatorTreeView)Mockito.doReturn((Object)childrenTree).when((Object)this.treeView)).makeTree((Collection)item.getChildren());
        Mockito.when((Object)this.managedInstance.get()).thenReturn((Object)newTreeItem);
        Mockito.when((Object)newTreeItem.setup(item, childrenTree)).thenReturn((Object)treeItem);
        Mockito.when((Object)treeItem.getElement()).thenReturn((Object)htmlElement);
        Mockito.when((Object)this.util.asHTMLElement(htmlElement)).thenReturn((Object)expectedHtmlElement);
        Element actualHtmlElement = this.treeView.makeTreeItemElement(item);
        Assert.assertEquals((Object)expectedHtmlElement, (Object)actualHtmlElement);
    }

    @Test
    public void testFindItem() {
        String uuid = "uuid";
        DecisionNavigatorItem item = this.makeItem("uuid");
        Element expectedElement = (Element)Mockito.mock(Element.class);
        ((DecisionNavigatorTreeView)Mockito.doReturn((Object)expectedElement).when((Object)this.treeView)).findTreeItemElement("uuid");
        Element actualElement = this.treeView.findItem(item);
        Assert.assertEquals((Object)expectedElement, (Object)actualElement);
    }

    @Test
    public void testHasItemWhenItemExists() {
        String uuid = "uuid";
        DecisionNavigatorItem item = this.makeItem("uuid");
        Element element = (Element)Mockito.mock(Element.class);
        ((DecisionNavigatorTreeView)Mockito.doReturn((Object)element).when((Object)this.treeView)).findItem(item);
        Assert.assertTrue((boolean)this.treeView.hasItem(item));
    }

    @Test
    public void testHasItemWhenItemDoesNotExist() {
        String uuid = "uuid";
        DecisionNavigatorItem item = this.makeItem("uuid");
        Assert.assertFalse((boolean)this.treeView.hasItem(item));
    }

    @Test
    public void testRemove() {
        DecisionNavigatorItem item = this.makeItem("uuid");
        Element element = (Element)Mockito.mock(Element.class);
        Element parentElement = (Element)Mockito.mock(Element.class);
        element.parentNode = parentElement;
        ((DecisionNavigatorTreeView)Mockito.doReturn((Object)element).when((Object)this.treeView)).findItem(item);
        this.treeView.remove(item);
        ((Element)Mockito.verify((Object)parentElement)).removeChild((Node)element);
        ((Element)Mockito.verify((Object)element, (VerificationMode)Mockito.never())).remove();
    }

    @Test
    public void testRemoveItemWhenDoesNotHaveParent() {
        DecisionNavigatorItem item = this.makeItem("uuid");
        Element element = (Element)Mockito.mock(Element.class);
        ((DecisionNavigatorTreeView)Mockito.doReturn((Object)element).when((Object)this.treeView)).findItem(item);
        this.treeView.remove(item);
        ((Element)Mockito.verify((Object)element, (VerificationMode)Mockito.never())).remove();
    }

    @Test
    public void testSelect() {
        String uuid = "uuid";
        Element newElement = (Element)Mockito.mock(Element.class);
        Element oldElement = (Element)Mockito.mock(Element.class);
        DOMTokenList newDomTokenList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        DOMTokenList oldDomTokenList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        newElement.classList = newDomTokenList;
        oldElement.classList = oldDomTokenList;
        ((DecisionNavigatorTreeView)Mockito.doReturn((Object)newElement).when((Object)this.treeView)).findTreeItemTextElement("uuid");
        ((DecisionNavigatorTreeView)Mockito.doReturn((Object)oldElement).when((Object)this.treeView)).getSelectedElement();
        this.treeView.select("uuid");
        ((DOMTokenList)Mockito.verify((Object)oldDomTokenList)).remove(new String[]{"selected"});
        ((DOMTokenList)Mockito.verify((Object)newDomTokenList)).add(new String[]{"selected"});
        ((DecisionNavigatorTreeView)Mockito.verify((Object)this.treeView)).deselect(oldElement);
        ((DecisionNavigatorTreeView)Mockito.verify((Object)this.treeView)).select(newElement);
        ((DecisionNavigatorTreeView)Mockito.verify((Object)this.treeView)).setSelectedElement(newElement);
    }

    @Test
    public void testDeselect() {
        DOMTokenList domTokenList;
        Element element = (Element)Mockito.mock(Element.class);
        element.classList = domTokenList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        ((DecisionNavigatorTreeView)Mockito.doReturn((Object)element).when((Object)this.treeView)).getSelectedElement();
        this.treeView.deselect();
        ((DOMTokenList)Mockito.verify((Object)domTokenList)).remove(new String[]{"selected"});
        ((DecisionNavigatorTreeView)Mockito.verify((Object)this.treeView)).deselect(element);
    }

    @Test
    public void testTreeItemOnIconClick() {
        ClickEvent event = (ClickEvent)Mockito.mock(ClickEvent.class);
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doNothing().when((Object)this.treeItem)).toggle();
        this.treeItem.onIconClick(event);
        ((DecisionNavigatorTreeView.TreeItem)Mockito.verify((Object)this.treeItem)).toggle();
        ((ClickEvent)Mockito.verify((Object)event)).stopPropagation();
    }

    @Test
    public void testTreeItemOnTextClick() {
        DecisionNavigatorItem item = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        ClickEvent event = (ClickEvent)Mockito.mock(ClickEvent.class);
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)item).when((Object)this.treeItem)).getItem();
        this.treeItem.onTextClick(event);
        ((DecisionNavigatorItem)Mockito.verify((Object)item)).onClick();
    }

    @Test
    public void testTreeItemSetup() {
        DecisionNavigatorItem expectedItem = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        Element children = (Element)Mockito.mock(Element.class);
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doNothing().when((Object)this.treeItem)).updateDataUUID();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doNothing().when((Object)this.treeItem)).updateTitle();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doNothing().when((Object)this.treeItem)).updateCSSClass();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doNothing().when((Object)this.treeItem)).updateLabel();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doNothing().when((Object)this.treeItem)).updateSubItems(children);
        DecisionNavigatorTreeView.TreeItem actualTreeItem = this.treeItem.setup(expectedItem, children);
        DecisionNavigatorItem actualItem = this.treeItem.getItem();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.verify((Object)this.treeItem)).updateDataUUID();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.verify((Object)this.treeItem)).updateTitle();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.verify((Object)this.treeItem)).updateCSSClass();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.verify((Object)this.treeItem)).updateLabel();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.verify((Object)this.treeItem)).updateSubItems(children);
        Assert.assertEquals((Object)this.treeItem, (Object)actualTreeItem);
        Assert.assertEquals((Object)expectedItem, (Object)actualItem);
    }

    @Test
    public void testTreeItemUpdateDataUUID() {
        DecisionNavigatorItem item = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        String uuid = "uuid";
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)item).when((Object)this.treeItem)).getItem();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)element).when((Object)this.treeItem)).getElement();
        Mockito.when((Object)item.getUUID()).thenReturn((Object)"uuid");
        this.treeItem.updateDataUUID();
        ((HTMLElement)Mockito.verify((Object)element)).setAttribute("data-uuid", "uuid");
    }

    @Test
    public void testTreeItemUpdateTitle() {
        DecisionNavigatorItem item = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        String label = "label";
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)item).when((Object)this.treeItem)).getItem();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)element).when((Object)this.treeItem)).getElement();
        Mockito.when((Object)item.getLabel()).thenReturn((Object)"label");
        this.treeItem.updateTitle();
        ((HTMLElement)Mockito.verify((Object)element)).setAttribute("title", "label");
    }

    @Test
    public void testTreeItemUpdateCSSClassWhenItemHasChildren() {
        DecisionNavigatorItem item = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        final DecisionNavigatorItem child = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        TreeSet<DecisionNavigatorItem> children = new TreeSet<DecisionNavigatorItem>(){
            {
                this.add(child);
            }
        };
        org.jboss.errai.common.client.dom.DOMTokenList classList = (org.jboss.errai.common.client.dom.DOMTokenList)Mockito.mock(org.jboss.errai.common.client.dom.DOMTokenList.class);
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        String cssClass = "css-class";
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)item).when((Object)this.treeItem)).getItem();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)element).when((Object)this.treeItem)).getElement();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)"css-class").when((Object)this.treeItem)).getCSSClass(item);
        Mockito.when((Object)element.getClassList()).thenReturn((Object)classList);
        Mockito.when((Object)item.getChildren()).thenReturn((Object)children);
        this.treeItem.updateCSSClass();
        ((org.jboss.errai.common.client.dom.DOMTokenList)Mockito.verify((Object)classList)).add("css-class");
        ((org.jboss.errai.common.client.dom.DOMTokenList)Mockito.verify((Object)classList)).add("parent-node");
    }

    @Test
    public void testTreeItemUpdateCSSClassWhenItemDoesNotHaveChildren() {
        DecisionNavigatorItem item = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        org.jboss.errai.common.client.dom.DOMTokenList classList = (org.jboss.errai.common.client.dom.DOMTokenList)Mockito.mock(org.jboss.errai.common.client.dom.DOMTokenList.class);
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        String cssClass = "css-class";
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)item).when((Object)this.treeItem)).getItem();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)element).when((Object)this.treeItem)).getElement();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)"css-class").when((Object)this.treeItem)).getCSSClass(item);
        Mockito.when((Object)element.getClassList()).thenReturn((Object)classList);
        this.treeItem.updateCSSClass();
        ((org.jboss.errai.common.client.dom.DOMTokenList)Mockito.verify((Object)classList)).add("css-class");
        ((org.jboss.errai.common.client.dom.DOMTokenList)Mockito.verify((Object)classList, (VerificationMode)Mockito.never())).add("parent-node");
    }

    @Test
    public void testTreeItemUpdateLabel() {
        DecisionNavigatorItem item = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        Text textNode = (Text)Mockito.mock(Text.class);
        String label = "label";
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)item).when((Object)this.treeItem)).getItem();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)textNode).when((Object)this.treeItem)).getTextNode("label");
        Mockito.when((Object)item.getLabel()).thenReturn((Object)"label");
        this.treeItem.updateLabel();
        ((HTMLDivElement)Mockito.verify((Object)this.text)).appendChild((Node)textNode);
    }

    @Test
    public void testTreeItemUpdateSubItems() {
        Node parentNode;
        Element children = (Element)Mockito.mock(Element.class);
        this.subItems.parentNode = parentNode = (Node)Mockito.mock(Node.class);
        this.treeItem.updateSubItems(children);
        ((Node)Mockito.verify((Object)parentNode)).replaceChild((Node)children, (Node)this.subItems);
    }

    @Test
    public void testTreeItemToggle() {
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        org.jboss.errai.common.client.dom.DOMTokenList classList = (org.jboss.errai.common.client.dom.DOMTokenList)Mockito.mock(org.jboss.errai.common.client.dom.DOMTokenList.class);
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)element).when((Object)this.treeItem)).getElement();
        ((HTMLElement)Mockito.doReturn((Object)classList).when((Object)element)).getClassList();
        this.treeItem.toggle();
        ((org.jboss.errai.common.client.dom.DOMTokenList)Mockito.verify((Object)classList)).toggle("closed");
    }

    @Test
    public void testTreeItemGetCSSClass() {
        String uuid = "uuid";
        String label = "label";
        DecisionNavigatorItem.Type subItem = DecisionNavigatorItem.Type.CONTEXT;
        Command onClick = () -> {};
        String expectedCSSClass = "kie-context";
        String actualCSSClass = this.treeItem.getCSSClass(new DecisionNavigatorItem("uuid", "label", subItem, onClick, null));
        Assert.assertEquals((Object)"kie-context", (Object)actualCSSClass);
    }

    private DecisionNavigatorItem makeItem(String uuid) {
        return this.makeItem(uuid, null);
    }

    private DecisionNavigatorItem makeItem(String uuid, String parentUUID) {
        return new DecisionNavigatorItem(uuid, null, null, null, parentUUID);
    }
}

