/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.documentation;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.documentation.DMNDocumentationView;
import org.kie.workbench.common.dmn.client.editors.documentation.common.DMNDocumentationService;
import org.kie.workbench.common.stunner.core.client.util.PrintHelper;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.documentation.model.DocumentationOutput;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNDocumentationViewTest {
    @Mock
    private HTMLDivElement documentationPanel;
    @Mock
    private HTMLDivElement documentationContent;
    @Mock
    private HTMLButtonElement printButton;
    @Mock
    private PrintHelper printHelper;
    @Mock
    private DMNDocumentationService documentationService;
    @Mock
    private Diagram diagram;
    private DMNDocumentationView view;

    @Before
    public void setup() {
        this.view = (DMNDocumentationView)Mockito.spy((Object)new DMNDocumentationView(this.documentationPanel, this.documentationContent, this.printButton, this.printHelper, this.documentationService));
    }

    @Test
    public void testRefreshWhenDiagramIsPresent() {
        String expectedHTML = "<html />";
        DocumentationOutput output = new DocumentationOutput("<html />");
        ((DMNDocumentationView)Mockito.doReturn(Optional.of(this.diagram)).when((Object)this.view)).getDiagram();
        Mockito.when((Object)this.documentationService.generate(this.diagram)).thenReturn((Object)output);
        this.documentationContent.innerHTML = "something";
        this.view.refresh();
        String actualHTML = this.documentationContent.innerHTML;
        Assert.assertEquals((Object)"<html />", (Object)actualHTML);
    }

    @Test
    public void testRefreshWhenDiagramIsNotPresent() {
        String expectedHTML = DocumentationOutput.EMPTY.getValue();
        ((DMNDocumentationView)Mockito.doReturn(Optional.empty()).when((Object)this.view)).getDiagram();
        this.documentationContent.innerHTML = "something";
        this.view.refresh();
        String actualHTML = this.documentationContent.innerHTML;
        Assert.assertEquals((Object)expectedHTML, (Object)actualHTML);
    }

    @Test
    public void testIsEnabled() {
        Assert.assertTrue((boolean)this.view.isEnabled());
    }

    @Test
    public void testOnPrintButtonClick() {
        this.view.onPrintButtonClick((ClickEvent)Mockito.mock(ClickEvent.class));
        ((PrintHelper)Mockito.verify((Object)this.printHelper)).print((HTMLElement)this.documentationContent);
    }
}

