/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.documentation.common;

import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.shared.core.types.DataURLType;
import com.google.gwtmockito.GwtMockitoTestRunner;
import freemarker.template.utility.Collections12;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.v1_1.Decision;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationItemPrimary;
import org.kie.workbench.common.dmn.api.definition.v1_1.InputData;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.client.common.BoxedExpressionHelper;
import org.kie.workbench.common.dmn.client.editors.documentation.common.DMNDocumentationDRD;
import org.kie.workbench.common.dmn.client.editors.documentation.common.DMNDocumentationDRDsFactory;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionContainerGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorView;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorViewImpl;
import org.kie.workbench.common.dmn.client.session.DMNSession;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNDocumentationDRDsFactoryTest {
    @Mock
    private SessionManager sessionManager;
    @Mock
    private BoxedExpressionHelper expressionHelper;
    @Mock
    private Diagram diagram;
    @Mock
    private DMNSession dmnSession;
    @Mock
    private ExpressionEditorView.Presenter expressionEditor;
    @Mock
    private ExpressionEditorViewImpl editorView;
    @Mock
    private ExpressionContainerGrid expressionContainerGrid;
    @Mock
    private Graph graph;
    @Mock
    private Viewport viewport;
    private DMNDocumentationDRDsFactory factory;

    @Before
    public void setup() {
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.dmnSession);
        Mockito.when((Object)this.dmnSession.getExpressionEditor()).thenReturn((Object)this.expressionEditor);
        Mockito.when((Object)this.expressionEditor.getView()).thenReturn((Object)this.editorView);
        Mockito.when((Object)this.editorView.getExpressionContainerGrid()).thenReturn((Object)this.expressionContainerGrid);
        Mockito.when((Object)this.expressionContainerGrid.getViewport()).thenReturn((Object)this.viewport);
        Mockito.when((Object)this.diagram.getGraph()).thenReturn((Object)this.graph);
        this.factory = (DMNDocumentationDRDsFactory)Mockito.spy((Object)new DMNDocumentationDRDsFactory(this.sessionManager, this.expressionHelper));
    }

    @Test
    public void testCreate() {
        String nodeUUID1 = "1111-1111-1111-1111";
        String nodeUUID2 = "2222-2222-2222-2222";
        NodeImpl node1 = new NodeImpl("1111-1111-1111-1111");
        NodeImpl node2 = new NodeImpl("2222-2222-2222-2222");
        HasExpression hasExpression1 = (HasExpression)Mockito.mock(HasExpression.class);
        List<Node> nodes = Arrays.asList(node1, node2);
        Decision drgElement1 = new Decision();
        InputData drgElement2 = new InputData();
        String name1 = "Decision-1";
        String name2 = "Input-data-2";
        String description1 = "Description...";
        InformationItemPrimary variable1 = new InformationItemPrimary();
        QName typeRef1 = BuiltInType.BOOLEAN.asQName();
        String image1 = "<image1>";
        Mockito.when((Object)this.expressionHelper.getDefinition((Node)node1)).thenReturn((Object)drgElement1);
        Mockito.when((Object)this.expressionHelper.getDefinition((Node)node2)).thenReturn((Object)drgElement2);
        Mockito.when((Object)this.expressionHelper.getOptionalHasExpression((Node)node1)).thenReturn(Optional.ofNullable(hasExpression1));
        Mockito.when((Object)this.expressionHelper.getOptionalHasExpression((Node)node2)).thenReturn(Optional.empty());
        Mockito.when((Object)this.expressionContainerGrid.getNodeUUID()).thenReturn(Optional.of("2222-2222-2222-2222"));
        Mockito.when((Object)this.graph.nodes()).thenReturn(nodes);
        ((DMNDocumentationDRDsFactory)Mockito.doReturn((Object)"<image1>").when((Object)this.factory)).getNodeImage(this.diagram, (Node)node1);
        ((DMNDocumentationDRDsFactory)Mockito.doNothing().when((Object)this.factory)).setExpressionContainerGrid((Diagram)Matchers.any(), (String)Matchers.any());
        variable1.setTypeRef(typeRef1);
        drgElement1.setVariable(variable1);
        drgElement1.setDescription(new Description("Description..."));
        drgElement1.setName(new Name("Decision-1"));
        drgElement2.setName(new Name("Input-data-2"));
        List drds = this.factory.create(this.diagram);
        DMNDocumentationDRD documentationDRD1 = (DMNDocumentationDRD)drds.get(0);
        DMNDocumentationDRD documentationDRD2 = (DMNDocumentationDRD)drds.get(1);
        Assert.assertEquals((long)2L, (long)drds.size());
        Assert.assertEquals((Object)"Decision-1", (Object)documentationDRD1.getDrdName());
        Assert.assertEquals((Object)BuiltInType.BOOLEAN.getName(), (Object)documentationDRD1.getDrdType());
        Assert.assertEquals((Object)"Description...", (Object)documentationDRD1.getDrdDescription());
        Assert.assertEquals((Object)"<image1>", (Object)documentationDRD1.getDrdBoxedExpressionImage());
        Assert.assertEquals((Object)"", (Object)documentationDRD2.getDrdDescription());
        Assert.assertEquals((Object)BuiltInType.UNDEFINED.getName(), (Object)documentationDRD2.getDrdType());
        Assert.assertEquals((Object)"Input-data-2", (Object)documentationDRD2.getDrdName());
        Assert.assertEquals((Object)"", (Object)documentationDRD2.getDrdBoxedExpressionImage());
        ((DMNDocumentationDRDsFactory)Mockito.verify((Object)this.factory)).setExpressionContainerGrid(this.diagram, "2222-2222-2222-2222");
    }

    @Test
    public void testGetNodeImage() {
        String uuid = "0000-1111-2222-3333";
        NodeImpl node = new NodeImpl("0000-1111-2222-3333");
        HasExpression hasExpression = (HasExpression)Mockito.mock(HasExpression.class);
        String expectedImage = "<image>";
        double wide = 800.0;
        double high = 600.0;
        ((DMNDocumentationDRDsFactory)Mockito.doNothing().when((Object)this.factory)).setExpressionContainerGrid((Diagram)Matchers.any(), (String)Matchers.any());
        Mockito.when((Object)this.expressionHelper.getOptionalHasExpression((Node)node)).thenReturn(Optional.of(hasExpression));
        Mockito.when((Object)this.expressionContainerGrid.getWidth()).thenReturn((Object)800.0);
        Mockito.when((Object)this.expressionContainerGrid.getHeight()).thenReturn((Object)600.0);
        Mockito.when((Object)this.viewport.toDataURL(DataURLType.PNG)).thenReturn((Object)"<image>");
        String actualImage = this.factory.getNodeImage(this.diagram, (Node)node);
        ((Viewport)Mockito.verify((Object)this.viewport)).setPixelSize(810, 610);
        ((DMNDocumentationDRDsFactory)Mockito.verify((Object)this.factory)).setExpressionContainerGrid(this.diagram, "0000-1111-2222-3333");
        Assert.assertEquals((Object)"<image>", (Object)actualImage);
    }

    @Test
    public void testSetExpressionContainerGrid() {
        String uuid = "0000-1111-2222-3333";
        String name = "Decision-1";
        NodeImpl node = new NodeImpl("0000-1111-2222-3333");
        Decision drgElement = new Decision();
        HasExpression hasExpression = (HasExpression)Mockito.mock(HasExpression.class);
        drgElement.setName(new Name("Decision-1"));
        Mockito.when((Object)this.graph.nodes()).thenReturn((Object)Collections12.singletonList((Object)node));
        Mockito.when((Object)this.expressionHelper.getDefinition((Node)node)).thenReturn((Object)drgElement);
        Mockito.when((Object)this.expressionHelper.getHasExpression((Node)node)).thenReturn((Object)hasExpression);
        this.factory.setExpressionContainerGrid(this.diagram, "0000-1111-2222-3333");
        ((ExpressionContainerGrid)Mockito.verify((Object)this.expressionContainerGrid)).setExpression("0000-1111-2222-3333", hasExpression, Optional.of(drgElement), false);
    }

    @Test
    public void testGetNodeImageWhenNodeDoesNotHaveExpression() {
        String uuid = "0000-1111-2222-3333";
        NodeImpl node = new NodeImpl("0000-1111-2222-3333");
        Mockito.when((Object)this.expressionHelper.getOptionalHasExpression((Node)node)).thenReturn(Optional.empty());
        String image = this.factory.getNodeImage(this.diagram, (Node)node);
        Assert.assertEquals((Object)"", (Object)image);
    }
}

