/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.decision.DecisionNavigatorPresenter;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorControlImpl;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorView;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.dmn.client.session.DMNSession;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasElementUpdatedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasSelectionEvent;
import org.kie.workbench.common.stunner.core.client.canvas.listener.CanvasDomainObjectListener;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.domainobject.DomainObject;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=LienzoMockitoTestRunner.class)
public class ExpressionEditorControlImplTest {
    @Mock
    private DMNSession session;
    @Mock
    private ExpressionEditorView view;
    @Mock
    private DecisionNavigatorPresenter decisionNavigator;
    @Mock
    private DMNGraphUtils dmnGraphUtils;
    @Mock
    private EventSourceMock<CanvasElementUpdatedEvent> canvasElementUpdatedEvent;
    @Mock
    private ExpressionEditorView.Presenter editor;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private Diagram diagram;
    @Mock
    private Graph<?, Node> graph;
    @Mock
    private Node node;
    @Mock
    private DomainObject domainObject;
    @Mock
    private CanvasSelectionEvent event;
    @Captor
    private ArgumentCaptor<CanvasDomainObjectListener> domainObjectListenerCaptor;
    @Captor
    private ArgumentCaptor<CanvasElementUpdatedEvent> canvasElementUpdatedEventCaptor;
    private ExpressionEditorControlImpl control;

    @Before
    public void setup() {
        this.control = (ExpressionEditorControlImpl)Mockito.spy((Object)new ExpressionEditorControlImpl(this.view, this.decisionNavigator, this.dmnGraphUtils, this.canvasElementUpdatedEvent));
        ((ExpressionEditorControlImpl)Mockito.doReturn((Object)this.editor).when((Object)this.control)).makeExpressionEditor((ExpressionEditorView)Matchers.any(ExpressionEditorView.class), (DecisionNavigatorPresenter)Matchers.any(DecisionNavigatorPresenter.class), (DMNGraphUtils)Matchers.any(DMNGraphUtils.class));
        Mockito.when((Object)this.session.getCanvasHandler()).thenReturn((Object)this.canvasHandler);
        Mockito.when((Object)this.canvasHandler.getDiagram()).thenReturn((Object)this.diagram);
        Mockito.when((Object)this.diagram.getGraph()).thenReturn(this.graph);
    }

    @Test
    public void testBind() {
        this.control.bind(this.session);
        Assert.assertNotNull((Object)this.control.getExpressionEditor());
        ((ExpressionEditorView.Presenter)Mockito.verify((Object)this.editor)).bind((ClientSession)this.session);
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler)).addDomainObjectListener((CanvasDomainObjectListener)Matchers.any(CanvasDomainObjectListener.class));
    }

    @Test
    public void testBindDomainObjectListenerWithNodeMatch() {
        Definition definition = (Definition)Mockito.mock(Definition.class);
        Mockito.when((Object)this.graph.nodes()).thenReturn(Collections.singletonList(this.node));
        Mockito.when((Object)this.node.getContent()).thenReturn((Object)definition);
        Mockito.when((Object)definition.getDefinition()).thenReturn((Object)this.domainObject);
        Mockito.when((Object)this.domainObject.getDomainObjectUUID()).thenReturn((Object)"uuid");
        this.control.bind(this.session);
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler)).addDomainObjectListener((CanvasDomainObjectListener)this.domainObjectListenerCaptor.capture());
        CanvasDomainObjectListener domainObjectListener = (CanvasDomainObjectListener)this.domainObjectListenerCaptor.getValue();
        domainObjectListener.update(this.domainObject);
        ((EventSourceMock)Mockito.verify(this.canvasElementUpdatedEvent)).fire(this.canvasElementUpdatedEventCaptor.capture());
        CanvasElementUpdatedEvent canvasElementUpdatedEvent = (CanvasElementUpdatedEvent)this.canvasElementUpdatedEventCaptor.getValue();
        Assertions.assertThat((Object)canvasElementUpdatedEvent.getCanvasHandler()).isEqualTo((Object)this.canvasHandler);
        Assertions.assertThat((Object)canvasElementUpdatedEvent.getElement()).isEqualTo((Object)this.node);
    }

    @Test
    public void testBindDomainObjectListenerWithNoNodeMatch() {
        Mockito.when((Object)this.graph.nodes()).thenReturn(Collections.emptyList());
        this.control.bind(this.session);
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler)).addDomainObjectListener((CanvasDomainObjectListener)this.domainObjectListenerCaptor.capture());
        CanvasDomainObjectListener domainObjectListener = (CanvasDomainObjectListener)this.domainObjectListenerCaptor.getValue();
        domainObjectListener.update(this.domainObject);
        ((EventSourceMock)Mockito.verify(this.canvasElementUpdatedEvent, (VerificationMode)Mockito.never())).fire(Matchers.any(CanvasElementUpdatedEvent.class));
    }

    @Test
    public void testDoInit() {
        Assert.assertNull((Object)this.control.getExpressionEditor());
        this.control.doInit();
        Assert.assertNull((Object)this.control.getExpressionEditor());
    }

    @Test
    public void testDoDestroy() {
        this.control.bind(this.session);
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler)).addDomainObjectListener((CanvasDomainObjectListener)this.domainObjectListenerCaptor.capture());
        this.control.doDestroy();
        Assert.assertNull((Object)this.control.getExpressionEditor());
        CanvasDomainObjectListener domainObjectListener = (CanvasDomainObjectListener)this.domainObjectListenerCaptor.getValue();
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler)).removeDomainObjectListener(domainObjectListener);
    }

    @Test
    public void testOnCanvasFocusedSelectionEventWhenBound() {
        this.control.bind(this.session);
        this.control.onCanvasFocusedSelectionEvent(this.event);
        ((ExpressionEditorView.Presenter)Mockito.verify((Object)this.editor)).exit();
    }

    @Test
    public void testOnCanvasFocusedSelectionEventWhenNotBound() {
        this.control.onCanvasFocusedSelectionEvent(this.event);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.editor});
    }

    @Test
    public void testOnCanvasElementUpdated() {
        this.control.bind(this.session);
        CanvasElementUpdatedEvent event = new CanvasElementUpdatedEvent((CanvasHandler)this.canvasHandler, (Element)this.node);
        this.control.onCanvasElementUpdated(event);
        ((ExpressionEditorView.Presenter)Mockito.verify((Object)this.editor)).handleCanvasElementUpdated(event);
    }
}

