/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.context;

import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.dmn.api.definition.v1_1.Context;
import org.kie.workbench.common.dmn.api.definition.v1_1.ContextEntry;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ContextEntryDefaultValueUtilities;

public class ContextEntryDefaultValueUtilitiesTest {
    private Context context;

    @Before
    public void setup() {
        this.context = new Context();
    }

    @Test
    public void testGetNewContextEntryName() {
        ContextEntry contextEntry1 = new ContextEntry(){
            {
                this.setVariable(new InformationItem());
            }
        };
        this.context.getContextEntry().add(contextEntry1);
        contextEntry1.getVariable().getName().setValue(ContextEntryDefaultValueUtilities.getNewContextEntryName((Context)this.context));
        Assertions.assertThat((String)contextEntry1.getVariable().getName().getValue()).isEqualTo((Object)(ContextEntryDefaultValueUtilities.PREFIX + "1"));
        ContextEntry contextEntry2 = new ContextEntry(){
            {
                this.setVariable(new InformationItem());
            }
        };
        this.context.getContextEntry().add(contextEntry2);
        contextEntry2.getVariable().getName().setValue(ContextEntryDefaultValueUtilities.getNewContextEntryName((Context)this.context));
        Assertions.assertThat((String)contextEntry2.getVariable().getName().getValue()).isEqualTo((Object)(ContextEntryDefaultValueUtilities.PREFIX + "2"));
    }

    @Test
    public void testGetNewContextEntryNameWithExistingContextEntries() {
        ContextEntry contextEntry1 = new ContextEntry(){
            {
                this.setVariable(new InformationItem());
            }
        };
        this.context.getContextEntry().add(contextEntry1);
        contextEntry1.getVariable().getName().setValue("entry");
        ContextEntry contextEntry2 = new ContextEntry(){
            {
                this.setVariable(new InformationItem());
            }
        };
        this.context.getContextEntry().add(contextEntry2);
        contextEntry2.getVariable().getName().setValue(ContextEntryDefaultValueUtilities.getNewContextEntryName((Context)this.context));
        Assertions.assertThat((String)contextEntry2.getVariable().getName().getValue()).isEqualTo((Object)(ContextEntryDefaultValueUtilities.PREFIX + "1"));
    }

    @Test
    public void testGetNewContextEntryNameWithDeletion() {
        ContextEntry contextEntry1 = new ContextEntry(){
            {
                this.setVariable(new InformationItem());
            }
        };
        this.context.getContextEntry().add(contextEntry1);
        contextEntry1.getVariable().getName().setValue(ContextEntryDefaultValueUtilities.getNewContextEntryName((Context)this.context));
        Assertions.assertThat((String)contextEntry1.getVariable().getName().getValue()).isEqualTo((Object)(ContextEntryDefaultValueUtilities.PREFIX + "1"));
        ContextEntry contextEntry2 = new ContextEntry(){
            {
                this.setVariable(new InformationItem());
            }
        };
        this.context.getContextEntry().add(contextEntry2);
        contextEntry2.getVariable().getName().setValue(ContextEntryDefaultValueUtilities.getNewContextEntryName((Context)this.context));
        Assertions.assertThat((String)contextEntry2.getVariable().getName().getValue()).isEqualTo((Object)(ContextEntryDefaultValueUtilities.PREFIX + "2"));
        this.context.getContextEntry().remove(contextEntry1);
        ContextEntry contextEntry3 = new ContextEntry(){
            {
                this.setVariable(new InformationItem());
            }
        };
        this.context.getContextEntry().add(contextEntry3);
        contextEntry3.getVariable().getName().setValue(ContextEntryDefaultValueUtilities.getNewContextEntryName((Context)this.context));
        Assertions.assertThat((String)contextEntry3.getVariable().getName().getValue()).isEqualTo((Object)(ContextEntryDefaultValueUtilities.PREFIX + "3"));
    }
}

