/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.context;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Text;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwtmockito.GwtMockito;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.InformationItemCell;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridCellEditAction;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.themes.GridRendererTheme;

@RunWith(value=LienzoMockitoTestRunner.class)
public class InformationItemCellNameTest {
    protected static final String VALUE1 = "value1";
    protected static final String VALUE2 = "value2";
    @Mock
    protected ListSelectorView.Presenter listSelector;
    @Mock
    protected GridBodyCellRenderContext cellRenderContext;
    @Mock
    private GridRenderer gridRenderer;
    @Mock
    private GridRendererTheme gridRendererTheme;
    @Mock
    protected Text text1;
    @Mock
    protected Text text2;
    @Mock
    protected Group group;
    protected InformationItemCell cell;

    @Before
    public void setup() {
        GwtMockito.useProviderForType(Group.class, aClass -> this.group);
        Mockito.when((Object)this.cellRenderContext.getRenderer()).thenReturn((Object)this.gridRenderer);
        Mockito.when((Object)this.gridRenderer.getTheme()).thenReturn((Object)this.gridRendererTheme);
        Mockito.when((Object)this.gridRendererTheme.getHeaderText()).thenReturn((Object)this.text1, (Object[])new Text[]{this.text2});
        Mockito.when((Object)this.gridRendererTheme.getBodyText()).thenReturn((Object)this.text1);
        this.cell = this.makeInformationItemCell();
    }

    protected InformationItemCell makeInformationItemCell() {
        return new InformationItemCell(() -> InformationItemCell.HasNameCell.wrap((String)VALUE1), this.listSelector);
    }

    @Test
    public void testSupportedEditAction() {
        Assertions.assertThat((Comparable)this.cell.getSupportedEditAction()).isEqualTo((Object)GridCellEditAction.SINGLE_CLICK);
    }

    @Test
    public void testGetName() {
        Assertions.assertThat((Object)this.cell.getValue()).isNotNull();
        Assertions.assertThat((String)((InformationItemCell.HasNameCell)this.cell.getValue().getValue()).getName().getValue()).isEqualTo((Object)VALUE1);
    }

    public void testSetName() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((InformationItemCell.HasNameCell)this.cell.getValue().getValue()).setName(new Name(VALUE2))).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("HasNameCell.setName(Name) on a wrapped String is not supported.");
    }

    @Test
    public void testRenderCell() {
        ((InformationItemCell.HasNameCell)this.cell.getValue().getValue()).render(this.cellRenderContext);
        ((Group)Mockito.verify((Object)this.group)).add((IPrimitive)this.text1);
    }
}

