/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.dtable;

import java.util.List;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.dmn.api.definition.v1_1.ConstraintType;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionRule;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.v1_1.InputClause;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.v1_1.OutputClause;
import org.kie.workbench.common.dmn.api.definition.v1_1.UnaryTests;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionRuleFactory;

public class DecisionRuleFactoryTest {
    private static final String INPUT_CLAUSE_TEXT_1 = "input1";
    private static final String INPUT_CLAUSE_TEXT_2 = "input2";
    private static final String OUTPUT_CLAUSE_TEXT_1 = "output1";
    private static final String OUTPUT_CLAUSE_TEXT_2 = "output2";
    private static final String DESCRIPTION_TEXT = "description";
    private DecisionTable dtable;

    @Before
    public void setup() {
        this.dtable = new DecisionTable();
        this.dtable.getInput().add(new InputClause());
        this.dtable.getInput().add(new InputClause());
        this.dtable.getOutput().add(new OutputClause());
        this.dtable.getOutput().add(new OutputClause());
    }

    @Test
    public void testMakeDecisionRule() {
        DecisionRule rule = DecisionRuleFactory.makeDecisionRule((DecisionTable)this.dtable);
        List inputEntries = rule.getInputEntry();
        Assertions.assertThat((int)inputEntries.size()).isEqualTo(2);
        ((ListAssert)((ListAssert)Assertions.assertThat((List)inputEntries).allSatisfy(unaryTests -> this.assertUnaryTestsText((UnaryTests)unaryTests, ""))).allSatisfy(unaryTests -> {
            AbstractComparableAssert cfr_ignored_0 = (AbstractComparableAssert)Assertions.assertThat((Comparable)unaryTests.getConstraintType()).isEqualTo((Object)ConstraintType.NONE);
        })).allSatisfy(unaryTests -> {
            AbstractObjectAssert cfr_ignored_0 = (AbstractObjectAssert)Assertions.assertThat((Object)unaryTests.getParent()).isEqualTo((Object)rule);
        });
        List outputEntries = rule.getOutputEntry();
        Assertions.assertThat((int)outputEntries.size()).isEqualTo(2);
        ((ListAssert)Assertions.assertThat((List)outputEntries).allSatisfy(literalExpression -> this.assertLiteralExpressionText((LiteralExpression)literalExpression, ""))).allSatisfy(literalExpression -> {
            AbstractObjectAssert cfr_ignored_0 = (AbstractObjectAssert)Assertions.assertThat((Object)literalExpression.getParent()).isEqualTo((Object)rule);
        });
        Assertions.assertThat((String)rule.getDescription().getValue()).isEqualTo((Object)"");
        Assertions.assertThat((Object)rule.getParent()).isEqualTo((Object)this.dtable);
    }

    @Test
    public void testDuplicateDecisionRule() {
        DecisionRule rule = DecisionRuleFactory.makeDecisionRule((DecisionTable)this.dtable);
        List inputEntries = rule.getInputEntry();
        Assertions.assertThat((int)inputEntries.size()).isEqualTo(2);
        ((UnaryTests)inputEntries.get(0)).getText().setValue(INPUT_CLAUSE_TEXT_1);
        ((UnaryTests)inputEntries.get(1)).getText().setValue(INPUT_CLAUSE_TEXT_2);
        ((UnaryTests)inputEntries.get(0)).setConstraintType(ConstraintType.ENUMERATION);
        ((UnaryTests)inputEntries.get(1)).setConstraintType(ConstraintType.RANGE);
        List outputEntries = rule.getOutputEntry();
        Assertions.assertThat((int)outputEntries.size()).isEqualTo(2);
        ((LiteralExpression)outputEntries.get(0)).getText().setValue(OUTPUT_CLAUSE_TEXT_1);
        ((LiteralExpression)outputEntries.get(1)).getText().setValue(OUTPUT_CLAUSE_TEXT_2);
        rule.getDescription().setValue(DESCRIPTION_TEXT);
        this.dtable.getRule().add(rule);
        DecisionRule duplicate = DecisionRuleFactory.duplicateDecisionRule((int)0, (DecisionTable)this.dtable);
        List duplicateInputEntries = duplicate.getInputEntry();
        Assertions.assertThat((int)duplicateInputEntries.size()).isEqualTo(2);
        this.assertUnaryTestsText((UnaryTests)duplicateInputEntries.get(0), INPUT_CLAUSE_TEXT_1);
        this.assertUnaryTestsText((UnaryTests)duplicateInputEntries.get(1), INPUT_CLAUSE_TEXT_2);
        Assertions.assertThat((Comparable)((UnaryTests)duplicateInputEntries.get(0)).getConstraintType()).isEqualTo((Object)ConstraintType.ENUMERATION);
        Assertions.assertThat((Comparable)((UnaryTests)duplicateInputEntries.get(1)).getConstraintType()).isEqualTo((Object)ConstraintType.RANGE);
        this.assertUnaryTestsInstancesAreNotTheSame((UnaryTests)inputEntries.get(0), (UnaryTests)duplicateInputEntries.get(0));
        this.assertUnaryTestsInstancesAreNotTheSame((UnaryTests)inputEntries.get(1), (UnaryTests)duplicateInputEntries.get(1));
        Assertions.assertThat((List)duplicateInputEntries).allSatisfy(unaryTests -> {
            AbstractObjectAssert cfr_ignored_0 = (AbstractObjectAssert)Assertions.assertThat((Object)unaryTests.getParent()).isEqualTo((Object)duplicate);
        });
        List duplicateOutputEntries = duplicate.getOutputEntry();
        Assertions.assertThat((int)duplicateOutputEntries.size()).isEqualTo(2);
        this.assertLiteralExpressionText((LiteralExpression)duplicateOutputEntries.get(0), OUTPUT_CLAUSE_TEXT_1);
        this.assertLiteralExpressionText((LiteralExpression)duplicateOutputEntries.get(1), OUTPUT_CLAUSE_TEXT_2);
        this.assertLiteralExpressionInstancesAreNotTheSame((LiteralExpression)outputEntries.get(0), (LiteralExpression)duplicateOutputEntries.get(0));
        this.assertLiteralExpressionInstancesAreNotTheSame((LiteralExpression)outputEntries.get(1), (LiteralExpression)duplicateOutputEntries.get(1));
        Assertions.assertThat((List)duplicateOutputEntries).allSatisfy(literalExpression -> {
            AbstractObjectAssert cfr_ignored_0 = (AbstractObjectAssert)Assertions.assertThat((Object)literalExpression.getParent()).isEqualTo((Object)duplicate);
        });
        Assertions.assertThat((String)duplicate.getDescription().getValue()).isEqualTo((Object)DESCRIPTION_TEXT);
        Assertions.assertThat((Object)duplicate.getParent()).isEqualTo((Object)this.dtable);
    }

    private void assertUnaryTestsText(UnaryTests unaryTests, String expectedText) {
        Assertions.assertThat((String)unaryTests.getText().getValue()).isEqualTo((Object)expectedText);
    }

    private void assertUnaryTestsInstancesAreNotTheSame(UnaryTests unaryTests1, UnaryTests unaryTests2) {
        Assertions.assertThat((Object)unaryTests1).isNotSameAs((Object)unaryTests2);
        Assertions.assertThat((Object)unaryTests1.getText()).isNotSameAs((Object)unaryTests2.getText());
    }

    private void assertLiteralExpressionText(LiteralExpression literalExpression, String expectedText) {
        Assertions.assertThat((String)literalExpression.getText().getValue()).isEqualTo((Object)expectedText);
    }

    private void assertLiteralExpressionInstancesAreNotTheSame(LiteralExpression literalExpression1, LiteralExpression literalExpression2) {
        Assertions.assertThat((Object)literalExpression1).isNotSameAs((Object)literalExpression2);
        Assertions.assertThat((Object)literalExpression1.getText()).isNotSameAs((Object)literalExpression2.getText());
    }
}

