/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.dtable;

import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.v1_1.InputClause;
import org.kie.workbench.common.dmn.api.definition.v1_1.InputClauseLiteralExpression;
import org.kie.workbench.common.dmn.api.definition.v1_1.OutputClause;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionTableDefaultValueUtilities;

public class DecisionTableDefaultValueUtilitiesTest {
    private DecisionTable dtable;

    @Before
    public void setup() {
        this.dtable = new DecisionTable();
    }

    @Test
    public void testGetNewInputClauseName() {
        InputClause inputClause1 = new InputClause(){
            {
                this.setInputExpression(new InputClauseLiteralExpression());
            }
        };
        this.dtable.getInput().add(inputClause1);
        inputClause1.getInputExpression().getText().setValue(DecisionTableDefaultValueUtilities.getNewInputClauseName((DecisionTable)this.dtable));
        Assertions.assertThat((String)inputClause1.getInputExpression().getText().getValue()).isEqualTo((Object)"input-1");
        InputClause inputClause2 = new InputClause(){
            {
                this.setInputExpression(new InputClauseLiteralExpression());
            }
        };
        this.dtable.getInput().add(inputClause2);
        inputClause2.getInputExpression().getText().setValue(DecisionTableDefaultValueUtilities.getNewInputClauseName((DecisionTable)this.dtable));
        Assertions.assertThat((String)inputClause2.getInputExpression().getText().getValue()).isEqualTo((Object)"input-2");
    }

    @Test
    public void testGetNewInputClauseNameWithExistingInputClauses() {
        InputClause inputClause1 = new InputClause(){
            {
                this.setInputExpression(new InputClauseLiteralExpression());
            }
        };
        this.dtable.getInput().add(inputClause1);
        inputClause1.getInputExpression().getText().setValue("input");
        InputClause inputClause2 = new InputClause(){
            {
                this.setInputExpression(new InputClauseLiteralExpression());
            }
        };
        this.dtable.getInput().add(inputClause2);
        inputClause2.getInputExpression().getText().setValue(DecisionTableDefaultValueUtilities.getNewInputClauseName((DecisionTable)this.dtable));
        Assertions.assertThat((String)inputClause2.getInputExpression().getText().getValue()).isEqualTo((Object)"input-1");
    }

    @Test
    public void testGetNewInputClauseNameWithDeletion() {
        InputClause inputClause1 = new InputClause(){
            {
                this.setInputExpression(new InputClauseLiteralExpression());
            }
        };
        this.dtable.getInput().add(inputClause1);
        inputClause1.getInputExpression().getText().setValue(DecisionTableDefaultValueUtilities.getNewInputClauseName((DecisionTable)this.dtable));
        Assertions.assertThat((String)inputClause1.getInputExpression().getText().getValue()).isEqualTo((Object)"input-1");
        InputClause inputClause2 = new InputClause(){
            {
                this.setInputExpression(new InputClauseLiteralExpression());
            }
        };
        this.dtable.getInput().add(inputClause2);
        inputClause2.getInputExpression().getText().setValue(DecisionTableDefaultValueUtilities.getNewInputClauseName((DecisionTable)this.dtable));
        Assertions.assertThat((String)inputClause2.getInputExpression().getText().getValue()).isEqualTo((Object)"input-2");
        this.dtable.getInput().remove(inputClause1);
        InputClause inputClause3 = new InputClause(){
            {
                this.setInputExpression(new InputClauseLiteralExpression());
            }
        };
        this.dtable.getInput().add(inputClause3);
        inputClause3.getInputExpression().getText().setValue(DecisionTableDefaultValueUtilities.getNewInputClauseName((DecisionTable)this.dtable));
        Assertions.assertThat((String)inputClause3.getInputExpression().getText().getValue()).isEqualTo((Object)"input-3");
    }

    @Test
    public void testGetNewOutputClauseName() {
        OutputClause outputClause1 = new OutputClause();
        this.dtable.getOutput().add(outputClause1);
        outputClause1.setName(DecisionTableDefaultValueUtilities.getNewOutputClauseName((DecisionTable)this.dtable));
        Assertions.assertThat((String)outputClause1.getName()).isEqualTo((Object)"output-1");
        OutputClause outputClause2 = new OutputClause();
        this.dtable.getOutput().add(outputClause2);
        outputClause2.setName(DecisionTableDefaultValueUtilities.getNewOutputClauseName((DecisionTable)this.dtable));
        Assertions.assertThat((String)outputClause2.getName()).isEqualTo((Object)"output-2");
    }

    @Test
    public void testGetNewOutputClauseNameWithExistingOutputClauses() {
        OutputClause outputClause1 = new OutputClause();
        this.dtable.getOutput().add(outputClause1);
        outputClause1.setName("output");
        OutputClause outputClause2 = new OutputClause();
        this.dtable.getOutput().add(outputClause2);
        outputClause2.setName(DecisionTableDefaultValueUtilities.getNewOutputClauseName((DecisionTable)this.dtable));
        Assertions.assertThat((String)outputClause2.getName()).isEqualTo((Object)"output-1");
    }

    @Test
    public void testGetNewOutputClauseNameWithDeletion() {
        OutputClause outputClause1 = new OutputClause();
        this.dtable.getOutput().add(outputClause1);
        outputClause1.setName(DecisionTableDefaultValueUtilities.getNewOutputClauseName((DecisionTable)this.dtable));
        Assertions.assertThat((String)outputClause1.getName()).isEqualTo((Object)"output-1");
        OutputClause outputClause2 = new OutputClause();
        this.dtable.getOutput().add(outputClause2);
        outputClause2.setName(DecisionTableDefaultValueUtilities.getNewOutputClauseName((DecisionTable)this.dtable));
        Assertions.assertThat((String)outputClause2.getName()).isEqualTo((Object)"output-2");
        this.dtable.getOutput().remove(outputClause1);
        OutputClause outputClause3 = new OutputClause();
        this.dtable.getOutput().add(outputClause3);
        outputClause3.setName(DecisionTableDefaultValueUtilities.getNewOutputClauseName((DecisionTable)this.dtable));
        Assertions.assertThat((String)outputClause3.getName()).isEqualTo((Object)"output-3");
    }
}

