/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.dtable;

import java.util.Optional;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionRule;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.v1_1.InputClause;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.v1_1.OutputClause;
import org.kie.workbench.common.dmn.api.definition.v1_1.UnaryTests;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionTableGridCell;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionTableRowNumberColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionTableUIModelMapper;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DescriptionColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.InputClauseColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.OutputClauseColumn;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.impl.RowSelectionStrategy;

@RunWith(value=MockitoJUnitRunner.class)
public class DecisionTableUIModelMapperTest {
    @Mock
    private DecisionTableRowNumberColumn uiRowNumberColumn;
    @Mock
    private InputClauseColumn uiInputClauseColumn;
    @Mock
    private OutputClauseColumn uiOutputClauseColumn;
    @Mock
    private DescriptionColumn uiDescriptionColumn;
    @Mock
    private ListSelectorView.Presenter listSelector;
    private BaseGridData uiModel;
    private DecisionTable dtable;
    private Supplier<Optional<GridCellValue<?>>> cellValueSupplier;
    private DecisionTableUIModelMapper mapper;

    @Before
    public void setup() {
        this.uiModel = new BaseGridData();
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.uiModel.appendColumn((GridColumn)this.uiRowNumberColumn);
        this.uiModel.appendColumn((GridColumn)this.uiInputClauseColumn);
        this.uiModel.appendColumn((GridColumn)this.uiOutputClauseColumn);
        this.uiModel.appendColumn((GridColumn)this.uiDescriptionColumn);
        ((DecisionTableRowNumberColumn)Mockito.doReturn((Object)0).when((Object)this.uiRowNumberColumn)).getIndex();
        ((InputClauseColumn)Mockito.doReturn((Object)1).when((Object)this.uiInputClauseColumn)).getIndex();
        ((OutputClauseColumn)Mockito.doReturn((Object)2).when((Object)this.uiOutputClauseColumn)).getIndex();
        ((DescriptionColumn)Mockito.doReturn((Object)3).when((Object)this.uiDescriptionColumn)).getIndex();
        this.dtable = new DecisionTable();
        this.dtable.getInput().add(new InputClause());
        this.dtable.getOutput().add(new OutputClause());
        this.dtable.getRule().add(new DecisionRule(){
            {
                this.getInputEntry().add(new UnaryTests(){
                    {
                        this.getText().setValue("i1");
                    }
                });
                this.getOutputEntry().add(new LiteralExpression(){
                    {
                        this.getText().setValue("o1");
                    }
                });
                this.setDescription(new Description("desc1"));
            }
        });
        this.dtable.getRule().add(new DecisionRule(){
            {
                this.getInputEntry().add(new UnaryTests(){
                    {
                        this.getText().setValue("i2");
                    }
                });
                this.getOutputEntry().add(new LiteralExpression(){
                    {
                        this.getText().setValue("o2");
                    }
                });
                this.setDescription(new Description("desc2"));
            }
        });
        this.mapper = new DecisionTableUIModelMapper(() -> this.uiModel, () -> Optional.of(this.dtable), this.listSelector);
        this.cellValueSupplier = Optional::empty;
    }

    @Test
    public void testFromDMNModelRowNumber() {
        this.mapper.fromDMNModel(0, 0);
        this.mapper.fromDMNModel(1, 0);
        Assert.assertEquals((Object)1, (Object)this.uiModel.getCell(0, 0).getValue().getValue());
        Assert.assertEquals((Object)RowSelectionStrategy.INSTANCE, (Object)this.uiModel.getCell(0, 0).getSelectionStrategy());
        Assert.assertTrue((boolean)(this.uiModel.getCell(0, 0) instanceof DecisionTableGridCell));
        Assert.assertEquals((Object)2, (Object)this.uiModel.getCell(1, 0).getValue().getValue());
        Assert.assertEquals((Object)RowSelectionStrategy.INSTANCE, (Object)this.uiModel.getCell(1, 0).getSelectionStrategy());
        Assert.assertTrue((boolean)(this.uiModel.getCell(1, 0) instanceof DecisionTableGridCell));
    }

    @Test
    public void testFromDMNModelInputClause() {
        this.mapper.fromDMNModel(0, 1);
        this.mapper.fromDMNModel(1, 1);
        Assert.assertEquals((Object)"i1", (Object)this.uiModel.getCell(0, 1).getValue().getValue());
        Assert.assertTrue((boolean)(this.uiModel.getCell(0, 1) instanceof DecisionTableGridCell));
        Assert.assertEquals((Object)"i2", (Object)this.uiModel.getCell(1, 1).getValue().getValue());
        Assert.assertTrue((boolean)(this.uiModel.getCell(1, 1) instanceof DecisionTableGridCell));
    }

    @Test
    public void testFromDMNModelOutputClause() {
        this.mapper.fromDMNModel(0, 2);
        this.mapper.fromDMNModel(1, 2);
        Assert.assertEquals((Object)"o1", (Object)this.uiModel.getCell(0, 2).getValue().getValue());
        Assert.assertTrue((boolean)(this.uiModel.getCell(0, 2) instanceof DecisionTableGridCell));
        Assert.assertEquals((Object)"o2", (Object)this.uiModel.getCell(1, 2).getValue().getValue());
        Assert.assertTrue((boolean)(this.uiModel.getCell(1, 2) instanceof DecisionTableGridCell));
    }

    @Test
    public void testFromDMNModelDescription() {
        this.mapper.fromDMNModel(0, 3);
        this.mapper.fromDMNModel(1, 3);
        Assert.assertEquals((Object)"desc1", (Object)this.uiModel.getCell(0, 3).getValue().getValue());
        Assert.assertTrue((boolean)(this.uiModel.getCell(0, 3) instanceof DecisionTableGridCell));
        Assert.assertEquals((Object)"desc2", (Object)this.uiModel.getCell(1, 3).getValue().getValue());
        Assert.assertTrue((boolean)(this.uiModel.getCell(1, 3) instanceof DecisionTableGridCell));
    }

    @Test
    public void testToDMNModelInputClause() {
        this.mapper.toDMNModel(0, 1, Optional::empty);
        this.mapper.toDMNModel(1, 1, () -> Optional.of(new BaseGridCellValue((Object)"value")));
        Assert.assertEquals((Object)"", (Object)((UnaryTests)((DecisionRule)this.dtable.getRule().get(0)).getInputEntry().get(0)).getText().getValue());
        Assert.assertEquals((Object)"value", (Object)((UnaryTests)((DecisionRule)this.dtable.getRule().get(1)).getInputEntry().get(0)).getText().getValue());
    }

    @Test
    public void testToDMNModelOutputClause() {
        this.mapper.toDMNModel(0, 2, Optional::empty);
        this.mapper.toDMNModel(1, 2, () -> Optional.of(new BaseGridCellValue((Object)"value")));
        Assert.assertEquals((Object)"", (Object)((LiteralExpression)((DecisionRule)this.dtable.getRule().get(0)).getOutputEntry().get(0)).getText().getValue());
        Assert.assertEquals((Object)"value", (Object)((LiteralExpression)((DecisionRule)this.dtable.getRule().get(1)).getOutputEntry().get(0)).getText().getValue());
    }

    @Test
    public void testToDMNModelDescription() {
        this.mapper.toDMNModel(0, 3, Optional::empty);
        this.mapper.toDMNModel(1, 3, () -> Optional.of(new BaseGridCellValue((Object)"value")));
        Assert.assertEquals((Object)"", (Object)((DecisionRule)this.dtable.getRule().get(0)).getDescription().getValue());
        Assert.assertEquals((Object)"value", (Object)((DecisionRule)this.dtable.getRule().get(1)).getDescription().getValue());
    }
}

