/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.function;

import com.ait.lienzo.client.core.types.Transform;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.v1_1.FunctionDefinition;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.FunctionColumnParametersHeaderMetaData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.FunctionGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.KindUtilities;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.parameters.ParametersPopoverView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;

@RunWith(value=LienzoMockitoTestRunner.class)
public class FunctionColumnParametersHeaderMetaDataTest {
    @Mock
    private CellEditorControlsView.Presenter cellEditorControls;
    @Mock
    private ParametersPopoverView.Presenter parametersEditor;
    @Mock
    private FunctionGrid gridWidget;
    @Mock
    private Transform transform;
    @Mock
    private GridRenderer renderer;
    @Mock
    private TranslationService translationService;
    private FunctionDefinition function;
    private Supplier<Optional<FunctionDefinition>> functionSupplier;
    private FunctionColumnParametersHeaderMetaData header;

    @Before
    public void setup() {
        this.function = new FunctionDefinition();
        this.functionSupplier = () -> Optional.ofNullable(this.function);
        this.header = new FunctionColumnParametersHeaderMetaData(this.functionSupplier, this.translationService, this.cellEditorControls, this.parametersEditor, Optional.of("FunctionEditor.EditParametersTitle"), this.gridWidget);
        Mockito.when((Object)this.translationService.getTranslation(Matchers.anyString())).thenAnswer(i -> i.getArguments()[0]);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSetColumnGroup() {
        this.header.setColumnGroup("group");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSetTitle() {
        this.header.setTitle("title");
    }

    @Test
    public void testGetExpressionLanguageTitle() {
        KindUtilities.setKind((FunctionDefinition)this.function, (FunctionDefinition.Kind)FunctionDefinition.Kind.FEEL);
        Assert.assertEquals((Object)FunctionDefinition.Kind.FEEL.code(), (Object)this.header.getExpressionLanguageTitle());
    }

    @Test
    public void testGetFormalParametersTitleOneParameter() {
        this.setupFormalParameters("p0");
        Assert.assertEquals((Object)"(p0)", (Object)this.header.getFormalParametersTitle());
    }

    @Test
    public void testGetFormalParametersTitleMultipleParameters() {
        this.setupFormalParameters("p0", "p1");
        Assert.assertEquals((Object)"(p0, p1)", (Object)this.header.getFormalParametersTitle());
    }

    @Test
    public void testGetColumnGroup() {
        Assert.assertEquals((Object)"FunctionColumnParametersHeaderMetaData$Parameters", (Object)this.header.getColumnGroup());
    }

    @Test
    public void testGetTitle() {
        KindUtilities.setKind((FunctionDefinition)this.function, (FunctionDefinition.Kind)FunctionDefinition.Kind.FEEL);
        this.setupFormalParameters("p0", "p1");
        Assert.assertEquals((Object)"(p0, p1)", (Object)this.header.getTitle());
    }

    private void setupFormalParameters(String ... parameters) {
        Arrays.asList(parameters).forEach(p -> this.function.getFormalParameter().add(new InformationItem((String)p){
            final /* synthetic */ String val$p;
            {
                this.val$p = string;
                this.setName(new Name(this.val$p));
            }
        }));
    }
}

