/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.function.supplementary.pmml;

import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.supplementary.pmml.LiteralExpressionPMMLColumnRenderer;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCell;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;

public class LiteralExpressionPMMLColumnRendererTest {
    private static final String PLACEHOLDER = "placeholder";
    private LiteralExpressionPMMLColumnRenderer renderer;

    @Before
    public void setup() {
        this.renderer = new LiteralExpressionPMMLColumnRenderer();
    }

    @Test
    public void testShowPlaceHolder_WithNullCellWithNullPlaceHolder() {
        Assertions.assertThat((boolean)this.renderer.isPlaceHolderToBeShown(null)).isFalse();
    }

    @Test
    public void testShowPlaceHolder_WithNullCellValueWithNullPlaceHolder() {
        Assertions.assertThat((boolean)this.renderer.isPlaceHolderToBeShown((GridCell)new BaseGridCell(null))).isFalse();
    }

    @Test
    public void testShowPlaceHolder_WithEmptyCellValueWithEmptyValueWithNullPlaceHolder() {
        Assertions.assertThat((boolean)this.renderer.isPlaceHolderToBeShown((GridCell)new BaseGridCell((GridCellValue)new BaseGridCellValue((Object)"")))).isFalse();
    }

    @Test
    public void testShowPlaceHolder_WithNullEmptyCellValueWithNullValueWithNullPlaceHolder() {
        Assertions.assertThat((boolean)this.renderer.isPlaceHolderToBeShown((GridCell)new BaseGridCell((GridCellValue)new BaseGridCellValue(null)))).isFalse();
    }

    @Test
    public void testShowPlaceHolder_WithEmptyCellValueWithEmptyValueWithPlaceHolder() {
        Assertions.assertThat((boolean)this.renderer.isPlaceHolderToBeShown((GridCell)new BaseGridCell((GridCellValue)new BaseGridCellValue((Object)"", PLACEHOLDER)))).isTrue();
    }

    @Test
    public void testShowPlaceHolder_WithEmptyCellValueWithNullValueWithPlaceHolder() {
        Assertions.assertThat((boolean)this.renderer.isPlaceHolderToBeShown((GridCell)new BaseGridCell((GridCellValue)new BaseGridCellValue(null, PLACEHOLDER)))).isTrue();
    }
}

