/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.invocation;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.v1_1.Binding;
import org.kie.workbench.common.dmn.api.definition.v1_1.Invocation;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.client.commands.factory.DefaultCanvasCommandFactory;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionType;
import org.kie.workbench.common.dmn.client.editors.expressions.types.invocation.InvocationEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.invocation.InvocationGrid;
import org.kie.workbench.common.dmn.client.editors.types.NameAndDataTypePopoverView;
import org.kie.workbench.common.dmn.client.session.DMNSession;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.ExpressionEditorChanged;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=LienzoMockitoTestRunner.class)
public class InvocationEditorDefinitionTest {
    @Mock
    private DMNGridPanel gridPanel;
    @Mock
    private DMNGridLayer gridLayer;
    @Mock
    private DefinitionUtils definitionUtils;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private DMNSession session;
    @Mock
    private SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    private DefaultCanvasCommandFactory canvasCommandFactory;
    @Mock
    private CellEditorControlsView.Presenter cellEditorControls;
    @Mock
    private ListSelectorView.Presenter listSelector;
    @Mock
    private TranslationService translationService;
    @Mock
    private Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    @Mock
    private NameAndDataTypePopoverView.Presenter headerEditor;
    @Mock
    private GridWidget parentGridWidget;
    @Mock
    private GridData parentGridData;
    @Mock
    private GridColumn parentGridColumn;
    @Mock
    private GridCellTuple parent;
    @Mock
    private HasExpression hasExpression;
    @Mock
    private EventSourceMock<ExpressionEditorChanged> editorSelectedEvent;
    @Mock
    private EventSourceMock<RefreshFormPropertiesEvent> refreshFormPropertiesEvent;
    @Mock
    private EventSourceMock<DomainObjectSelectionEvent> domainObjectSelectionEvent;
    private Optional<HasName> hasName = Optional.empty();
    private InvocationEditorDefinition definition;

    @Before
    public void setup() {
        Mockito.when((Object)this.parent.getGridWidget()).thenReturn((Object)this.parentGridWidget);
        Mockito.when((Object)this.parentGridWidget.getModel()).thenReturn((Object)this.parentGridData);
        Mockito.when((Object)this.parentGridData.getColumns()).thenReturn(Collections.singletonList(this.parentGridColumn));
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getGridPanel()).thenReturn((Object)this.gridPanel);
        Mockito.when((Object)this.session.getGridLayer()).thenReturn((Object)this.gridLayer);
        Mockito.when((Object)this.session.getCellEditorControls()).thenReturn((Object)this.cellEditorControls);
        this.definition = new InvocationEditorDefinition(this.definitionUtils, this.sessionManager, this.sessionCommandManager, this.canvasCommandFactory, this.editorSelectedEvent, this.refreshFormPropertiesEvent, this.domainObjectSelectionEvent, this.listSelector, this.translationService, this.expressionEditorDefinitionsSupplier, this.headerEditor);
        ExpressionEditorDefinitions expressionEditorDefinitions = new ExpressionEditorDefinitions();
        expressionEditorDefinitions.add((Object)this.definition);
        ((Supplier)Mockito.doReturn((Object)expressionEditorDefinitions).when(this.expressionEditorDefinitionsSupplier)).get();
        ((TranslationService)Mockito.doAnswer(i -> i.getArguments()[0].toString()).when((Object)this.translationService)).format(Matchers.anyString(), new Object[0]);
        ((TranslationService)Mockito.doAnswer(i -> i.getArguments()[0].toString()).when((Object)this.translationService)).getTranslation(Matchers.anyString());
    }

    @Test
    public void testType() {
        Assert.assertEquals((Object)ExpressionType.INVOCATION, (Object)this.definition.getType());
    }

    @Test
    public void testName() {
        Assert.assertEquals((Object)"ExpressionEditor.InvocationType", (Object)this.definition.getName());
    }

    @Test
    public void testModelDefinition() {
        Optional oModel = this.definition.getModelClass();
        Assert.assertTrue((boolean)oModel.isPresent());
    }

    @Test
    public void testModelEnrichment() {
        Optional oModel = this.definition.getModelClass();
        this.definition.enrich(Optional.empty(), this.hasExpression, oModel);
        Invocation model = (Invocation)oModel.get();
        Assert.assertNotNull((Object)model.getExpression());
        Assert.assertTrue((boolean)(model.getExpression() instanceof LiteralExpression));
        Assert.assertEquals((long)1L, (long)model.getBinding().size());
        Assert.assertNotNull((Object)((Binding)model.getBinding().get(0)).getParameter());
        Assert.assertEquals((Object)"p-1", (Object)((Binding)model.getBinding().get(0)).getParameter().getName().getValue());
        Assert.assertNull((Object)((Binding)model.getBinding().get(0)).getExpression());
        Assert.assertNotNull((Object)model.getId());
        Assert.assertEquals((Object)model, (Object)model.getExpression().getParent());
        Assert.assertEquals((Object)model, (Object)((Binding)model.getBinding().get(0)).getParent());
        Assert.assertEquals(model.getBinding().get(0), (Object)((Binding)model.getBinding().get(0)).getParameter().getParent());
    }

    @Test
    public void testEditor() {
        Mockito.when((Object)this.hasExpression.getExpression()).thenReturn(this.definition.getModelClass().get());
        Optional oEditor = this.definition.getEditor(this.parent, Optional.empty(), this.hasExpression, this.hasName, false, 0);
        Assert.assertTrue((boolean)oEditor.isPresent());
        GridWidget editor = (GridWidget)oEditor.get();
        Assert.assertTrue((boolean)(editor instanceof InvocationGrid));
    }

    @Test
    public void testIsUserSelectable() {
        Assertions.assertThat((boolean)this.definition.isUserSelectable()).isTrue();
    }
}

