/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.relation;

import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Transform;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.user.client.ui.AbsolutePanel;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.NOPDomainObject;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.v1_1.Decision;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.v1_1.Relation;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.client.commands.expressions.types.relation.AddRelationColumnCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.relation.AddRelationRowCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.relation.DeleteRelationColumnCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.relation.DeleteRelationRowCommand;
import org.kie.workbench.common.dmn.client.commands.factory.DefaultCanvasCommandFactory;
import org.kie.workbench.common.dmn.client.commands.general.DeleteCellValueCommand;
import org.kie.workbench.common.dmn.client.commands.general.DeleteHasNameCommand;
import org.kie.workbench.common.dmn.client.commands.general.SetCellValueCommand;
import org.kie.workbench.common.dmn.client.commands.general.SetHasNameCommand;
import org.kie.workbench.common.dmn.client.commands.general.SetTypeRefCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.GridFactoryCommandUtils;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationColumnHeaderMetaData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationGridData;
import org.kie.workbench.common.dmn.client.editors.types.NameAndDataTypePopoverView;
import org.kie.workbench.common.dmn.client.session.DMNSession;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.factory.TextAreaSingletonDOMElementFactory;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.HasCellEditorControls;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.HasListSelectorControl;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.ExpressionEditorChanged;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellValueTuple;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommand;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseBounds;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLayerRedrawManager;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;

@RunWith(value=LienzoMockitoTestRunner.class)
public class RelationGridTest {
    private static final int HEADER_COLUMNS = 0;
    private static final int INSERT_COLUMN_BEFORE = 1;
    private static final int INSERT_COLUMN_AFTER = 2;
    private static final int DELETE_COLUMN = 3;
    private static final int HEADER_ROWS = 4;
    private static final int INSERT_ROW_ABOVE = 5;
    private static final int INSERT_ROW_BELOW = 6;
    private static final int DELETE_ROW = 7;
    private static final String NODE_UUID = "uuid";
    private static final String NAME = "column-1";
    private static final String NAME_NEW = "name-new";
    private GridCellTuple tupleWithoutValue;
    private GridCellValueTuple tupleWithValue;
    @Mock
    private GridWidget parentGridWidget;
    @Mock
    private GridData parentGridData;
    @Mock
    private GridColumn parentGridColumn;
    @Mock
    private Viewport viewport;
    @Mock
    private Transform transform;
    @Mock
    private DMNGridPanel gridPanel;
    @Mock
    private DMNGridLayer gridLayer;
    @Mock
    private AbsolutePanel gridLayerDomElementContainer;
    @Mock
    private GridWidget gridWidget;
    @Mock
    private DefinitionUtils definitionUtils;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private DMNSession session;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private GraphCommandExecutionContext graphContext;
    @Mock
    private Diagram diagram;
    @Mock
    private Graph graph;
    @Mock
    private Node node;
    @Mock
    private SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    private DefaultCanvasCommandFactory canvasCommandFactory;
    @Mock
    private CellEditorControlsView.Presenter cellEditorControls;
    @Mock
    private ListSelectorView.Presenter listSelector;
    @Mock
    private TranslationService translationService;
    @Mock
    private EventSourceMock<ExpressionEditorChanged> editorSelectedEvent;
    @Mock
    private EventSourceMock<RefreshFormPropertiesEvent> refreshFormPropertiesEvent;
    @Mock
    private EventSourceMock<DomainObjectSelectionEvent> domainObjectSelectionEvent;
    @Mock
    private NameAndDataTypePopoverView.Presenter headerEditor;
    @Captor
    private ArgumentCaptor<AddRelationColumnCommand> addColumnCommand;
    @Captor
    private ArgumentCaptor<DeleteRelationColumnCommand> deleteColumnCommand;
    @Captor
    private ArgumentCaptor<AddRelationRowCommand> addRowCommand;
    @Captor
    private ArgumentCaptor<DeleteRelationRowCommand> deleteRowCommand;
    @Captor
    private ArgumentCaptor<GridLayerRedrawManager.PrioritizedCommand> redrawCommandCaptor;
    @Captor
    private ArgumentCaptor<CompositeCommand> compositeCommandCaptor;
    @Captor
    private ArgumentCaptor<DomainObjectSelectionEvent> domainObjectSelectionEventCaptor;
    private GridCellTuple parent;
    private Relation relation = new Relation();
    private Decision hasExpression = new Decision();
    private Optional<Relation> expression = Optional.of(this.relation);
    private Optional<HasName> hasName = Optional.empty();
    private RelationEditorDefinition definition;
    private RelationGrid grid;

    @Before
    public void setUp() {
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getGridPanel()).thenReturn((Object)this.gridPanel);
        Mockito.when((Object)this.session.getGridLayer()).thenReturn((Object)this.gridLayer);
        Mockito.when((Object)this.session.getCellEditorControls()).thenReturn((Object)this.cellEditorControls);
        this.tupleWithoutValue = new GridCellTuple(0, 1, this.gridWidget);
        this.tupleWithValue = new GridCellValueTuple(0, 1, this.gridWidget, (GridCellValue)new BaseGridCellValue((Object)"value"));
        this.definition = new RelationEditorDefinition(this.definitionUtils, this.sessionManager, this.sessionCommandManager, this.canvasCommandFactory, this.editorSelectedEvent, this.refreshFormPropertiesEvent, this.domainObjectSelectionEvent, this.listSelector, this.translationService, this.headerEditor);
        Decision decision = new Decision();
        decision.setName(new Name("name"));
        this.hasName = Optional.of(decision);
        this.expression = this.definition.getModelClass();
        this.definition.enrich(Optional.empty(), (HasExpression)this.hasExpression, this.expression);
        Mockito.when((Object)this.session.getCanvasHandler()).thenReturn((Object)this.canvasHandler);
        Mockito.when((Object)this.parentGridWidget.getModel()).thenReturn((Object)this.parentGridData);
        Mockito.when((Object)this.parentGridData.getColumns()).thenReturn(Collections.singletonList(this.parentGridColumn));
        this.parent = (GridCellTuple)Mockito.spy((Object)new GridCellTuple(0, 0, this.parentGridWidget));
        Mockito.when((Object)this.canvasHandler.getDiagram()).thenReturn((Object)this.diagram);
        Mockito.when((Object)this.canvasHandler.getGraphExecutionContext()).thenReturn((Object)this.graphContext);
        Mockito.when((Object)this.diagram.getGraph()).thenReturn((Object)this.graph);
        Mockito.when((Object)this.graph.nodes()).thenReturn(Collections.singletonList(this.node));
        Mockito.when((Object)this.gridWidget.getModel()).thenReturn((Object)new BaseGridData(false));
        Mockito.when((Object)this.gridLayer.getDomElementContainer()).thenReturn((Object)this.gridLayerDomElementContainer);
        Mockito.when((Object)this.gridLayerDomElementContainer.iterator()).thenReturn(Mockito.mock(Iterator.class));
        Mockito.when((Object)this.gridLayer.getVisibleBounds()).thenReturn((Object)new BaseBounds(0.0, 0.0, 200.0, 200.0));
        Mockito.when((Object)this.gridLayer.getViewport()).thenReturn((Object)this.viewport);
        Mockito.when((Object)this.viewport.getTransform()).thenReturn((Object)this.transform);
        ((TranslationService)Mockito.doAnswer(i -> i.getArguments()[0].toString()).when((Object)this.translationService)).format(Matchers.anyString(), new Object[0]);
        ((TranslationService)Mockito.doAnswer(i -> i.getArguments()[0].toString()).when((Object)this.translationService)).getTranslation(Matchers.anyString());
    }

    private void setupGrid(int nesting) {
        this.hasExpression.setExpression((Expression)this.expression.get());
        this.grid = (RelationGrid)Mockito.spy((Object)((RelationGrid)this.definition.getEditor(this.parent, nesting == 0 ? Optional.of(NODE_UUID) : Optional.empty(), (HasExpression)this.hasExpression, this.hasName, false, nesting).get()));
    }

    @Test
    public void testInitialiseUiColumnsEmptyModel() {
        this.expression = Optional.of(new Relation());
        this.setupGrid(0);
        Assert.assertEquals((long)0L, (long)this.grid.getModel().getRowCount());
        Assert.assertEquals((long)1L, (long)this.grid.getModel().getColumns().size());
        Assert.assertTrue((boolean)(this.grid.getModel().getColumns().get(0) instanceof RowNumberColumn));
    }

    @Test
    public void testInitialiseUiColumns() {
        String columnHeader = "first column";
        this.relation.getColumn().add(new InformationItem(){
            {
                this.getName().setValue("first column");
            }
        });
        this.expression = Optional.of(this.relation);
        this.setupGrid(0);
        Assert.assertEquals((long)2L, (long)this.grid.getModel().getColumns().size());
        Assert.assertTrue((boolean)(this.grid.getModel().getColumns().get(0) instanceof RowNumberColumn));
        Assert.assertEquals((Object)"first column", (Object)((GridColumn.HeaderMetaData)((GridColumn)this.grid.getModel().getColumns().get(1)).getHeaderMetaData().get(0)).getTitle());
    }

    @Test
    public void testInitialiseUiModel() {
        this.relation.getColumn().add(new InformationItem(){
            {
                this.getName().setValue("first column header");
            }
        });
        String firstRowValue = "first column value 1";
        String secondRowValue = "first column value 2";
        this.relation.getRow().add(new org.kie.workbench.common.dmn.api.definition.v1_1.List(){
            {
                this.getExpression().add(new LiteralExpression(){
                    {
                        this.getText().setValue("first column value 1");
                    }
                });
            }
        });
        this.relation.getRow().add(new org.kie.workbench.common.dmn.api.definition.v1_1.List(){
            {
                this.getExpression().add(new LiteralExpression(){
                    {
                        this.getText().setValue("first column value 2");
                    }
                });
            }
        });
        this.expression = Optional.of(this.relation);
        this.setupGrid(0);
        Assert.assertEquals((long)2L, (long)this.grid.getModel().getRowCount());
        Assert.assertEquals((Object)"first column value 1", (Object)((GridCell)this.grid.getModel().getRow(0).getCells().get(1)).getValue().getValue());
        Assert.assertEquals((Object)"first column value 2", (Object)((GridCell)this.grid.getModel().getRow(1).getCells().get(1)).getValue().getValue());
    }

    @Test
    public void testInitialSetupFromDefinition() {
        this.setupGrid(0);
        GridData uiModel = this.grid.getModel();
        Assertions.assertThat((Object)uiModel).isInstanceOf(RelationGridData.class);
        Assertions.assertThat((int)uiModel.getColumnCount()).isEqualTo(2);
        Assertions.assertThat(uiModel.getColumns().get(0)).isInstanceOf(RowNumberColumn.class);
        Assertions.assertThat(uiModel.getColumns().get(1)).isInstanceOf(RelationColumn.class);
        Assertions.assertThat((int)uiModel.getRowCount()).isEqualTo(1);
        Assertions.assertThat((Object)uiModel.getCell(0, 0).getValue().getValue()).isEqualTo((Object)1);
        Assertions.assertThat((Object)uiModel.getCell(0, 1).getValue().getValue()).isEqualTo((Object)"");
    }

    @Test
    public void testInitialColumnWidthsFromDefinition() {
        this.setupGrid(0);
        this.assertComponentWidths(50.0, 100.0);
    }

    @Test
    public void testInitialColumnWidthsFromExpression() {
        List componentWidths = this.expression.get().getComponentWidths();
        componentWidths.set(0, 200.0);
        componentWidths.set(1, 300.0);
        this.setupGrid(0);
        this.assertComponentWidths(200.0, 300.0);
    }

    private void assertComponentWidths(double ... widths) {
        GridData uiModel = this.grid.getModel();
        IntStream.range(0, widths.length).forEach(i -> Assert.assertEquals((double)widths[i], (double)((GridColumn)uiModel.getColumns().get(i)).getWidth(), (double)0.0));
    }

    @Test
    public void testCacheable() {
        this.setupGrid(0);
        Assert.assertTrue((boolean)this.grid.isCacheable());
    }

    @Test
    public void testGetItems() {
        this.setupGrid(0);
        List items = this.grid.getItems(0, 0);
        Assertions.assertThat((int)items.size()).isEqualTo(8);
        this.assertListSelectorHeaderItem((HasListSelectorControl.ListSelectorItem)items.get(0), "RelationEditor.HeaderColumns");
        this.assertListSelectorTextItem((HasListSelectorControl.ListSelectorItem)items.get(1), "RelationEditor.InsertColumnLeft");
        this.assertListSelectorTextItem((HasListSelectorControl.ListSelectorItem)items.get(2), "RelationEditor.InsertColumnRight");
        this.assertListSelectorTextItem((HasListSelectorControl.ListSelectorItem)items.get(3), "RelationEditor.DeleteColumn");
        this.assertListSelectorHeaderItem((HasListSelectorControl.ListSelectorItem)items.get(4), "RelationEditor.HeaderRows");
        this.assertListSelectorTextItem((HasListSelectorControl.ListSelectorItem)items.get(5), "RelationEditor.InsertRowAbove");
        this.assertListSelectorTextItem((HasListSelectorControl.ListSelectorItem)items.get(6), "RelationEditor.InsertRowBelow");
        this.assertListSelectorTextItem((HasListSelectorControl.ListSelectorItem)items.get(7), "RelationEditor.DeleteRow");
    }

    @Test
    public void testGetHeaderItems() {
        this.setupGrid(0);
        List items = this.grid.getHeaderItems(0, 0);
        Assertions.assertThat((int)items.size()).isEqualTo(4);
        this.assertListSelectorHeaderItem((HasListSelectorControl.ListSelectorItem)items.get(0), "RelationEditor.HeaderColumns");
        this.assertListSelectorTextItem((HasListSelectorControl.ListSelectorItem)items.get(1), "RelationEditor.InsertColumnLeft");
        this.assertListSelectorTextItem((HasListSelectorControl.ListSelectorItem)items.get(2), "RelationEditor.InsertColumnRight");
        this.assertListSelectorTextItem((HasListSelectorControl.ListSelectorItem)items.get(3), "RelationEditor.DeleteColumn");
    }

    private void assertListSelectorHeaderItem(HasListSelectorControl.ListSelectorItem item, String text) {
        Assertions.assertThat((Object)item).isInstanceOf(HasListSelectorControl.ListSelectorHeaderItem.class);
        HasListSelectorControl.ListSelectorHeaderItem hi = (HasListSelectorControl.ListSelectorHeaderItem)item;
        Assertions.assertThat((String)hi.getText()).isEqualTo((Object)text);
    }

    private void assertListSelectorTextItem(HasListSelectorControl.ListSelectorItem item, String text) {
        Assertions.assertThat((Object)item).isInstanceOf(HasListSelectorControl.ListSelectorTextItem.class);
        HasListSelectorControl.ListSelectorTextItem ti = (HasListSelectorControl.ListSelectorTextItem)item;
        Assertions.assertThat((String)ti.getText()).isEqualTo((Object)text);
    }

    @Test
    public void testOnItemSelected() {
        this.setupGrid(0);
        Command command = (Command)Mockito.mock(Command.class);
        HasListSelectorControl.ListSelectorTextItem listSelectorItem = (HasListSelectorControl.ListSelectorTextItem)Mockito.mock(HasListSelectorControl.ListSelectorTextItem.class);
        Mockito.when((Object)listSelectorItem.getCommand()).thenReturn((Object)command);
        this.grid.onItemSelected((HasListSelectorControl.ListSelectorItem)listSelectorItem);
        ((Command)Mockito.verify((Object)command)).execute();
    }

    @Test
    public void testOnItemSelectedInsertColumnBefore() {
        this.setupGrid(0);
        this.mockInsertColumnCommandExecution();
        List items = this.grid.getItems(0, 1);
        HasListSelectorControl.ListSelectorTextItem ti = (HasListSelectorControl.ListSelectorTextItem)items.get(1);
        this.grid.onItemSelected((HasListSelectorControl.ListSelectorItem)ti);
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls)).hide();
        ((RelationGrid)Mockito.verify((Object)this.grid)).addColumn(Matchers.eq((int)1));
    }

    @Test
    public void testOnItemSelectedInsertColumnAfter() {
        this.setupGrid(0);
        this.mockInsertColumnCommandExecution();
        List items = this.grid.getItems(0, 1);
        HasListSelectorControl.ListSelectorTextItem ti = (HasListSelectorControl.ListSelectorTextItem)items.get(2);
        this.grid.onItemSelected((HasListSelectorControl.ListSelectorItem)ti);
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls)).hide();
        ((RelationGrid)Mockito.verify((Object)this.grid)).addColumn(Matchers.eq((int)2));
    }

    @Test
    public void testOnItemSelectedInsertColumnEnabled() {
        this.setupGrid(0);
        this.assertListSelectorItemEnabled(0, 0, 1, false);
        this.assertListSelectorItemEnabled(0, 1, 1, true);
        this.assertListSelectorItemEnabled(0, 0, 2, false);
        this.assertListSelectorItemEnabled(0, 1, 2, true);
    }

    @Test
    public void testOnItemSelectedDeleteColumn() {
        this.relation.getColumn().add(new InformationItem());
        this.setupGrid(0);
        List items = this.grid.getItems(0, 1);
        HasListSelectorControl.ListSelectorTextItem ti = (HasListSelectorControl.ListSelectorTextItem)items.get(3);
        this.grid.onItemSelected((HasListSelectorControl.ListSelectorItem)ti);
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls)).hide();
        ((RelationGrid)Mockito.verify((Object)this.grid)).deleteColumn(Matchers.eq((int)1));
    }

    @Test
    public void testOnItemSelectedDeleteColumnEnabled() {
        this.setupGrid(0);
        this.assertListSelectorItemEnabled(0, 0, 3, false);
        this.assertListSelectorItemEnabled(0, 1, 3, false);
        this.grid.getModel().appendColumn((GridColumn)Mockito.mock(RelationColumn.class));
        this.assertListSelectorItemEnabled(0, 0, 3, false);
        this.assertListSelectorItemEnabled(0, 1, 3, true);
        this.assertListSelectorItemEnabled(0, 2, 3, true);
    }

    @Test
    public void testOnItemSelectedInsertRowAbove() {
        this.setupGrid(0);
        List items = this.grid.getItems(0, 0);
        HasListSelectorControl.ListSelectorTextItem ti = (HasListSelectorControl.ListSelectorTextItem)items.get(5);
        this.grid.onItemSelected((HasListSelectorControl.ListSelectorItem)ti);
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls)).hide();
        ((RelationGrid)Mockito.verify((Object)this.grid)).addRow(Matchers.eq((int)0));
    }

    @Test
    public void testOnItemSelectedInsertRowBelow() {
        this.setupGrid(0);
        List items = this.grid.getItems(0, 0);
        HasListSelectorControl.ListSelectorTextItem ti = (HasListSelectorControl.ListSelectorTextItem)items.get(6);
        this.grid.onItemSelected((HasListSelectorControl.ListSelectorItem)ti);
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls)).hide();
        ((RelationGrid)Mockito.verify((Object)this.grid)).addRow(Matchers.eq((int)1));
    }

    @Test
    public void testOnItemSelectedInsertRowEnabled() {
        this.setupGrid(0);
        this.assertListSelectorItemEnabled(0, 0, 5, true);
        this.assertListSelectorItemEnabled(1, 0, 5, true);
        this.assertListSelectorItemEnabled(0, 0, 6, true);
        this.assertListSelectorItemEnabled(1, 0, 6, true);
    }

    @Test
    public void testOnItemSelectedDeleteRow() {
        this.relation.getRow().add(new org.kie.workbench.common.dmn.api.definition.v1_1.List());
        this.setupGrid(0);
        List items = this.grid.getItems(0, 0);
        HasListSelectorControl.ListSelectorTextItem ti = (HasListSelectorControl.ListSelectorTextItem)items.get(7);
        this.grid.onItemSelected((HasListSelectorControl.ListSelectorItem)ti);
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls)).hide();
        ((RelationGrid)Mockito.verify((Object)this.grid)).deleteRow(Matchers.eq((int)0));
    }

    @Test
    public void testOnItemSelectedDeleteRowEnabled() {
        this.setupGrid(0);
        this.assertListSelectorItemEnabled(0, 0, 7, false);
        this.grid.getModel().appendRow((GridRow)new BaseGridRow());
        this.assertListSelectorItemEnabled(0, 0, 7, true);
        this.assertListSelectorItemEnabled(1, 0, 7, true);
    }

    @Test
    public void testOnHeaderItemSelectedInsertColumnBefore() {
        this.setupGrid(0);
        this.mockInsertColumnCommandExecution();
        List items = this.grid.getHeaderItems(0, 1);
        HasListSelectorControl.ListSelectorTextItem ti = (HasListSelectorControl.ListSelectorTextItem)items.get(1);
        this.grid.onItemSelected((HasListSelectorControl.ListSelectorItem)ti);
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls)).hide();
        ((RelationGrid)Mockito.verify((Object)this.grid)).addColumn(Matchers.eq((int)1));
    }

    @Test
    public void testOnHeaderItemSelectedInsertColumnAfter() {
        this.setupGrid(0);
        this.mockInsertColumnCommandExecution();
        List items = this.grid.getHeaderItems(0, 1);
        HasListSelectorControl.ListSelectorTextItem ti = (HasListSelectorControl.ListSelectorTextItem)items.get(2);
        this.grid.onItemSelected((HasListSelectorControl.ListSelectorItem)ti);
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls)).hide();
        ((RelationGrid)Mockito.verify((Object)this.grid)).addColumn(Matchers.eq((int)2));
    }

    @Test
    public void testOnHeaderItemSelectedDeleteColumn() {
        this.relation.getColumn().add(new InformationItem());
        this.setupGrid(0);
        List items = this.grid.getHeaderItems(0, 1);
        HasListSelectorControl.ListSelectorTextItem ti = (HasListSelectorControl.ListSelectorTextItem)items.get(3);
        this.grid.onItemSelected((HasListSelectorControl.ListSelectorItem)ti);
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls)).hide();
        ((RelationGrid)Mockito.verify((Object)this.grid)).deleteColumn(Matchers.eq((int)1));
    }

    @Test
    public void testGetItemsWithCellSelectionsCoveringMultipleRows() {
        this.setupGrid(0);
        this.addRow(0);
        this.grid.getModel().selectCell(0, 0);
        this.grid.getModel().selectCell(1, 0);
        this.assertListSelectorItemEnabled(0, 0, 5, false);
        this.assertListSelectorItemEnabled(0, 0, 6, false);
        this.assertListSelectorItemEnabled(0, 0, 7, false);
    }

    @Test
    public void testGetItemsWithCellSelectionsCoveringMultipleColumns() {
        this.setupGrid(0);
        this.addColumn(1);
        this.grid.getModel().selectCell(0, 0);
        this.grid.getModel().selectCell(0, 1);
        this.assertListSelectorItemEnabled(0, 0, 1, false);
        this.assertListSelectorItemEnabled(0, 0, 2, false);
        this.assertListSelectorItemEnabled(0, 0, 3, false);
    }

    private void assertListSelectorItemEnabled(int uiRowIndex, int uiColumnIndex, int listItemIndex, boolean enabled) {
        List items = this.grid.getItems(uiRowIndex, uiColumnIndex);
        HasListSelectorControl.ListSelectorTextItem ti = (HasListSelectorControl.ListSelectorTextItem)items.get(listItemIndex);
        Assertions.assertThat((boolean)ti.isEnabled()).isEqualTo(enabled);
    }

    @Test
    public void testAddColumn() throws Exception {
        this.setupGrid(0);
        this.addColumn(1);
        this.verifyCommandExecuteOperation(BaseExpressionGrid.RESIZE_EXISTING);
        ((RelationGrid)Mockito.verify((Object)this.grid)).selectHeaderCell(Matchers.eq((int)0), Matchers.eq((int)1), Matchers.eq((boolean)false), Matchers.eq((boolean)false));
        ((NameAndDataTypePopoverView.Presenter)Mockito.verify((Object)this.headerEditor)).bind(Matchers.any(RelationColumnHeaderMetaData.class), Matchers.eq((int)0), Matchers.eq((int)1));
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls)).show((HasCellEditorControls.Editor)Matchers.eq((Object)this.headerEditor), (Optional)Matchers.eq(Optional.of("RelationEditor.EditRelation")), Matchers.anyInt(), Matchers.anyInt());
        Mockito.reset((Object[])new Object[]{this.gridPanel, this.gridLayer, this.grid, this.parentGridColumn});
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)this.addColumnCommand.capture());
        ((AddRelationColumnCommand)this.addColumnCommand.getValue()).undo(this.canvasHandler);
        this.verifyCommandUndoOperation(BaseExpressionGrid.RESIZE_EXISTING_MINIMUM);
    }

    private void addColumn(int index) {
        this.mockInsertColumnCommandExecution();
        this.grid.addColumn(index);
    }

    private void mockInsertColumnCommandExecution() {
        Mockito.when((Object)this.sessionCommandManager.execute(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)Matchers.any(AbstractCanvasGraphCommand.class))).thenAnswer(i -> {
            AbstractCanvasHandler handler = (AbstractCanvasHandler)i.getArguments()[0];
            AbstractCanvasGraphCommand command = (AbstractCanvasGraphCommand)i.getArguments()[1];
            return command.execute(handler);
        });
    }

    private void verifyCommandExecuteOperation(Function<BaseExpressionGrid, Double> resizeFunction) {
        ((GridCellTuple)Mockito.verify((Object)this.parent)).proposeContainingColumnWidth(Matchers.eq((double)(this.grid.getWidth() + this.grid.getPadding() * 2.0)), (Function)Matchers.eq(resizeFunction));
        ((GridColumn)Mockito.verify((Object)this.parentGridColumn)).setWidth(this.grid.getWidth() + this.grid.getPadding() * 2.0);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch((GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandCaptor.capture());
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).refreshScrollPosition();
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).updatePanelSize();
        GridLayerRedrawManager.PrioritizedCommand redrawCommand = (GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandCaptor.getValue();
        redrawCommand.execute();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).draw();
    }

    private void verifyCommandUndoOperation(Function<BaseExpressionGrid, Double> resizeFunction) {
        ((GridCellTuple)Mockito.verify((Object)this.parent)).proposeContainingColumnWidth(Matchers.eq((double)(this.grid.getWidth() + this.grid.getPadding() * 2.0)), (Function)Matchers.eq(resizeFunction));
        ((GridColumn)Mockito.verify((Object)this.parentGridColumn)).setWidth(this.grid.getWidth() + this.grid.getPadding() * 2.0);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch((GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandCaptor.capture());
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).refreshScrollPosition();
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).updatePanelSize();
        Assertions.assertThat((List)this.redrawCommandCaptor.getAllValues()).hasSize(2);
        ((GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandCaptor.getAllValues().get(1)).execute();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).draw();
    }

    @Test
    public void testDeleteColumn() {
        this.relation.getColumn().add(new InformationItem());
        this.setupGrid(0);
        this.grid.deleteColumn(1);
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)this.deleteColumnCommand.capture());
        ((DeleteRelationColumnCommand)this.deleteColumnCommand.getValue()).execute(this.canvasHandler);
        this.verifyCommandExecuteOperation(BaseExpressionGrid.RESIZE_EXISTING_MINIMUM);
        Mockito.reset((Object[])new Object[]{this.gridPanel, this.gridLayer, this.grid, this.parentGridColumn});
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)this.deleteColumnCommand.capture());
        ((DeleteRelationColumnCommand)this.deleteColumnCommand.getValue()).undo(this.canvasHandler);
        this.verifyCommandUndoOperation(BaseExpressionGrid.RESIZE_EXISTING);
    }

    @Test
    public void testAddRow() {
        this.setupGrid(0);
        this.addRow(0);
        this.verifyCommandExecuteOperation(BaseExpressionGrid.RESIZE_EXISTING);
    }

    private void addRow(int index) {
        this.grid.addRow(index);
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)this.addRowCommand.capture());
        ((AddRelationRowCommand)this.addRowCommand.getValue()).execute(this.canvasHandler);
    }

    @Test
    public void testDeleteRow() {
        this.relation.getRow().add(new org.kie.workbench.common.dmn.api.definition.v1_1.List());
        this.setupGrid(0);
        this.grid.deleteRow(0);
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)this.deleteRowCommand.capture());
        ((DeleteRelationRowCommand)this.deleteRowCommand.getValue()).execute(this.canvasHandler);
        this.verifyCommandExecuteOperation(BaseExpressionGrid.RESIZE_EXISTING);
    }

    @Test
    public void testBodyFactoryWhenNested() {
        this.setupGrid(1);
        TextAreaSingletonDOMElementFactory factory = this.grid.getBodyTextAreaFactory();
        Assertions.assertThat(factory.getHasNoValueCommand().apply(this.tupleWithoutValue)).isInstanceOf(DeleteCellValueCommand.class);
        Assertions.assertThat(factory.getHasValueCommand().apply(this.tupleWithValue)).isInstanceOf(SetCellValueCommand.class);
    }

    @Test
    public void testBodyFactoryWhenNotNested() {
        this.setupGrid(0);
        TextAreaSingletonDOMElementFactory factory = this.grid.getBodyTextAreaFactory();
        Assertions.assertThat(factory.getHasNoValueCommand().apply(this.tupleWithoutValue)).isInstanceOf(DeleteCellValueCommand.class);
        Assertions.assertThat(factory.getHasValueCommand().apply(this.tupleWithValue)).isInstanceOf(SetCellValueCommand.class);
    }

    @Test
    public void testGetDisplayName() {
        this.setupGrid(0);
        Assertions.assertThat((String)this.extractHeaderMetaData().getName().getValue()).isEqualTo((Object)NAME);
    }

    private RelationColumnHeaderMetaData extractHeaderMetaData() {
        RelationColumn column = (RelationColumn)this.grid.getModel().getColumns().get(1);
        return (RelationColumnHeaderMetaData)column.getHeaderMetaData().get(0);
    }

    @Test
    public void testSetDisplayNameWithNoChange() {
        this.setupGrid(0);
        this.extractHeaderMetaData().setName(new Name(NAME));
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager, (VerificationMode)Mockito.never())).execute(Matchers.any(AbstractCanvasHandler.class), (org.kie.workbench.common.stunner.core.command.Command)Matchers.any(org.kie.workbench.common.stunner.core.command.Command.class));
    }

    @Test
    public void testSetDisplayNameWithEmptyValue() {
        this.setupGrid(0);
        this.extractHeaderMetaData().setName(new Name());
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)this.compositeCommandCaptor.capture());
        GridFactoryCommandUtils.assertCommands((org.kie.workbench.common.stunner.core.command.Command)this.compositeCommandCaptor.getValue(), DeleteHasNameCommand.class);
    }

    @Test
    public void testSetDisplayNameWithNullValue() {
        this.setupGrid(0);
        this.extractHeaderMetaData().setName(null);
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)this.compositeCommandCaptor.capture());
        GridFactoryCommandUtils.assertCommands((org.kie.workbench.common.stunner.core.command.Command)this.compositeCommandCaptor.getValue(), DeleteHasNameCommand.class);
    }

    @Test
    public void testSetDisplayNameWithNonEmptyValue() {
        this.setupGrid(0);
        this.extractHeaderMetaData().setName(new Name(NAME_NEW));
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)this.compositeCommandCaptor.capture());
        GridFactoryCommandUtils.assertCommands((org.kie.workbench.common.stunner.core.command.Command)this.compositeCommandCaptor.getValue(), SetHasNameCommand.class);
    }

    @Test
    public void testGetTypeRef() {
        this.setupGrid(0);
        Assertions.assertThat((Object)this.extractHeaderMetaData().getTypeRef()).isNotNull();
    }

    @Test
    public void testSetTypeRef() {
        this.setupGrid(0);
        this.extractHeaderMetaData().setTypeRef(new QName("", BuiltInType.DATE.getName()));
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)Matchers.any(SetTypeRefCommand.class));
    }

    @Test
    public void testSetTypeRefWithoutChange() {
        this.setupGrid(0);
        this.extractHeaderMetaData().setTypeRef(new QName());
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager, (VerificationMode)Mockito.never())).execute(Matchers.any(AbstractCanvasHandler.class), (org.kie.workbench.common.stunner.core.command.Command)Matchers.any(SetTypeRefCommand.class));
    }

    @Test
    public void testSelectRow() {
        this.setupGrid(0);
        this.grid.selectCell(0, 0, false, false);
        ((EventSourceMock)Mockito.verify(this.domainObjectSelectionEvent)).fire(this.domainObjectSelectionEventCaptor.capture());
        DomainObjectSelectionEvent domainObjectSelectionEvent = (DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.getValue();
        Assertions.assertThat((Object)domainObjectSelectionEvent.getDomainObject()).isInstanceOf(NOPDomainObject.class);
    }

    @Test
    public void testSelectMultipleCells() {
        this.setupGrid(0);
        this.addRow(0);
        this.addColumn(1);
        Mockito.reset((Object[])new EventSourceMock[]{this.domainObjectSelectionEvent});
        this.grid.selectCell(0, 1, false, false);
        ((EventSourceMock)Mockito.verify(this.domainObjectSelectionEvent)).fire(this.domainObjectSelectionEventCaptor.capture());
        DomainObjectSelectionEvent event1 = (DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.getValue();
        Assertions.assertThat((Object)event1.getDomainObject()).isEqualTo(((org.kie.workbench.common.dmn.api.definition.v1_1.List)this.expression.get().getRow().get(0)).getExpression().get(0));
        Mockito.reset((Object[])new EventSourceMock[]{this.domainObjectSelectionEvent});
        this.grid.selectCell(0, 2, false, true);
        ((EventSourceMock)Mockito.verify(this.domainObjectSelectionEvent)).fire(this.domainObjectSelectionEventCaptor.capture());
        DomainObjectSelectionEvent event2 = (DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.getValue();
        Assertions.assertThat((Object)event2.getDomainObject()).isInstanceOf(NOPDomainObject.class);
    }

    @Test
    public void testSelectSingleCellWithHeaderSelected() {
        this.setupGrid(0);
        this.grid.selectHeaderCell(0, 1, false, false);
        ((EventSourceMock)Mockito.verify(this.domainObjectSelectionEvent)).fire(this.domainObjectSelectionEventCaptor.capture());
        DomainObjectSelectionEvent event1 = (DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.getValue();
        Assertions.assertThat((Object)event1.getDomainObject()).isEqualTo(this.expression.get().getColumn().get(0));
        Mockito.reset((Object[])new EventSourceMock[]{this.domainObjectSelectionEvent});
        this.grid.selectCell(0, 1, false, true);
        ((EventSourceMock)Mockito.verify(this.domainObjectSelectionEvent)).fire(this.domainObjectSelectionEventCaptor.capture());
        DomainObjectSelectionEvent event2 = (DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.getValue();
        Assertions.assertThat((Object)event2.getDomainObject()).isEqualTo(((org.kie.workbench.common.dmn.api.definition.v1_1.List)this.expression.get().getRow().get(0)).getExpression().get(0));
    }

    @Test
    public void testSelectExpression() {
        this.setupGrid(0);
        this.grid.selectCell(0, 1, false, false);
        ((EventSourceMock)Mockito.verify(this.domainObjectSelectionEvent)).fire(this.domainObjectSelectionEventCaptor.capture());
        DomainObjectSelectionEvent domainObjectSelectionEvent = (DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.getValue();
        Assertions.assertThat((Object)domainObjectSelectionEvent.getDomainObject()).isEqualTo(((org.kie.workbench.common.dmn.api.definition.v1_1.List)this.expression.get().getRow().get(0)).getExpression().get(0));
    }

    @Test
    public void testSelectHeaderExpression() {
        this.setupGrid(0);
        this.grid.selectHeaderCell(0, 1, false, false);
        ((EventSourceMock)Mockito.verify(this.domainObjectSelectionEvent)).fire(this.domainObjectSelectionEventCaptor.capture());
        DomainObjectSelectionEvent domainObjectSelectionEvent = (DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.getValue();
        Assertions.assertThat((Object)domainObjectSelectionEvent.getDomainObject()).isEqualTo(this.expression.get().getColumn().get(0));
    }

    @Test
    public void testAsDMNModelInstrumentedBase() {
        this.setupGrid(0);
        DMNModelInstrumentedBase actual = this.extractHeaderMetaData().asDMNModelInstrumentedBase();
        Assertions.assertThat((Object)actual).isInstanceOf(InformationItem.class);
    }

    @Test
    public void testSelectFirstCell() {
        this.setupGrid(0);
        this.grid.selectFirstCell();
        Assertions.assertThat((List)this.grid.getModel().getSelectedCells()).containsOnly((Object[])new GridData.SelectedCell[]{new GridData.SelectedCell(0, 1)});
    }
}

