/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.undefined;

import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.UndefinedExpressionCell;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.UndefinedExpressionColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.UndefinedExpressionColumnRenderer;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.UndefinedExpressionGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.selector.UndefinedExpressionSelectorPopoverView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.HasCellEditorControls;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellEditContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;

@RunWith(value=LienzoMockitoTestRunner.class)
public class UndefinedExpressionColumnTest {
    private static final int ROW_INDEX = 1;
    private static final int COLUMN_INDEX = 2;
    private static final double ABSOLUTE_CELL_X = 10.0;
    private static final double ABSOLUTE_CELL_Y = 20.0;
    private static final double RX = 37.0;
    private static final double RY = 42.0;
    private static final double GRID_WIDTH = 60.0;
    private static final double GRID_HEIGHT = 30.0;
    @Mock
    private UndefinedExpressionGrid gridWidget;
    @Mock
    private CellEditorControlsView.Presenter cellEditorControls;
    @Mock
    private UndefinedExpressionSelectorPopoverView.Presenter undefinedExpressionSelector;
    @Mock
    private TranslationService translationService;
    @Mock
    private GridWidget parentGridWidget;
    @Mock
    private GridData parentGridData;
    @Mock
    private GridColumn parentGridColumn;
    @Mock
    private GridCellTuple parent;
    @Mock
    private GridBodyCellEditContext context;
    @Mock
    private Consumer<GridCellValue<String>> callback;
    @Mock
    private Point2D relativeLocation;
    private UndefinedExpressionColumn column;

    @Before
    public void setup() {
        Mockito.when((Object)this.gridWidget.getExpression()).thenReturn(Optional::empty);
        Mockito.when((Object)this.gridWidget.getParentInformation()).thenReturn((Object)this.parent);
        Mockito.when((Object)this.gridWidget.getHeight()).thenReturn((Object)30.0);
        Mockito.when((Object)this.gridWidget.getWidth()).thenReturn((Object)60.0);
        Mockito.when((Object)this.parent.getGridWidget()).thenReturn((Object)this.parentGridWidget);
        Mockito.when((Object)this.parentGridWidget.getModel()).thenReturn((Object)this.parentGridData);
        Mockito.when((Object)this.parentGridData.getColumns()).thenReturn(Collections.singletonList(this.parentGridColumn));
        this.column = (UndefinedExpressionColumn)Mockito.spy((Object)new UndefinedExpressionColumn(150.0, this.gridWidget, this.cellEditorControls, this.undefinedExpressionSelector, this.translationService));
        Mockito.when((Object)this.context.getRowIndex()).thenReturn((Object)1);
        Mockito.when((Object)this.context.getColumnIndex()).thenReturn((Object)2);
        Mockito.when((Object)this.context.getRelativeLocation()).thenReturn(Optional.of(this.relativeLocation));
        Mockito.when((Object)this.context.getAbsoluteCellX()).thenReturn((Object)10.0);
        Mockito.when((Object)this.context.getAbsoluteCellY()).thenReturn((Object)20.0);
        ((TranslationService)Mockito.doAnswer(i -> i.getArguments()[0]).when((Object)this.translationService)).getTranslation(Matchers.anyString());
    }

    @Test
    public void testRenderer() {
        Assertions.assertThat((Object)this.column.getColumnRenderer()).isInstanceOf(UndefinedExpressionColumnRenderer.class);
    }

    @Test
    public void testSetWidth() {
        this.column.setWidth(200.0);
        Assertions.assertThat((double)this.column.getWidth()).isEqualTo(200.0);
        ((UndefinedExpressionColumn)Mockito.verify((Object)this.column)).updateWidthOfPeers();
    }

    @Test
    public void testEditWithDefinedCellEditor() {
        UndefinedExpressionCell cell = (UndefinedExpressionCell)Mockito.mock(UndefinedExpressionCell.class);
        this.column.edit((GridCell)cell, this.context, this.callback);
        ((UndefinedExpressionSelectorPopoverView.Presenter)Mockito.verify((Object)this.undefinedExpressionSelector)).bind(Matchers.eq((Object)this.gridWidget), Matchers.eq((int)1), Matchers.eq((int)2));
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls)).show((HasCellEditorControls.Editor)Matchers.eq((Object)this.undefinedExpressionSelector), (Optional)Matchers.any(Optional.class), Matchers.eq((int)0), Matchers.eq((int)0));
    }

    @Test
    public void testEditWithDefinedCellEditorWithRelativeLocation() {
        UndefinedExpressionCell cell = (UndefinedExpressionCell)Mockito.mock(UndefinedExpressionCell.class);
        Mockito.when((Object)this.relativeLocation.getX()).thenReturn((Object)37.0);
        Mockito.when((Object)this.relativeLocation.getY()).thenReturn((Object)42.0);
        this.column.edit((GridCell)cell, this.context, this.callback);
        ((UndefinedExpressionSelectorPopoverView.Presenter)Mockito.verify((Object)this.undefinedExpressionSelector)).bind(Matchers.eq((Object)this.gridWidget), Matchers.eq((int)1), Matchers.eq((int)2));
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls)).show((HasCellEditorControls.Editor)Matchers.eq((Object)this.undefinedExpressionSelector), (Optional)Matchers.any(Optional.class), Matchers.eq((int)37), Matchers.eq((int)42));
    }

    @Test
    public void testEditWithDefinedCellEditorWithoutRelativeLocation() {
        UndefinedExpressionCell cell = (UndefinedExpressionCell)Mockito.mock(UndefinedExpressionCell.class);
        Mockito.when((Object)this.context.getRelativeLocation()).thenReturn(Optional.empty());
        this.column.edit((GridCell)cell, this.context, this.callback);
        ((UndefinedExpressionSelectorPopoverView.Presenter)Mockito.verify((Object)this.undefinedExpressionSelector)).bind(Matchers.eq((Object)this.gridWidget), Matchers.eq((int)1), Matchers.eq((int)2));
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls)).show((HasCellEditorControls.Editor)Matchers.eq((Object)this.undefinedExpressionSelector), (Optional)Matchers.any(Optional.class), Matchers.eq((int)40), Matchers.eq((int)35));
    }

    @Test
    public void testDestroyResources() {
        this.column.destroyResources();
        ((UndefinedExpressionSelectorPopoverView.Presenter)Mockito.verify((Object)this.undefinedExpressionSelector)).hide();
    }
}

