/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.undefined;

import java.util.Optional;
import java.util.function.Supplier;
import org.assertj.core.api.AssertionsForClassTypes;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.literal.LiteralExpressionGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.UndefinedExpressionCell;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.UndefinedExpressionColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.UndefinedExpressionUIModelMapper;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;

@RunWith(value=MockitoJUnitRunner.class)
public class UndefinedExpressionUIModelMapperTest {
    @Mock
    private LiteralExpression expression;
    @Mock
    private HasExpression hasExpression;
    @Mock
    private DMNModelInstrumentedBase hasExpressionDMNModelInstrumentedBase;
    @Mock
    private LiteralExpressionGrid editor;
    @Mock
    private ListSelectorView.Presenter listSelector;
    @Mock
    private TranslationService translationService;
    @Mock
    private UndefinedExpressionColumn uiColumn;
    private GridData uiModel;
    private Supplier<Optional<GridCellValue<?>>> cellValueSupplier;
    private UndefinedExpressionUIModelMapper mapper;

    @Before
    public void setup() {
        this.uiModel = new BaseGridData();
        this.uiModel.appendColumn((GridColumn)this.uiColumn);
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.mapper = new UndefinedExpressionUIModelMapper(() -> this.uiModel, () -> Optional.ofNullable(this.expression), this.listSelector, this.translationService, this.hasExpression);
        this.cellValueSupplier = () -> Optional.of(new ExpressionCellValue(Optional.of(this.editor)));
        Mockito.when((Object)this.hasExpression.asDMNModelInstrumentedBase()).thenReturn((Object)this.hasExpressionDMNModelInstrumentedBase);
    }

    @Test
    public void testFromDMNModel() {
        this.mapper.fromDMNModel(0, 0);
        AssertionsForClassTypes.assertThat((Object)((GridData)this.mapper.getUiModel().get()).getCell(0, 0)).isInstanceOf(UndefinedExpressionCell.class);
    }

    @Test
    public void testToDMNModelNoEditor() {
        Mockito.when((Object)this.editor.getExpression()).thenReturn(Optional::empty);
        this.mapper.toDMNModel(0, 0, this.cellValueSupplier);
        ((HasExpression)Mockito.verify((Object)this.hasExpression)).setExpression((Expression)Matchers.eq(null));
    }

    @Test
    public void testToDMNModelWithEditor() {
        Mockito.when((Object)this.editor.getExpression()).thenReturn(() -> Optional.of(this.expression));
        this.mapper.toDMNModel(0, 0, this.cellValueSupplier);
        ((HasExpression)Mockito.verify((Object)this.hasExpression)).setExpression((Expression)Matchers.eq((Object)this.expression));
        ((LiteralExpression)Mockito.verify((Object)this.expression)).setParent((DMNModelInstrumentedBase)Matchers.eq((Object)this.hasExpressionDMNModelInstrumentedBase));
    }
}

