/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.HTMLElement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.included.IncludedModelsPagePresenter;
import org.kie.workbench.common.dmn.client.editors.included.grid.DMNCardsGridComponent;
import org.kie.workbench.common.dmn.client.editors.included.modal.IncludedModelModal;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class IncludedModelsPagePresenterTest {
    @Mock
    private IncludedModelsPagePresenter.View view;
    @Mock
    private DMNCardsGridComponent gridComponent;
    @Mock
    private IncludedModelModal modal;
    private IncludedModelsPagePresenter pagePresenter;

    @Before
    public void setup() {
        this.pagePresenter = new IncludedModelsPagePresenter(this.view, this.gridComponent, this.modal);
    }

    @Test
    public void testInit() {
        HTMLElement htmlElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.gridComponent.getElement()).thenReturn((Object)htmlElement);
        this.pagePresenter.init();
        ((IncludedModelsPagePresenter.View)Mockito.verify((Object)this.view)).init((Object)this.pagePresenter);
        ((IncludedModelsPagePresenter.View)Mockito.verify((Object)this.view)).setGrid(htmlElement);
        ((IncludedModelModal)Mockito.verify((Object)this.modal)).init(this.pagePresenter);
    }

    @Test
    public void testGetElement() {
        HTMLElement expectedElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.view.getElement()).thenReturn((Object)expectedElement);
        HTMLElement actualElement = this.pagePresenter.getElement();
        Assert.assertEquals((Object)expectedElement, (Object)actualElement);
    }

    @Test
    public void testRefresh() {
        this.pagePresenter.refresh();
        ((DMNCardsGridComponent)Mockito.verify((Object)this.gridComponent)).refresh();
    }

    @Test
    public void testOpenIncludeModelModal() {
        this.pagePresenter.openIncludeModelModal();
        ((IncludedModelModal)Mockito.verify((Object)this.modal)).show();
    }
}

