/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included.imports;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.v1_1.Import;
import org.kie.workbench.common.dmn.client.editors.included.BaseIncludedModelActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.imports.IncludedModelsIndex;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class IncludedModelsIndexTest {
    @Mock
    private BaseIncludedModelActiveRecord includedModel;
    @Mock
    private Import anImport;
    private String uuid = "123";
    private IncludedModelsIndex modelsIndex;

    @Before
    public void setup() {
        Mockito.when((Object)this.includedModel.getUUID()).thenReturn((Object)this.uuid);
        this.modelsIndex = new IncludedModelsIndex();
        this.modelsIndex.index(this.includedModel, this.anImport);
    }

    @Test
    public void testIndex() {
        BaseIncludedModelActiveRecord includedModel = (BaseIncludedModelActiveRecord)Mockito.mock(BaseIncludedModelActiveRecord.class);
        Import expectedImport = (Import)Mockito.mock(Import.class);
        String uuid = "456";
        Mockito.when((Object)includedModel.getUUID()).thenReturn((Object)"456");
        this.modelsIndex.index(includedModel, expectedImport);
        Import actualImport = this.modelsIndex.getImport(includedModel);
        Assert.assertEquals((Object)expectedImport, (Object)actualImport);
    }

    @Test
    public void testGetImport() {
        Import anImport = this.modelsIndex.getImport(this.includedModel);
        Assert.assertEquals((Object)this.anImport, (Object)anImport);
    }

    @Test
    public void testGetIndexedImports() {
        ArrayList imports = new ArrayList(this.modelsIndex.getIndexedImports());
        Assert.assertEquals((long)1L, (long)imports.size());
        Assert.assertEquals((Object)this.anImport, imports.get(0));
    }

    @Test
    public void testClear() {
        Assert.assertEquals((long)1L, (long)this.modelsIndex.size());
        this.modelsIndex.clear();
        Assert.assertEquals((long)0L, (long)this.modelsIndex.size());
    }
}

