/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included.imports.messages;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.common.messages.FlashMessage;
import org.kie.workbench.common.dmn.client.editors.included.BaseIncludedModelActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.imports.messages.IncludedModelErrorMessageFactory;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class IncludedModelErrorMessageFactoryTest {
    @Mock
    private TranslationService translationService;
    private IncludedModelErrorMessageFactory factory;

    @Before
    public void setup() {
        this.factory = new IncludedModelErrorMessageFactory(this.translationService);
    }

    @Test
    public void testGetNameIsNotUniqueFlashMessage() {
        BaseIncludedModelActiveRecord includedModel = (BaseIncludedModelActiveRecord)Mockito.mock(BaseIncludedModelActiveRecord.class);
        FlashMessage.Type expectedType = FlashMessage.Type.ERROR;
        String expectedStrongMessage = "StrongMessage";
        String expectedRegularMessage = "RegularMessage";
        String expectedElementSelector = "[data-card-uuid=\"1234\"] [data-field=\"title-input\"]";
        Mockito.when((Object)includedModel.getUUID()).thenReturn((Object)"1234");
        Mockito.when((Object)includedModel.getName()).thenReturn((Object)"file");
        Mockito.when((Object)this.translationService.format("IncludedModelNameIsNotUniqueErrorMessage.StrongMessage", new Object[]{"file"})).thenReturn((Object)"StrongMessage");
        Mockito.when((Object)this.translationService.format("IncludedModelNameIsNotUniqueErrorMessage.RegularMessage", new Object[0])).thenReturn((Object)"RegularMessage");
        FlashMessage flashMessage = this.factory.getNameIsNotUniqueFlashMessage(includedModel);
        Assert.assertEquals((Object)expectedType, (Object)flashMessage.getType());
        Assert.assertEquals((Object)"StrongMessage", (Object)flashMessage.getStrongMessage());
        Assert.assertEquals((Object)"RegularMessage", (Object)flashMessage.getRegularMessage());
        Assert.assertEquals((Object)"[data-card-uuid=\"1234\"] [data-field=\"title-input\"]", (Object)flashMessage.getElementSelector());
    }

    @Test
    public void testGetNameIsBlankFlashMessage() {
        BaseIncludedModelActiveRecord includedModel = (BaseIncludedModelActiveRecord)Mockito.mock(BaseIncludedModelActiveRecord.class);
        FlashMessage.Type expectedType = FlashMessage.Type.ERROR;
        String expectedStrongMessage = "StrongMessage";
        String expectedRegularMessage = "RegularMessage";
        String expectedElementSelector = "[data-card-uuid=\"1234\"] [data-field=\"title-input\"]";
        Mockito.when((Object)includedModel.getUUID()).thenReturn((Object)"1234");
        Mockito.when((Object)this.translationService.format("IncludedModelNameIsBlankErrorMessage.StrongMessage", new Object[0])).thenReturn((Object)"StrongMessage");
        Mockito.when((Object)this.translationService.format("IncludedModelNameIsBlankErrorMessage.RegularMessage", new Object[0])).thenReturn((Object)"RegularMessage");
        FlashMessage flashMessage = this.factory.getNameIsBlankFlashMessage(includedModel);
        Assert.assertEquals((Object)expectedType, (Object)flashMessage.getType());
        Assert.assertEquals((Object)"StrongMessage", (Object)flashMessage.getStrongMessage());
        Assert.assertEquals((Object)"RegularMessage", (Object)flashMessage.getRegularMessage());
        Assert.assertEquals((Object)"[data-card-uuid=\"1234\"] [data-field=\"title-input\"]", (Object)flashMessage.getElementSelector());
    }
}

