/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included.imports.persistence;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.editors.included.imports.persistence.ItemDefinitionHandler;
import org.kie.workbench.common.dmn.client.editors.types.common.ItemDefinitionUtils;
import org.kie.workbench.common.dmn.client.editors.types.common.events.RefreshDataTypesListEvent;
import org.kie.workbench.common.dmn.client.editors.types.persistence.handlers.common.PropertiesPanelNotifier;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class ItemDefinitionHandlerTest {
    @Mock
    private ItemDefinitionUtils itemDefinitionUtils;
    @Mock
    private EventSourceMock<RefreshDataTypesListEvent> refreshDataTypesListEvent;
    @Mock
    private PropertiesPanelNotifier panelNotifier;
    private ItemDefinitionHandler handler;

    @Before
    public void setup() {
        this.handler = (ItemDefinitionHandler)Mockito.spy((Object)new ItemDefinitionHandler(this.itemDefinitionUtils, this.refreshDataTypesListEvent, this.panelNotifier));
    }

    @Test
    public void testUpdate() {
        ItemDefinition item1 = this.makeItemDefinition("model1.tPerson", null, true);
        ItemDefinition item2 = this.makeItemDefinition("model1.id", "number", true);
        ItemDefinition item3 = this.makeItemDefinition("model1.name", "string", true);
        ItemDefinition item4 = this.makeItemDefinition("person", "model1.tPerson", false);
        List<ItemDefinition> itemDefinitions = Arrays.asList(item1, item2, item3, item4);
        ((ItemDefinitionHandler)Mockito.doNothing().when((Object)this.handler)).notifyPropertiesPanel(Matchers.anyString(), Matchers.anyString());
        Mockito.when((Object)this.itemDefinitionUtils.all()).thenReturn(itemDefinitions);
        this.handler.update("model1", "model2");
        ((EventSourceMock)Mockito.verify(this.refreshDataTypesListEvent)).fire(Matchers.any(RefreshDataTypesListEvent.class));
        Assert.assertEquals((Object)"model2.tPerson", (Object)item1.getName().getValue());
        Assert.assertNull((Object)item1.getTypeRef());
        ((ItemDefinitionHandler)Mockito.verify((Object)this.handler)).notifyPropertiesPanel("model1.tPerson", "model2.tPerson");
        Assert.assertEquals((Object)"model2.id", (Object)item2.getName().getValue());
        Assert.assertEquals((Object)"number", (Object)item2.getTypeRef().getLocalPart());
        ((ItemDefinitionHandler)Mockito.verify((Object)this.handler)).notifyPropertiesPanel("model1.id", "model2.id");
        Assert.assertEquals((Object)"model2.name", (Object)item3.getName().getValue());
        Assert.assertEquals((Object)"string", (Object)item3.getTypeRef().getLocalPart());
        ((ItemDefinitionHandler)Mockito.verify((Object)this.handler)).notifyPropertiesPanel("model1.name", "model2.name");
        Assert.assertEquals((Object)"person", (Object)item4.getName().getValue());
        Assert.assertEquals((Object)"model2.tPerson", (Object)item4.getTypeRef().getLocalPart());
    }

    @Test
    public void testDestroy() {
        ItemDefinition item1 = this.makeItemDefinition("model1.tPerson", null, true);
        ItemDefinition item2 = this.makeItemDefinition("model1.id", "number", true);
        ItemDefinition item3 = this.makeItemDefinition("model1.name", "string", true);
        ItemDefinition item4 = this.makeItemDefinition("person", "model1.tPerson", false);
        ItemDefinition item5 = this.makeItemDefinition("tUUID", "string", false);
        ArrayList<ItemDefinition> itemDefinitions = new ArrayList<ItemDefinition>(Arrays.asList(item1, item2, item3, item4, item5));
        Mockito.when((Object)this.itemDefinitionUtils.all()).thenReturn(itemDefinitions);
        this.handler.destroy("model1");
        ((EventSourceMock)Mockito.verify(this.refreshDataTypesListEvent)).fire(Matchers.any(RefreshDataTypesListEvent.class));
        Assert.assertEquals((long)1L, (long)itemDefinitions.size());
        Assert.assertEquals((Object)"tUUID", (Object)((ItemDefinition)itemDefinitions.get(0)).getName().getValue());
        Assert.assertEquals((Object)"string", (Object)((ItemDefinition)itemDefinitions.get(0)).getTypeRef().getLocalPart());
    }

    @Test
    public void testNotifyPropertiesPanel() {
        String oldName = "oldName";
        String newName = "newName";
        QName qName = new QName("", "newName");
        Mockito.when((Object)this.panelNotifier.withOldLocalPart("oldName")).thenReturn((Object)this.panelNotifier);
        Mockito.when((Object)this.panelNotifier.withNewQName((QName)Matchers.eq((Object)qName))).thenReturn((Object)this.panelNotifier);
        Mockito.when((Object)this.itemDefinitionUtils.normaliseTypeRef(qName)).thenReturn((Object)qName);
        this.handler.notifyPropertiesPanel("oldName", "newName");
        ((PropertiesPanelNotifier)Mockito.verify((Object)this.panelNotifier)).notifyPanel();
    }

    private ItemDefinition makeItemDefinition(String name, String type, boolean isImported) {
        ItemDefinition itemDefinition = new ItemDefinition();
        itemDefinition.setName(new Name(name));
        itemDefinition.setTypeRef(type == null ? null : new QName("", type, ""));
        itemDefinition.setAllowOnlyVisualChange(isImported);
        return itemDefinition;
    }
}

