/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included.imports.persistence;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.included.imports.persistence.NamespaceHandler;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class NamespaceHandlerTest {
    @Test
    public void testAddIncludedNamespace() {
        HashMap nsContext = new HashMap();
        String namespace = "some_namespace";
        String expectedAlias = "included1";
        String actual = NamespaceHandler.addIncludedNamespace(nsContext, (String)"some_namespace");
        Assert.assertEquals((long)1L, (long)nsContext.size());
        Assert.assertEquals((Object)"included1", (Object)actual);
        Assert.assertEquals((Object)"some_namespace", nsContext.get("included1"));
    }

    @Test
    public void testAddExistingIncludedNamespace() {
        HashMap<String, String> nsContext = new HashMap<String, String>();
        String namespace = "some_namespace";
        String expectedAlias = "included1";
        nsContext.put("included1", "some_namespace");
        String actual = NamespaceHandler.addIncludedNamespace(nsContext, (String)"some_namespace");
        Assert.assertEquals((long)1L, (long)nsContext.size());
        Assert.assertEquals((Object)"included1", (Object)actual);
        Assert.assertEquals((Object)"some_namespace", nsContext.get("included1"));
    }

    @Test
    public void testGetFreeIncludedNamespaceIdWithExistingNamespaces() {
        HashMap<String, String> nsContext = new HashMap<String, String>();
        nsContext.put("dmn", "some_uri");
        nsContext.put("other", "some_another");
        nsContext.put("included1", "uri_1");
        nsContext.put("included2", "uri_2");
        nsContext.put("included3", "uri_2");
        String expected = "included4";
        String actual = NamespaceHandler.getFreeIncludedNamespaceId(nsContext);
        Assert.assertEquals((Object)"included4", (Object)actual);
    }

    @Test
    public void testGetFreeIncludedNamespaceIdReusingId() {
        HashMap<String, String> nsContext = new HashMap<String, String>();
        nsContext.put("dmn", "some_uri");
        nsContext.put("includ3d", "some_another");
        nsContext.put("included1", "uri_1");
        nsContext.put("included3", "uri_2");
        String expected = "included2";
        String actual = NamespaceHandler.getFreeIncludedNamespaceId(nsContext);
        Assert.assertEquals((Object)"included2", (Object)actual);
    }

    @Test
    public void testGetFreeIncludedNamespaceId() {
        HashMap nsContext = new HashMap();
        String expected = "included1";
        String actual = NamespaceHandler.getFreeIncludedNamespaceId(nsContext);
        Assert.assertEquals((Object)"included1", (Object)actual);
    }

    @Test
    public void testRemoveIncludedNamespace() {
        HashMap<String, String> nsContext = new HashMap<String, String>();
        String included1 = "included1";
        String included2 = "included2";
        String included3 = "included3";
        String ns1 = "http://something1";
        String ns2 = "http://something2";
        String ns3 = "http://something3";
        nsContext.put("included1", "http://something1");
        nsContext.put("included2", "http://something2");
        nsContext.put("included3", "http://something3");
        NamespaceHandler.removeIncludedNamespace(nsContext, (String)"http://something2");
        Assert.assertEquals((long)2L, (long)nsContext.size());
        Assert.assertTrue((boolean)nsContext.containsKey("included1"));
        Assert.assertTrue((boolean)nsContext.containsKey("included3"));
    }

    @Test
    public void testRemoveIncludedNamespaceNotPresent() {
        HashMap<String, String> nsContext = new HashMap<String, String>();
        String included1 = "included1";
        String included2 = "included2";
        String ns1 = "http://something1";
        String ns2 = "http://something2";
        String ns3 = "http://something3";
        nsContext.put("included1", "http://something1");
        nsContext.put("included2", "http://something2");
        NamespaceHandler.removeIncludedNamespace(nsContext, (String)"http://something3");
        Assert.assertEquals((long)2L, (long)nsContext.size());
        Assert.assertTrue((boolean)nsContext.containsKey("included1"));
        Assert.assertTrue((boolean)nsContext.containsKey("included2"));
    }

    @Test
    public void testGetAlias() {
        HashMap<String, String> nsContext = new HashMap<String, String>();
        String included1 = "included1";
        String included2 = "included2";
        String included3 = "included3";
        String ns1 = "http://something1";
        String ns2 = "http://something2";
        String ns3 = "http://something3";
        nsContext.put("included1", "http://something1");
        nsContext.put("included2", "http://something2");
        nsContext.put("included3", "http://something3");
        Optional actual = NamespaceHandler.getAlias(nsContext, (String)"http://something2");
        Assert.assertTrue((boolean)actual.isPresent());
        Assert.assertEquals((Object)"http://something2", ((Map.Entry)actual.get()).getValue());
        Assert.assertEquals((Object)"included2", ((Map.Entry)actual.get()).getKey());
    }

    @Test
    public void testGetAliasNonExistent() {
        HashMap<String, String> nsContext = new HashMap<String, String>();
        String included1 = "included1";
        String ns1 = "http://something1";
        nsContext.put("included1", "http://something1");
        Optional actual = NamespaceHandler.getAlias(nsContext, (String)"some");
        Assert.assertFalse((boolean)actual.isPresent());
    }
}

