/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.common;

import java.util.Arrays;
import java.util.List;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManager;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManagerStackStore;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeUtils;
import org.kie.workbench.common.dmn.client.editors.types.common.ItemDefinitionUtils;
import org.kie.workbench.common.dmn.client.editors.types.persistence.DataTypeStore;
import org.kie.workbench.common.dmn.client.editors.types.persistence.ItemDefinitionRecordEngine;
import org.kie.workbench.common.dmn.client.editors.types.persistence.ItemDefinitionStore;
import org.kie.workbench.common.dmn.client.editors.types.persistence.validation.DataTypeNameValidator;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DataTypeUtilsTest {
    @Mock
    private ItemDefinitionUtils itemDefinitionUtils;
    @Mock
    private DataTypeStore dataTypeStore;
    @Mock
    private TranslationService translationService;
    @Mock
    private ItemDefinitionRecordEngine recordEngine;
    @Mock
    private ItemDefinitionStore itemDefinitionStore;
    @Mock
    private ManagedInstance<DataTypeManager> dataTypeManagers;
    @Mock
    private DataTypeNameValidator dataTypeNameValidator;
    @Mock
    private DataTypeManagerStackStore typeStack;
    private DataTypeManager dataTypeManager;
    private DataTypeUtils utils;

    @Before
    public void setup() {
        this.dataTypeManager = (DataTypeManager)Mockito.spy((Object)new DataTypeManager(this.translationService, this.recordEngine, this.itemDefinitionStore, this.dataTypeStore, this.itemDefinitionUtils, this.dataTypeManagers, this.dataTypeNameValidator, this.typeStack));
        this.utils = (DataTypeUtils)Mockito.spy((Object)new DataTypeUtils(this.dataTypeStore, this.dataTypeManager));
    }

    @Test
    public void testDefaultDataTypes() {
        List dataTypes = this.utils.defaultDataTypes();
        Assert.assertEquals((long)10L, (long)dataTypes.size());
        Assert.assertEquals((Object)"Any", (Object)((DataType)dataTypes.get(0)).getType());
        Assert.assertEquals((Object)"boolean", (Object)((DataType)dataTypes.get(1)).getType());
        Assert.assertEquals((Object)"context", (Object)((DataType)dataTypes.get(2)).getType());
        Assert.assertEquals((Object)"date", (Object)((DataType)dataTypes.get(3)).getType());
        Assert.assertEquals((Object)"date and time", (Object)((DataType)dataTypes.get(4)).getType());
        Assert.assertEquals((Object)"days and time duration", (Object)((DataType)dataTypes.get(5)).getType());
        Assert.assertEquals((Object)"number", (Object)((DataType)dataTypes.get(6)).getType());
        Assert.assertEquals((Object)"string", (Object)((DataType)dataTypes.get(7)).getType());
        Assert.assertEquals((Object)"time", (Object)((DataType)dataTypes.get(8)).getType());
        Assert.assertEquals((Object)"years and months duration", (Object)((DataType)dataTypes.get(9)).getType());
    }

    @Test
    public void testCustomDataTypes() {
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        DataType dataType2 = (DataType)Mockito.mock(DataType.class);
        List<DataType> unorderedDataTypes = Arrays.asList(dataType1, dataType2);
        List<DataType> expectedDataTypes = Arrays.asList(dataType2, dataType1);
        Mockito.when((Object)this.dataTypeStore.getTopLevelDataTypes()).thenReturn(unorderedDataTypes);
        Mockito.when((Object)dataType1.getName()).thenReturn((Object)"z");
        Mockito.when((Object)dataType2.getName()).thenReturn((Object)"a");
        List actualDataTypes = this.utils.customDataTypes();
        Assert.assertEquals(expectedDataTypes, (Object)actualDataTypes);
    }
}

