/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.common.errors;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.errors.DataTypeNameIsNotUniqueErrorMessage;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypeNameIsNotUniqueErrorMessageTest {
    @Mock
    private TranslationService translationService;

    @Test
    public void testGetStrongMessage() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        String dataTypeName = "name";
        String expectedErrorMessage = "*Expected strong message.*";
        DataTypeNameIsNotUniqueErrorMessage errorMessage = new DataTypeNameIsNotUniqueErrorMessage(this.translationService);
        Mockito.when((Object)dataType.getName()).thenReturn((Object)"name");
        Mockito.when((Object)this.translationService.format("DataTypeNameIsNotUniqueErrorMessage.StrongMessage", new Object[]{"name"})).thenReturn((Object)"*Expected strong message.*");
        String actualErrorMessage = errorMessage.getStrongMessage(dataType);
        Assert.assertEquals((Object)"*Expected strong message.*", (Object)actualErrorMessage);
    }

    @Test
    public void testGetRegularMessage() {
        String expectedErrorMessage = "Expected regular message.";
        DataTypeNameIsNotUniqueErrorMessage errorMessage = new DataTypeNameIsNotUniqueErrorMessage(this.translationService);
        Mockito.when((Object)this.translationService.format("DataTypeNameIsNotUniqueErrorMessage.RegularMessage", new Object[0])).thenReturn((Object)"Expected regular message.");
        String actualErrorMessage = errorMessage.getRegularMessage();
        Assert.assertEquals((Object)"Expected regular message.", (Object)actualErrorMessage);
    }
}

