/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.HTMLElement;
import freemarker.template.utility.Collections12;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManager;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeList;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListItem;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.DataTypeEditModeToggleEvent;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.DataTypeStackHash;
import org.kie.workbench.common.dmn.client.editors.types.persistence.DataTypeStore;
import org.kie.workbench.common.dmn.client.editors.types.search.DataTypeSearchBar;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypeListTest {
    @Mock
    private DataTypeList.View view;
    @Mock
    private ManagedInstance<DataTypeListItem> listItems;
    @Mock
    private DataTypeListItem treeGridItem;
    @Mock
    private DataTypeManager dataTypeManager;
    @Mock
    private DataTypeSearchBar searchBar;
    @Mock
    private Consumer<DataTypeListItem> listItemConsumer;
    private DataTypeStore dataTypeStore;
    private DataTypeStackHash dataTypeStackHash;
    @Captor
    private ArgumentCaptor<List<DataTypeListItem>> listItemsCaptor;
    private DataTypeList dataTypeList;

    @Before
    public void setup() {
        this.dataTypeStore = new DataTypeStore();
        this.dataTypeStackHash = new DataTypeStackHash(this.dataTypeStore);
        this.dataTypeList = (DataTypeList)Mockito.spy((Object)new DataTypeList(this.view, this.listItems, this.dataTypeManager, this.searchBar, this.dataTypeStackHash));
        Mockito.when((Object)this.listItems.get()).thenReturn((Object)this.treeGridItem);
    }

    @Test
    public void testSetup() {
        this.dataTypeList.setup();
        ((DataTypeList.View)Mockito.verify((Object)this.view)).init((Object)this.dataTypeList);
    }

    @Test
    public void testGetElement() {
        HTMLElement htmlElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.view.getElement()).thenReturn((Object)htmlElement);
        Assert.assertEquals((Object)htmlElement, (Object)this.dataTypeList.getElement());
    }

    @Test
    public void testSetupItems() {
        DataType dataType1 = this.makeDataType("item", "iITem", new DataType[0]);
        DataType dataType2 = this.makeDataType("item", "iITem", new DataType[0]);
        DataTypeListItem listItem1 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem2 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        List<DataType> dataTypes = Arrays.asList(dataType1, dataType2);
        List<DataTypeListItem> listItems = Arrays.asList(listItem1, listItem2);
        ((DataTypeList)Mockito.doReturn(listItems).when((Object)this.dataTypeList)).makeDataTypeListItems(dataTypes);
        this.dataTypeList.setupItems(dataTypes);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.dataTypeList});
        ((DataTypeList)inOrder.verify((Object)this.dataTypeList)).setListItems(listItems);
        ((DataTypeList)inOrder.verify((Object)this.dataTypeList)).setupViewItems();
        ((DataTypeList)inOrder.verify((Object)this.dataTypeList)).collapseItemsInTheFirstLevel();
    }

    @Test
    public void testCollapseItemsInTheFirstLevel() {
        DataTypeListItem listItem1 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem2 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem3 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem4 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        List<DataTypeListItem> listItems = Arrays.asList(listItem1, listItem2, listItem3, listItem4);
        Mockito.when((Object)listItem1.getLevel()).thenReturn((Object)1);
        Mockito.when((Object)listItem2.getLevel()).thenReturn((Object)2);
        Mockito.when((Object)listItem3.getLevel()).thenReturn((Object)1);
        Mockito.when((Object)listItem4.getLevel()).thenReturn((Object)2);
        ((DataTypeList)Mockito.doReturn(listItems).when((Object)this.dataTypeList)).getItems();
        this.dataTypeList.collapseItemsInTheFirstLevel();
        ((DataTypeListItem)Mockito.verify((Object)listItem1)).collapse();
        ((DataTypeListItem)Mockito.verify((Object)listItem2, (VerificationMode)Mockito.never())).collapse();
        ((DataTypeListItem)Mockito.verify((Object)listItem3)).collapse();
        ((DataTypeListItem)Mockito.verify((Object)listItem4, (VerificationMode)Mockito.never())).collapse();
    }

    @Test
    public void testExpandAllWhenSearchBarIsEnabledEnabled() {
        DataTypeListItem listItem1 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem2 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem3 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        List<DataTypeListItem> listItems = Arrays.asList(listItem1, listItem2, listItem3);
        Mockito.when((Object)this.searchBar.isEnabled()).thenReturn((Object)true);
        ((DataTypeList)Mockito.doReturn(listItems).when((Object)this.dataTypeList)).getItems();
        this.dataTypeList.expandAll();
        ((DataTypeListItem)Mockito.verify((Object)listItem1, (VerificationMode)Mockito.never())).expand();
        ((DataTypeListItem)Mockito.verify((Object)listItem2, (VerificationMode)Mockito.never())).expand();
        ((DataTypeListItem)Mockito.verify((Object)listItem3, (VerificationMode)Mockito.never())).expand();
    }

    @Test
    public void testExpandAllWhenSearchBarIsDisabledEnabled() {
        DataTypeListItem listItem1 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem2 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem3 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        List<DataTypeListItem> listItems = Arrays.asList(listItem1, listItem2, listItem3);
        Mockito.when((Object)this.searchBar.isEnabled()).thenReturn((Object)false);
        ((DataTypeList)Mockito.doReturn(listItems).when((Object)this.dataTypeList)).getItems();
        this.dataTypeList.expandAll();
        ((DataTypeListItem)Mockito.verify((Object)listItem1)).expand();
        ((DataTypeListItem)Mockito.verify((Object)listItem2)).expand();
        ((DataTypeListItem)Mockito.verify((Object)listItem3)).expand();
    }

    @Test
    public void testCollapseAllWhenSearchBarIsEnabledEnabled() {
        DataTypeListItem listItem1 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem2 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem3 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        List<DataTypeListItem> listItems = Arrays.asList(listItem1, listItem2, listItem3);
        Mockito.when((Object)this.searchBar.isEnabled()).thenReturn((Object)true);
        ((DataTypeList)Mockito.doReturn(listItems).when((Object)this.dataTypeList)).getItems();
        this.dataTypeList.collapseAll();
        ((DataTypeListItem)Mockito.verify((Object)listItem1, (VerificationMode)Mockito.never())).collapse();
        ((DataTypeListItem)Mockito.verify((Object)listItem2, (VerificationMode)Mockito.never())).collapse();
        ((DataTypeListItem)Mockito.verify((Object)listItem3, (VerificationMode)Mockito.never())).collapse();
    }

    @Test
    public void testCollapseAllWhenSearchBarIsDisabledEnabled() {
        DataTypeListItem listItem1 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem2 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem3 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        List<DataTypeListItem> listItems = Arrays.asList(listItem1, listItem2, listItem3);
        Mockito.when((Object)this.searchBar.isEnabled()).thenReturn((Object)false);
        ((DataTypeList)Mockito.doReturn(listItems).when((Object)this.dataTypeList)).getItems();
        this.dataTypeList.collapseAll();
        ((DataTypeListItem)Mockito.verify((Object)listItem1)).collapse();
        ((DataTypeListItem)Mockito.verify((Object)listItem2)).collapse();
        ((DataTypeListItem)Mockito.verify((Object)listItem3)).collapse();
    }

    @Test
    public void testSetViewItemsWhenSomeDataTypeListItemIsReadOnly() {
        DataTypeListItem listItem1 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem2 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        List<DataTypeListItem> listItems = Arrays.asList(listItem1, listItem2);
        ((DataTypeList)Mockito.doReturn(listItems).when((Object)this.dataTypeList)).getItems();
        Mockito.when((Object)listItem1.isReadOnly()).thenReturn((Object)false);
        Mockito.when((Object)listItem2.isReadOnly()).thenReturn((Object)true);
        this.dataTypeList.setupViewItems();
        ((DataTypeList.View)Mockito.verify((Object)this.view)).setupListItems(listItems);
        ((DataTypeList.View)Mockito.verify((Object)this.view)).showReadOnlyMessage(true);
    }

    @Test
    public void testSetViewItemsWhenNoDataTypeListItemIsReadOnly() {
        DataTypeListItem listItem1 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem2 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        List<DataTypeListItem> listItems = Arrays.asList(listItem1, listItem2);
        ((DataTypeList)Mockito.doReturn(listItems).when((Object)this.dataTypeList)).getItems();
        Mockito.when((Object)listItem1.isReadOnly()).thenReturn((Object)false);
        Mockito.when((Object)listItem2.isReadOnly()).thenReturn((Object)false);
        this.dataTypeList.setupViewItems();
        ((DataTypeList.View)Mockito.verify((Object)this.view)).setupListItems(listItems);
        ((DataTypeList.View)Mockito.verify((Object)this.view)).showReadOnlyMessage(false);
    }

    @Test
    public void testMakeDataTypeListItemsWithoutSubItems() {
        DataType dataType1 = this.makeDataType("item", "iITem", new DataType[0]);
        DataType dataType2 = this.makeDataType("item", "iITem", new DataType[0]);
        List<DataType> dataTypes = Arrays.asList(dataType1, dataType2);
        this.dataTypeList.makeDataTypeListItems(dataTypes);
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).makeTreeListItems((DataType)Matchers.eq((Object)dataType1), Matchers.eq((int)1));
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).makeTreeListItems((DataType)Matchers.eq((Object)dataType2), Matchers.eq((int)1));
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList, (VerificationMode)Mockito.times((int)2))).makeTreeListItems((DataType)Matchers.any(), Matchers.anyInt());
    }

    @Test
    public void testMakeDataTypeListItemsWithSubItems() {
        DataType subDataType3 = this.makeDataType("subItem3", "subItemType3", new DataType[0]);
        DataType subDataType1 = this.makeDataType("subItem1", "subItemType1", new DataType[0]);
        DataType subDataType2 = this.makeDataType("subItem2", "subItemType2", subDataType3);
        DataType dataType = this.makeDataType("item", "iITem", subDataType1, subDataType2);
        List<DataType> dataTypes = Collections.singletonList(dataType);
        this.dataTypeList.makeDataTypeListItems(dataTypes);
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).makeTreeListItems((DataType)Matchers.eq((Object)dataType), Matchers.eq((int)1));
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).makeTreeListItems((DataType)Matchers.eq((Object)subDataType1), Matchers.eq((int)2));
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).makeTreeListItems((DataType)Matchers.eq((Object)subDataType2), Matchers.eq((int)2));
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).makeTreeListItems((DataType)Matchers.eq((Object)subDataType3), Matchers.eq((int)3));
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList, (VerificationMode)Mockito.times((int)4))).makeTreeListItems((DataType)Matchers.any(), Matchers.anyInt());
    }

    @Test
    public void testMakeTreeListItems() {
        DataType item1 = this.makeDataType("item1", "iITem1", new DataType[0]);
        DataType item2 = this.makeDataType("item2", "iITem2", new DataType[0]);
        DataType item3 = this.makeDataType("item", "iITem", item1, item2);
        List listItems = this.dataTypeList.makeTreeListItems(item3, 1);
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).makeTreeListItems(item3, 1);
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).makeTreeListItems(item1, 2);
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).makeTreeListItems(item2, 2);
        Assert.assertEquals((long)3L, (long)listItems.size());
    }

    @Test
    public void testRefreshSubItems() {
        DataTypeListItem listItem0 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem1 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem2 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem3 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataType dataType0 = (DataType)Mockito.mock(DataType.class);
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        DataType dataType2 = (DataType)Mockito.mock(DataType.class);
        DataType dataType3 = (DataType)Mockito.mock(DataType.class);
        DataTypeManager dataTypeManager1 = (DataTypeManager)Mockito.mock(DataTypeManager.class);
        DataTypeManager dataTypeManager2 = (DataTypeManager)Mockito.mock(DataTypeManager.class);
        DataTypeManager dataTypeManager3 = (DataTypeManager)Mockito.mock(DataTypeManager.class);
        ArrayList items = new ArrayList();
        boolean level = true;
        Mockito.when((Object)listItem0.getLevel()).thenReturn((Object)1);
        Mockito.when((Object)listItem0.getDataType()).thenReturn((Object)dataType0);
        Mockito.when((Object)listItem1.getDataType()).thenReturn((Object)dataType1);
        Mockito.when((Object)listItem2.getDataType()).thenReturn((Object)dataType2);
        Mockito.when((Object)listItem3.getDataType()).thenReturn((Object)dataType3);
        Mockito.when((Object)this.dataTypeManager.from(dataType1)).thenReturn((Object)dataTypeManager1);
        Mockito.when((Object)this.dataTypeManager.from(dataType2)).thenReturn((Object)dataTypeManager2);
        Mockito.when((Object)this.dataTypeManager.from(dataType3)).thenReturn((Object)dataTypeManager3);
        ((DataTypeList)Mockito.doReturn((Object)Collections12.singletonList((Object)listItem1)).when((Object)this.dataTypeList)).makeTreeListItems(dataType1, 2);
        ((DataTypeList)Mockito.doReturn((Object)Collections12.singletonList((Object)listItem2)).when((Object)this.dataTypeList)).makeTreeListItems(dataType2, 2);
        ((DataTypeList)Mockito.doReturn((Object)Collections12.singletonList((Object)listItem3)).when((Object)this.dataTypeList)).makeTreeListItems(dataType3, 2);
        ((DataTypeList)Mockito.doReturn(items).when((Object)this.dataTypeList)).getItems();
        this.dataTypeList.refreshSubItemsFromListItem(listItem0, Arrays.asList(dataType1, dataType2, dataType3));
        ((DataTypeList.View)Mockito.verify((Object)this.view)).cleanSubTypes((DataType)Matchers.eq((Object)dataType0));
        ((DataTypeList.View)Mockito.verify((Object)this.view)).addSubItems((DataType)Matchers.eq((Object)dataType0), (List)this.listItemsCaptor.capture());
        ((DataTypeManager)Mockito.verify((Object)dataTypeManager1)).withIndexedItemDefinition();
        ((DataTypeManager)Mockito.verify((Object)dataTypeManager2)).withIndexedItemDefinition();
        ((DataTypeManager)Mockito.verify((Object)dataTypeManager3)).withIndexedItemDefinition();
        List actualItems = (List)this.listItemsCaptor.getValue();
        List<DataTypeListItem> expectedItems = Arrays.asList(listItem1, listItem2, listItem3);
        Assert.assertEquals(expectedItems, (Object)actualItems);
    }

    @Test
    public void testMakeListItem() {
        DataTypeListItem expectedListItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        ((DataTypeList)Mockito.doCallRealMethod().when((Object)this.dataTypeList)).makeListItem();
        Mockito.when((Object)this.listItems.get()).thenReturn((Object)expectedListItem);
        DataTypeListItem actualListItem = this.dataTypeList.makeListItem();
        ((DataTypeListItem)Mockito.verify((Object)expectedListItem)).init((DataTypeList)Matchers.eq((Object)this.dataTypeList));
        Assert.assertEquals((Object)expectedListItem, (Object)actualListItem);
    }

    @Test
    public void testRemoveItemByDataType() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        String uuid = "uuid";
        ((DataTypeList)Mockito.doNothing().when((Object)this.dataTypeList)).removeItem(Matchers.anyString());
        Mockito.when((Object)dataType.getUUID()).thenReturn((Object)"uuid");
        this.dataTypeList.removeItem(dataType);
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).removeItem("uuid");
        ((DataTypeList.View)Mockito.verify((Object)this.view)).removeItem(dataType);
    }

    @Test
    public void testRemoveItemByUUID() {
        DataType dataType0 = (DataType)Mockito.mock(DataType.class);
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        DataTypeListItem dataTypeListItem0 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem dataTypeListItem1 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        ArrayList<DataTypeListItem> items = new ArrayList<DataTypeListItem>(Arrays.asList(dataTypeListItem0, dataTypeListItem1));
        Mockito.when((Object)dataType0.getUUID()).thenReturn((Object)"012");
        Mockito.when((Object)dataType1.getUUID()).thenReturn((Object)"345");
        Mockito.when((Object)dataTypeListItem0.getDataType()).thenReturn((Object)dataType0);
        Mockito.when((Object)dataTypeListItem1.getDataType()).thenReturn((Object)dataType1);
        Mockito.when((Object)this.dataTypeList.getItems()).thenReturn(items);
        this.dataTypeList.removeItem("012");
        List expected = Collections12.singletonList((Object)dataTypeListItem1);
        List actual = this.dataTypeList.getItems();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testFindItemWhenItemExists() {
        String uuid1 = "uuid1";
        String uuid2 = "uuid2";
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        DataType dataType2 = (DataType)Mockito.mock(DataType.class);
        DataTypeListItem dataTypeListItem1 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem dataTypeListItem2 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        ArrayList<DataTypeListItem> existingItems = new ArrayList<DataTypeListItem>(Arrays.asList(dataTypeListItem1, dataTypeListItem2));
        Mockito.when((Object)dataType1.getUUID()).thenReturn((Object)"uuid1");
        Mockito.when((Object)dataType2.getUUID()).thenReturn((Object)"uuid2");
        Mockito.when((Object)dataTypeListItem1.getDataType()).thenReturn((Object)dataType1);
        Mockito.when((Object)dataTypeListItem2.getDataType()).thenReturn((Object)dataType2);
        Mockito.when((Object)this.dataTypeList.getItems()).thenReturn(existingItems);
        Optional item = this.dataTypeList.findItem(dataType1);
        Assert.assertEquals((Object)dataTypeListItem1, item.get());
    }

    @Test
    public void testFindItemWhenItemDoesNotExist() {
        String uuid1 = "uuid1";
        String uuid2 = "uuid2";
        String uuid3 = "uuid3";
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        DataType dataType2 = (DataType)Mockito.mock(DataType.class);
        DataType dataType3 = (DataType)Mockito.mock(DataType.class);
        DataTypeListItem dataTypeListItem1 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem dataTypeListItem2 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        ArrayList<DataTypeListItem> existingItems = new ArrayList<DataTypeListItem>(Arrays.asList(dataTypeListItem1, dataTypeListItem2));
        Mockito.when((Object)dataType1.getUUID()).thenReturn((Object)"uuid1");
        Mockito.when((Object)dataType2.getUUID()).thenReturn((Object)"uuid2");
        Mockito.when((Object)dataType3.getUUID()).thenReturn((Object)"uuid3");
        Mockito.when((Object)dataTypeListItem1.getDataType()).thenReturn((Object)dataType1);
        Mockito.when((Object)dataTypeListItem2.getDataType()).thenReturn((Object)dataType2);
        Mockito.when((Object)this.dataTypeList.getItems()).thenReturn(existingItems);
        Optional item = this.dataTypeList.findItem(dataType3);
        Assert.assertFalse((boolean)item.isPresent());
    }

    @Test
    public void testRefreshItemsByUpdatedDataTypes() {
        String uuid1 = "uuid1";
        String uuid2 = "uuid2";
        String uuid3 = "uuid3";
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        DataType dataType2 = (DataType)Mockito.mock(DataType.class);
        DataType dataType3 = (DataType)Mockito.mock(DataType.class);
        DataTypeListItem listItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        List<DataType> subDataTypes = Arrays.asList(dataType2, dataType3);
        ArrayList<DataType> existingItems = new ArrayList<DataType>(Arrays.asList(dataType1, dataType2, dataType3));
        ((DataTypeList)Mockito.doReturn(Optional.of(listItem)).when((Object)this.dataTypeList)).findItem(dataType1);
        ((DataTypeList)Mockito.doReturn(Optional.empty()).when((Object)this.dataTypeList)).findItem(dataType2);
        ((DataTypeList)Mockito.doReturn(Optional.empty()).when((Object)this.dataTypeList)).findItem(dataType3);
        ((DataTypeList)Mockito.doNothing().when((Object)this.dataTypeList)).refreshSubItemsFromListItem((DataTypeListItem)Matchers.any(), Matchers.anyListOf(DataType.class));
        Mockito.when((Object)dataType1.getUUID()).thenReturn((Object)"uuid1");
        Mockito.when((Object)dataType2.getUUID()).thenReturn((Object)"uuid2");
        Mockito.when((Object)dataType3.getUUID()).thenReturn((Object)"uuid3");
        Mockito.when((Object)dataType1.getSubDataTypes()).thenReturn(subDataTypes);
        this.dataTypeList.refreshItemsByUpdatedDataTypes(existingItems);
        ((DataTypeListItem)Mockito.verify((Object)listItem)).refresh();
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).refreshSubItemsFromListItem(listItem, subDataTypes);
        ((DataTypeSearchBar)Mockito.verify((Object)this.searchBar)).refresh();
    }

    @Test
    public void testAddDataType() {
        DataTypeListItem listItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        Mockito.when((Object)this.dataTypeManager.fromNew()).thenReturn((Object)this.dataTypeManager);
        Mockito.when((Object)this.dataTypeManager.get()).thenReturn((Object)dataType);
        ((DataTypeList)Mockito.doReturn((Object)listItem).when((Object)this.dataTypeList)).makeListItem(dataType);
        this.dataTypeList.addDataType();
        ((DataType)Mockito.verify((Object)dataType)).create();
        ((DataTypeList.View)Mockito.verify((Object)this.view)).addSubItem(listItem);
        ((DataTypeListItem)Mockito.verify((Object)listItem)).enableEditMode();
    }

    @Test
    public void testInsertBelow() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        DataType reference = (DataType)Mockito.mock(DataType.class);
        DataTypeListItem listItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        ((DataTypeList)Mockito.doReturn((Object)listItem).when((Object)this.dataTypeList)).makeListItem(dataType);
        this.dataTypeList.insertBelow(dataType, reference);
        ((DataTypeList.View)Mockito.verify((Object)this.view)).insertBelow(listItem, reference);
    }

    @Test
    public void testInsertAbove() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        DataType reference = (DataType)Mockito.mock(DataType.class);
        DataTypeListItem listItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        ((DataTypeList)Mockito.doReturn((Object)listItem).when((Object)this.dataTypeList)).makeListItem(dataType);
        this.dataTypeList.insertAbove(dataType, reference);
        ((DataTypeList.View)Mockito.verify((Object)this.view)).insertAbove(listItem, reference);
    }

    @Test
    public void testMakeListItemWithDataType() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        DataTypeListItem expectedListItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        ((DataTypeList)Mockito.doReturn((Object)expectedListItem).when((Object)this.dataTypeList)).makeListItem();
        ((DataTypeList)Mockito.doReturn(new ArrayList()).when((Object)this.dataTypeList)).getItems();
        DataTypeListItem actualListItem = this.dataTypeList.makeListItem(dataType);
        List actualItems = this.dataTypeList.getItems();
        List expectedItems = Collections12.singletonList((Object)expectedListItem);
        ((DataTypeListItem)Mockito.verify((Object)expectedListItem)).setupDataType(dataType, 1);
        Assert.assertEquals((Object)expectedListItem, (Object)actualListItem);
        Assert.assertEquals((Object)expectedItems, (Object)actualItems);
    }

    @Test
    public void testShowNoDataTypesFound() {
        this.dataTypeList.showNoDataTypesFound();
        ((DataTypeList.View)Mockito.verify((Object)this.view)).showNoDataTypesFound();
    }

    @Test
    public void testShowListItems() {
        this.dataTypeList.showListItems();
        ((DataTypeList.View)Mockito.verify((Object)this.view)).showOrHideNoCustomItemsMessage();
    }

    @Test
    public void testEnableEditMode() {
        String dataTypeHash = "tCity.name";
        DataTypeListItem listItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        ((DataTypeList)Mockito.doReturn(Optional.of(listItem)).when((Object)this.dataTypeList)).findItemByDataTypeHash("tCity.name");
        this.dataTypeList.enableEditMode("tCity.name");
        ((DataTypeListItem)Mockito.verify((Object)listItem)).enableEditMode();
    }

    @Test
    public void testInsertNestedField() {
        String dataTypeHash = "tCity.name";
        DataTypeListItem listItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        ((DataTypeList)Mockito.doReturn(Optional.of(listItem)).when((Object)this.dataTypeList)).findItemByDataTypeHash("tCity.name");
        this.dataTypeList.insertNestedField("tCity.name");
        ((DataTypeListItem)Mockito.verify((Object)listItem)).insertNestedField();
    }

    @Test
    public void testFireListItemUpdateCallbacks() {
        String dataTypeHash = "tCity.name";
        DataTypeListItem listItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        ((DataTypeList)Mockito.doReturn(Optional.of(listItem)).when((Object)this.dataTypeList)).findItemByDataTypeHash("tCity.name");
        this.dataTypeList.registerDataTypeListItemUpdateCallback(this.listItemConsumer);
        this.dataTypeList.fireOnDataTypeListItemUpdateCallback("tCity.name");
        ((Consumer)Mockito.verify(this.listItemConsumer)).accept(listItem);
    }

    @Test
    public void testFindItemByDataTypeHashWhenListItemIsFound() {
        DataTypeListItem tCity = this.listItem(this.makeDataType("001", "tCity", ""));
        DataTypeListItem tCityId = this.listItem(this.makeDataType("002", "id", "001"));
        DataTypeListItem tCityName = this.listItem(this.makeDataType("003", "name", "001"));
        ((DataTypeList)Mockito.doReturn(Arrays.asList(tCity, tCityId, tCityName)).when((Object)this.dataTypeList)).getItems();
        Optional item = this.dataTypeList.findItemByDataTypeHash("tCity.name");
        Assert.assertTrue((boolean)item.isPresent());
        Assert.assertEquals(item.get(), (Object)tCityName);
    }

    @Test
    public void testFindItemByDataTypeHashWhenListItemIsNotFound() {
        ((DataTypeList)Mockito.doReturn(Collections.emptyList()).when((Object)this.dataTypeList)).getItems();
        Optional item = this.dataTypeList.findItemByDataTypeHash("tCity.name");
        Assert.assertFalse((boolean)item.isPresent());
    }

    private DataTypeListItem listItem(DataType dataType) {
        DataTypeListItem listItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        Mockito.when((Object)listItem.getDataType()).thenReturn((Object)dataType);
        return listItem;
    }

    private DataType makeDataType(String name, String type, DataType ... subDataTypes) {
        DataType dataType = this.makeDataType("default", name, "");
        Mockito.when((Object)dataType.getType()).thenReturn((Object)type);
        Mockito.when((Object)dataType.getSubDataTypes()).thenReturn(Arrays.asList(subDataTypes));
        return dataType;
    }

    private DataType makeDataType(String uuid, String name, String parentUUID) {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        Mockito.when((Object)dataType.getUUID()).thenReturn((Object)uuid);
        Mockito.when((Object)dataType.getName()).thenReturn((Object)name);
        Mockito.when((Object)dataType.getParentUUID()).thenReturn((Object)parentUUID);
        this.dataTypeStore.index(dataType.getUUID(), dataType);
        return dataType;
    }

    @Test
    public void testOnDataTypeEditModeToggleStartEditing() {
        DataTypeListItem currentEditingItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeEditModeToggleEvent event = new DataTypeEditModeToggleEvent(true, currentEditingItem);
        this.dataTypeList.onDataTypeEditModeToggle(event);
        DataTypeListItem actual = this.dataTypeList.getCurrentEditingItem();
        Assert.assertEquals((Object)currentEditingItem, (Object)actual);
    }

    @Test
    public void testOnDataTypeEditModeToggleStopEditing() {
        DataTypeListItem currentEditingItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeEditModeToggleEvent event = new DataTypeEditModeToggleEvent(false, currentEditingItem);
        this.dataTypeList.onDataTypeEditModeToggle(event);
        DataTypeListItem actual = this.dataTypeList.getCurrentEditingItem();
        Assert.assertEquals(null, (Object)actual);
    }

    @Test
    public void testOnDataTypeEditModeToggleChangedCurrentEditingItem() {
        DataTypeListItem currentEditingItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem previousEditingItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        List<DataTypeListItem> listItems = Arrays.asList(currentEditingItem, previousEditingItem);
        ((DataTypeList)Mockito.doReturn(listItems).when((Object)this.dataTypeList)).getItems();
        DataTypeEditModeToggleEvent event = new DataTypeEditModeToggleEvent(true, currentEditingItem);
        this.dataTypeList.setCurrentEditingItem(previousEditingItem);
        this.dataTypeList.onDataTypeEditModeToggle(event);
        DataTypeListItem actual = this.dataTypeList.getCurrentEditingItem();
        Assert.assertEquals((Object)currentEditingItem, (Object)actual);
        ((DataTypeListItem)Mockito.verify((Object)previousEditingItem)).disableEditMode();
    }
}

