/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.event.dom.client.ClickEvent;
import elemental2.dom.DOMTokenList;
import elemental2.dom.Element;
import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.Node;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.v1_1.ConstraintType;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.DataTypeConstraintModal;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.DataTypeConstraintModalView;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.DataTypeConstraintComponent;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.views.pfly.selectpicker.JQuery;
import org.uberfire.client.views.pfly.selectpicker.JQueryEvent;
import org.uberfire.client.views.pfly.selectpicker.JQuerySelectPickerEvent;
import org.uberfire.client.views.pfly.selectpicker.JQuerySelectPickerTarget;
import org.uberfire.mvp.Command;

@RunWith(value=LienzoMockitoTestRunner.class)
public class DataTypeConstraintModalViewTest {
    @Mock
    private HTMLDivElement header;
    @Mock
    private HTMLDivElement body;
    @Mock
    private HTMLDivElement footer;
    @Mock
    private HTMLDivElement componentContainer;
    @Mock
    private HTMLButtonElement okButton;
    @Mock
    private HTMLButtonElement cancelButton;
    @Mock
    private HTMLAnchorElement clearAllAnchor;
    @Mock
    private HTMLElement type;
    @Mock
    private HTMLDivElement selectConstraint;
    @Mock
    private HTMLDivElement constraintWarningMessage;
    @Mock
    private HTMLButtonElement closeConstraintWarningMessage;
    @Mock
    private DataTypeConstraintModal presenter;
    private DataTypeConstraintModalView view;

    @Before
    public void setup() {
        this.view = (DataTypeConstraintModalView)Mockito.spy((Object)new DataTypeConstraintModalView(this.header, this.body, this.footer, this.componentContainer, this.okButton, this.cancelButton, this.clearAllAnchor, this.type, this.selectConstraint, this.constraintWarningMessage, this.closeConstraintWarningMessage));
        this.view.init(this.presenter);
    }

    @Test
    public void testInit() {
        ((DataTypeConstraintModalView)Mockito.doNothing().when((Object)this.view)).setupSelectPicker();
        ((DataTypeConstraintModalView)Mockito.doNothing().when((Object)this.view)).setupSelectPickerOnChangeHandler();
        ((DataTypeConstraintModalView)Mockito.doNothing().when((Object)this.view)).setupEmptyContainer();
        this.view.init();
        ((DataTypeConstraintModalView)Mockito.verify((Object)this.view)).setupSelectPicker();
        ((DataTypeConstraintModalView)Mockito.verify((Object)this.view)).setupSelectPickerOnChangeHandler();
        ((DataTypeConstraintModalView)Mockito.verify((Object)this.view)).setupEmptyContainer();
    }

    @Test
    public void testGetHeader() {
        String expectedHeader = "header";
        this.header.textContent = "header";
        String actualHeader = this.view.getHeader();
        Assert.assertEquals((Object)"header", (Object)actualHeader);
    }

    @Test
    public void testGetBody() {
        Assert.assertEquals((Object)this.body, (Object)this.view.getBody());
    }

    @Test
    public void testGetFooter() {
        Assert.assertEquals((Object)this.footer, (Object)this.view.getFooter());
    }

    @Test
    public void testOnOkButtonClick() {
        this.view.onOkButtonClick((ClickEvent)Mockito.mock(ClickEvent.class));
        ((DataTypeConstraintModal)Mockito.verify((Object)this.presenter)).save();
    }

    @Test
    public void testOnCancelButtonClick() {
        this.view.onCancelButtonClick((ClickEvent)Mockito.mock(ClickEvent.class));
        ((DataTypeConstraintModal)Mockito.verify((Object)this.presenter)).hide();
    }

    @Test
    public void testOnClearAllAnchorClick() {
        this.view.onClearAllAnchorClick((ClickEvent)Mockito.mock(ClickEvent.class));
        ((DataTypeConstraintModal)Mockito.verify((Object)this.presenter)).clearAll();
    }

    @Test
    public void testSetType() {
        String expectedText = "type";
        this.type.textContent = "something";
        this.view.setType("type");
        String actualText = this.type.textContent;
        Assert.assertEquals((Object)"type", (Object)actualText);
    }

    @Test
    public void testOnSelectChangeWhenValueIsNotBlank() {
        JQuerySelectPickerEvent jQueryEvent = (JQuerySelectPickerEvent)Mockito.mock(JQuerySelectPickerEvent.class);
        JQuerySelectPickerTarget pickerTarget = (JQuerySelectPickerTarget)Mockito.mock(JQuerySelectPickerTarget.class);
        ConstraintType constraintType = ConstraintType.ENUMERATION;
        ((DataTypeConstraintModalView)Mockito.doNothing().when((Object)this.view)).loadComponent(ConstraintType.ENUMERATION);
        jQueryEvent.target = pickerTarget;
        pickerTarget.value = constraintType.value();
        this.view.onSelectChange(jQueryEvent);
        ((DataTypeConstraintModalView)Mockito.verify((Object)this.view)).loadComponent(constraintType);
    }

    @Test
    public void testSetupEmptyContainer() {
        Element element = (Element)Mockito.mock(Element.class);
        this.componentContainer.firstChild = element;
        Mockito.when((Object)this.componentContainer.removeChild((Node)element)).then(a -> {
            this.componentContainer.firstChild = null;
            return element;
        });
        this.view.setupEmptyContainer();
        ((HTMLDivElement)Mockito.verify((Object)this.componentContainer)).removeChild((Node)element);
        ((HTMLDivElement)Mockito.verify((Object)this.componentContainer)).appendChild((Node)this.selectConstraint);
    }

    @Test
    public void testLoadComponent() {
        ConstraintType constraintType = ConstraintType.ENUMERATION;
        DataTypeConstraintComponent constrainComponent = (DataTypeConstraintComponent)Mockito.mock(DataTypeConstraintComponent.class);
        Element element = (Element)Mockito.mock(Element.class);
        Element previous = (Element)Mockito.mock(Element.class);
        this.componentContainer.firstChild = previous;
        Mockito.when((Object)this.presenter.getCurrentComponent()).thenReturn((Object)constrainComponent);
        Mockito.when((Object)constrainComponent.getElement()).thenReturn((Object)element);
        Mockito.when((Object)this.componentContainer.removeChild((Node)previous)).then(a -> {
            this.componentContainer.firstChild = null;
            return element;
        });
        this.view.loadComponent(constraintType);
        ((HTMLDivElement)Mockito.verify((Object)this.componentContainer)).removeChild((Node)previous);
        ((DataTypeConstraintModal)Mockito.verify((Object)this.presenter)).setupComponent(constraintType);
        ((HTMLDivElement)Mockito.verify((Object)this.componentContainer)).appendChild((Node)element);
    }

    @Test
    public void testOnShowWhenConstraintValueIsBlank() {
        Element selectPicker = (Element)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.presenter.getConstraintValue()).thenReturn(null);
        Mockito.when((Object)this.presenter.inferComponentType((String)Matchers.any())).thenCallRealMethod();
        ((DataTypeConstraintModalView)Mockito.doReturn((Object)selectPicker).when((Object)this.view)).getSelectPicker();
        ((DataTypeConstraintModalView)Mockito.doNothing().when((Object)this.view)).setPickerValue((Element)Matchers.any(), Matchers.anyString());
        this.view.onShow();
        ((DataTypeConstraintModalView)Mockito.verify((Object)this.view)).setPickerValue(selectPicker, ConstraintType.EXPRESSION.value());
    }

    @Test
    public void testOnShowWhenConstraintValueIsNotBlank() {
        Element selectPicker = (Element)Mockito.mock(HTMLElement.class);
        String constraint = "1,2,3";
        Mockito.when((Object)this.presenter.getConstraintValue()).thenReturn((Object)"1,2,3");
        Mockito.when((Object)this.presenter.inferComponentType("1,2,3")).thenReturn((Object)ConstraintType.ENUMERATION);
        ((DataTypeConstraintModalView)Mockito.doReturn((Object)selectPicker).when((Object)this.view)).getSelectPicker();
        ((DataTypeConstraintModalView)Mockito.doNothing().when((Object)this.view)).setPickerValue((Element)Matchers.any(), Matchers.anyString());
        this.view.onShow();
        ((DataTypeConstraintModalView)Mockito.verify((Object)this.view)).setPickerValue(selectPicker, ConstraintType.ENUMERATION.value());
    }

    @Test
    public void testSetupSelectPicker() {
        Element element = (Element)Mockito.mock(Element.class);
        ((DataTypeConstraintModalView)Mockito.doReturn((Object)element).when((Object)this.view)).getSelectPicker();
        ((DataTypeConstraintModalView)Mockito.doNothing().when((Object)this.view)).triggerPickerAction((Element)Matchers.any(), Matchers.anyString());
        this.view.setupSelectPicker();
        ((DataTypeConstraintModalView)Mockito.verify((Object)this.view)).triggerPickerAction(element, "refresh");
    }

    @Test
    public void testSetupSelectPickerOnChangeHandler() {
        Element element = (Element)Mockito.mock(Element.class);
        ((DataTypeConstraintModalView)Mockito.doReturn((Object)element).when((Object)this.view)).getSelectPicker();
        ((DataTypeConstraintModalView)Mockito.doNothing().when((Object)this.view)).setupOnChangeHandler((Element)Matchers.any());
        this.view.setupSelectPickerOnChangeHandler();
        ((DataTypeConstraintModalView)Mockito.verify((Object)this.view)).setupOnChangeHandler(element);
    }

    @Test
    public void testGetSelectPicker() {
        HTMLElement expectedSelect = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.body.querySelector(".selectpicker")).thenReturn((Object)expectedSelect);
        Element actualSelect = this.view.getSelectPicker();
        Assert.assertEquals((Object)expectedSelect, (Object)actualSelect);
    }

    @Test
    public void testOnCloseConstraintWarningClick() {
        this.constraintWarningMessage.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.onCloseConstraintWarningClick((ClickEvent)Mockito.mock(ClickEvent.class));
        ((DOMTokenList)Mockito.verify((Object)this.constraintWarningMessage.classList)).add(new String[]{"hidden"});
    }

    @Test
    public void testShowConstraintWarningMessage() {
        this.constraintWarningMessage.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.showConstraintWarningMessage();
        ((DOMTokenList)Mockito.verify((Object)this.constraintWarningMessage.classList)).remove(new String[]{"hidden"});
    }

    @Test
    public void testSetupOnHideHandler() {
        HTMLElement body = (HTMLElement)Mockito.mock(HTMLElement.class);
        Node modalBody = (Node)Mockito.mock(Node.class);
        Node modalContent = (Node)Mockito.mock(Node.class);
        Node modalDialog = (Node)Mockito.mock(Node.class);
        Node modalComponent = (Node)Mockito.mock(Node.class);
        Command command = (Command)Mockito.mock(Command.class);
        JQuery jQuery = (JQuery)Mockito.mock(JQuery.class);
        ArgumentCaptor captor = ArgumentCaptor.forClass(JQuery.CallbackFunction.class);
        body.parentNode = modalBody;
        modalBody.parentNode = modalContent;
        modalContent.parentNode = modalDialog;
        modalDialog.parentNode = modalComponent;
        ((DataTypeConstraintModalView)Mockito.doReturn((Object)body).when((Object)this.view)).getBody();
        Mockito.when((Object)this.view.constraintModalJQuery()).thenReturn((Object)jQuery);
        this.view.setupOnHideHandler(command);
        ((JQuery)Mockito.verify((Object)jQuery)).on((String)Matchers.eq((Object)"hidden.bs.modal"), (JQuery.CallbackFunction)captor.capture());
        ((JQuery.CallbackFunction)captor.getValue()).call((JQueryEvent)Mockito.mock(JQueryEvent.class));
        ((Command)Mockito.verify((Object)command)).execute();
    }
}

