/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.common;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.Element;
import elemental2.dom.Event;
import elemental2.dom.HTMLElement;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.common.BaseSelector;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class BaseSelectorTest {
    private BaseSelector baseSelector;
    @Mock
    private BaseSelector.View view;

    @Before
    public void testSetup() {
        this.baseSelector = (BaseSelector)Mockito.spy((Object)new BaseSelector(this.view){});
    }

    @Test
    public void testSetupInputType() {
        String defaultInputType = BaseSelector.InputType.TEXT.getHtmlInputType();
        this.baseSelector.setupInputType();
        ((BaseSelector.View)Mockito.verify((Object)this.view)).setInputType(defaultInputType);
    }

    @Test
    public void testGetValue() {
        String expected = "value";
        Mockito.when((Object)this.view.getValue()).thenReturn((Object)"value");
        String actual = this.baseSelector.getValue();
        Assert.assertEquals((Object)"value", (Object)actual);
    }

    @Test
    public void testSetValue() {
        String value = "value";
        this.baseSelector.setValue("value");
        ((BaseSelector.View)Mockito.verify((Object)this.view)).setValue("value");
    }

    @Test
    public void testSetPlaceholder() {
        String value = "value";
        this.baseSelector.setPlaceholder("value");
        ((BaseSelector.View)Mockito.verify((Object)this.view)).setPlaceholder("value");
    }

    @Test
    public void testGetElement() {
        HTMLElement expected = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.view.getElement()).thenReturn((Object)expected);
        Element actual = this.baseSelector.getElement();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testSetOnInputChangeCallback() {
        Consumer<Event> consumer = e -> {};
        this.baseSelector.setOnInputChangeCallback(consumer);
        ((BaseSelector.View)Mockito.verify((Object)this.view)).setOnInputChangeCallback(consumer);
    }

    @Test
    public void testSetOnInputBlurCallback() {
        Consumer<BlurEvent> consumer = e -> {};
        this.baseSelector.setOnInputBlurCallback(consumer);
        ((BaseSelector.View)Mockito.verify((Object)this.view)).setOnInputBlurCallback(consumer);
    }

    @Test
    public void testSelect() {
        this.baseSelector.select();
        ((BaseSelector.View)Mockito.verify((Object)this.view)).select();
    }

    @Test
    public void testToDisplay() {
        String expected = "rawValue";
        String actual = this.baseSelector.toDisplay("rawValue");
        Assert.assertEquals((Object)"rawValue", (Object)actual);
    }
}

