/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.time.picker;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.HTMLInputElement;
import java.util.Objects;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.time.picker.TimePicker;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatcher;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.views.pfly.widgets.Moment;

@RunWith(value=GwtMockitoTestRunner.class)
public class TimePickerTest {
    @Mock
    private HTMLInputElement input;
    @Mock
    private TimePicker.View view;
    @Captor
    private ArgumentCaptor<Moment> momentArgumentCaptor;
    private TimePicker picker;

    @Before
    public void setup() {
        this.picker = (TimePicker)Mockito.spy((Object)new TimePicker(this.view));
        ((TimePicker)Mockito.doReturn((Object)this.input).when((Object)this.picker)).getInputBind();
    }

    @Test
    public void testRefreshDateInPopup() {
        Moment moment = (Moment)Mockito.mock(Moment.class);
        String inputValue = "22:30:51";
        int expectedHours = 22;
        int expectedMinutes = 30;
        int expectedSeconds = 51;
        Mockito.when((Object)moment.isValid()).thenReturn((Object)true);
        Mockito.when((Object)moment.hours()).thenReturn((Object)expectedHours);
        Mockito.when((Object)moment.minutes()).thenReturn((Object)expectedMinutes);
        Mockito.when((Object)moment.seconds()).thenReturn((Object)expectedSeconds);
        ((TimePicker)Mockito.doReturn((Object)moment).when((Object)this.picker)).getDateInInput();
        this.input.value = "22:30:51";
        this.picker.refreshDateInPopup();
        ((TimePicker.View)Mockito.verify((Object)this.view)).setDate((Moment)this.momentArgumentCaptor.capture());
        Moment actual = (Moment)this.momentArgumentCaptor.getValue();
        Assert.assertEquals((long)expectedHours, (long)actual.hours());
        Assert.assertEquals((long)expectedMinutes, (long)actual.minutes());
        Assert.assertEquals((long)expectedSeconds, (long)actual.seconds());
    }

    @Test
    public void testIsDateSetInInput() {
        this.input.value = "01:25";
        boolean actual = this.picker.isDateSetInInput();
        Assert.assertTrue((boolean)actual);
    }

    @Test
    public void testIsDateSetInInputDateNotSet() {
        this.input.value = "";
        boolean actual = this.picker.isDateSetInInput();
        Assert.assertFalse((boolean)actual);
    }

    @Test
    public void testIsDateSetInInputNotATime() {
        this.input.value = "1234";
        boolean actual = this.picker.isDateSetInInput();
        Assert.assertFalse((boolean)actual);
    }

    @Test
    public void testOnDateChanged() {
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        this.picker.setOnDateChanged(consumer);
        String expected = "14:55:01";
        final Moment moment = (Moment)Mockito.mock(Moment.class);
        Mockito.when((Object)moment.format("HH:mm:ss")).thenReturn((Object)"14:55:01");
        this.picker.onDateChanged(moment);
        Assert.assertEquals((Object)"14:55:01", (Object)this.input.value);
        ((Consumer)Mockito.verify((Object)consumer)).accept(Matchers.argThat((Matcher)new ArgumentMatcher<Moment>(){

            public boolean matches(Object argument) {
                return Objects.equals(argument, moment);
            }
        }));
    }
}

