/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.years.months;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.years.months.YearsMonthsValue;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.years.months.YearsMonthsValueConverter;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class YearsMonthsValueConverterTest {
    private YearsMonthsValueConverter converter;
    @Mock
    private ClientTranslationService translationService;

    @Before
    public void setup() {
        this.converter = (YearsMonthsValueConverter)Mockito.spy((Object)new YearsMonthsValueConverter(this.translationService));
        Mockito.when((Object)this.translationService.getValue("YearsMonthsSelectorView.Years")).thenReturn((Object)"years");
        Mockito.when((Object)this.translationService.getValue("YearsMonthsSelectorView.Months")).thenReturn((Object)"months");
        Mockito.when((Object)this.translationService.getValue("YearsMonthsSelectorView.YearsAbbreviated")).thenReturn((Object)"yrs");
        Mockito.when((Object)this.translationService.getValue("YearsMonthsSelectorView.MonthsAbbreviated")).thenReturn((Object)"mos");
    }

    @Test
    public void testFromDMNStringYearsMonthsSingleDigit() {
        String input = "duration(\"P1Y2M\")";
        this.testFromDMNString("duration(\"P1Y2M\")", "1", "2");
    }

    @Test
    public void testFromDMNStringYearsMonthsSingleDigitNegative() {
        String input = "duration(\"P-1Y-2M\")";
        this.testFromDMNString("duration(\"P-1Y-2M\")", "-1", "-2");
    }

    @Test
    public void testFromDMNStringYearsMonthsMultipleDigits() {
        String input = "duration(\"P12Y11M\")";
        this.testFromDMNString("duration(\"P12Y11M\")", "12", "11");
    }

    @Test
    public void testFromDMNStringYearsMonthsMultipleDigitsNegative() {
        String input = "duration(\"P-12Y-11M\")";
        this.testFromDMNString("duration(\"P-12Y-11M\")", "-12", "-11");
    }

    @Test
    public void testFromDMNStringYearsMonthsOnlyYearSingleDigit() {
        String input = "duration(\"P1Y\")";
        this.testFromDMNString("duration(\"P1Y\")", "1", "");
    }

    @Test
    public void testFromDMNStringYearsMonthsOnlyYearSingleDigitNegative() {
        String input = "duration(\"P-1Y\")";
        this.testFromDMNString("duration(\"P-1Y\")", "-1", "");
    }

    @Test
    public void testFromDMNStringYearsMonthsOnlyYear() {
        String input = "duration(\"P12Y\")";
        this.testFromDMNString("duration(\"P12Y\")", "12", "");
    }

    @Test
    public void testFromDMNStringYearsMonthsOnlyYearNegative() {
        String input = "duration(\"P-12Y\")";
        this.testFromDMNString("duration(\"P-12Y\")", "-12", "");
    }

    @Test
    public void testFromDMNStringYearsMonthsOnlyMonthSingleDigit() {
        String input = "duration(\"P1M\")";
        this.testFromDMNString("duration(\"P1M\")", "", "1");
    }

    @Test
    public void testFromDMNStringYearsMonthsOnlyMonthSingleDigitNegative() {
        String input = "duration(\"P-1M\")";
        this.testFromDMNString("duration(\"P-1M\")", "", "-1");
    }

    @Test
    public void testFromDMNStringYearsMonthsOnlyMonth() {
        String input = "duration(\"P12M\")";
        this.testFromDMNString("duration(\"P12M\")", "", "12");
    }

    @Test
    public void testFromDMNStringYearsMonthsOnlyMonthNegative() {
        String input = "duration(\"P-12M\")";
        this.testFromDMNString("duration(\"P-12M\")", "", "-12");
    }

    @Test
    public void testFromDMNStringWhiteSpacesStartAndEnd() {
        String input = "duration( \"P1Y\" )";
        this.testFromDMNString("duration( \"P1Y\" )", "1", "");
    }

    @Test
    public void testFromDMNStringWhiteSpacesStart() {
        String input = "duration( \"P1Y\")";
        this.testFromDMNString("duration( \"P1Y\")", "1", "");
    }

    @Test
    public void testFromDMNStringWhiteSpacesEnd() {
        String input = "duration(\"P1Y\" )";
        this.testFromDMNString("duration(\"P1Y\" )", "1", "");
    }

    @Test
    public void testToDMNStringEmpty() {
        this.testToDMNString("", "", "");
    }

    @Test
    public void testToDMNStringOnlyMonth() {
        this.testToDMNString("", "1", "duration(\"P1M\")");
    }

    @Test
    public void testToDMNStringOnlyYear() {
        this.testToDMNString("1", "", "duration(\"P1Y\")");
    }

    @Test
    public void testToDMNStringYearAndMonth() {
        this.testToDMNString("2", "1", "duration(\"P2Y1M\")");
    }

    private void testToDMNString(String years, String months, String expected) {
        String actual = this.converter.toDMNString(years, months);
        Assert.assertEquals((Object)expected, (Object)actual);
        ((YearsMonthsValueConverter)Mockito.verify((Object)this.converter)).matchSigns((YearsMonthsValue)Matchers.any());
    }

    private void testFromDMNString(String input, String expectedYears, String expectedMonths) {
        YearsMonthsValue actual = this.converter.fromDMNString(input);
        Assert.assertEquals((Object)expectedYears, (Object)actual.getYears());
        Assert.assertEquals((Object)expectedMonths, (Object)actual.getMonths());
    }

    @Test
    public void testToDisplayOnlyMonths() {
        String expected = "1 mos";
        YearsMonthsValue value = new YearsMonthsValue();
        value.setMonths("1");
        this.testToDisplayValue(value, "1 mos");
    }

    @Test
    public void testToDisplayOnlyYears() {
        String expected = "1 yrs";
        YearsMonthsValue value = new YearsMonthsValue();
        value.setYears("1");
        this.testToDisplayValue(value, "1 yrs");
    }

    @Test
    public void testToDisplayYearsAndMonths() {
        String expected = "1 years, 2 months";
        YearsMonthsValue value = new YearsMonthsValue();
        value.setYears("1");
        value.setMonths("2");
        this.testToDisplayValue(value, "1 years, 2 months");
    }

    @Test
    public void testToDisplayYearsAndMonthsEmpty() {
        String expected = "";
        YearsMonthsValue value = new YearsMonthsValue();
        value.setYears("");
        value.setMonths("");
        this.testToDisplayValue(value, "");
    }

    public void testToDisplayValue(YearsMonthsValue yearsMonthsValue, String expected) {
        String actual = this.converter.toDisplayValue(yearsMonthsValue);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testToDisplayValueFromDmnValue() {
        String dmnValue = "string";
        String expected = "converted";
        YearsMonthsValue yearsMonthsValue = (YearsMonthsValue)Mockito.mock(YearsMonthsValue.class);
        ((YearsMonthsValueConverter)Mockito.doReturn((Object)yearsMonthsValue).when((Object)this.converter)).fromDMNString("string");
        ((YearsMonthsValueConverter)Mockito.doReturn((Object)"converted").when((Object)this.converter)).toDisplayValue(yearsMonthsValue);
        String actual = this.converter.toDisplayValue("string");
        ((YearsMonthsValueConverter)Mockito.verify((Object)this.converter)).toDisplayValue(yearsMonthsValue);
        ((YearsMonthsValueConverter)Mockito.verify((Object)this.converter)).fromDMNString("string");
        Assert.assertEquals((Object)"converted", (Object)actual);
    }

    @Test
    public void testRemovePrefixAndSuffix() {
        String input = "duration(\"P1Y2M\")";
        String expected = "1Y2M";
        String actual = this.converter.removePrefixAndSuffix("duration(\"P1Y2M\")");
        Assert.assertEquals((Object)"1Y2M", (Object)actual);
    }

    @Test
    public void testAddPrefixAndSuffix() {
        String expected = "duration(\"P1Y2M\")";
        String input = "1Y2M";
        String actual = YearsMonthsValueConverter.addPrefixAndSuffix((String)"1Y2M");
        Assert.assertEquals((Object)"duration(\"P1Y2M\")", (Object)actual);
    }

    @Test
    public void testMatchSignsNegativeYears() {
        this.testMatchSigns("-2", "1", -2, -1);
    }

    @Test
    public void testMatchSignsNegativeMonths() {
        this.testMatchSigns("2", "-1", -2, -1);
    }

    @Test
    public void testMatchSignsBothNegative() {
        this.testMatchSigns("-2", "-1", -2, -1);
    }

    @Test
    public void testMatchSignsBothPositive() {
        this.testMatchSigns("2", "1", 2, 1);
    }

    @Test
    public void testMathSignsOnlyYear() {
        this.testMatchSigns("-1", "", -1, 0);
    }

    private void testMatchSigns(String inputYear, String inputMonth, int expectedYear, int expectedMonth) {
        YearsMonthsValue value = new YearsMonthsValue();
        value.setYears(inputYear);
        value.setMonths(inputMonth);
        this.converter.matchSigns(value);
        int years = Integer.parseInt(value.getYears());
        int months = StringUtils.isEmpty((String)value.getMonths()) ? 0 : Integer.parseInt(value.getMonths());
        Assert.assertEquals((long)expectedYear, (long)years);
        Assert.assertEquals((long)expectedMonth, (long)months);
    }
}

