/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.enumeration;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.Element;
import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.Node;
import elemental2.dom.NodeList;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.enumeration.DataTypeConstraintEnumeration;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.enumeration.DataTypeConstraintEnumerationView;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.enumeration.DragAndDropHelper;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypeConstraintEnumerationViewTest {
    @Mock
    private HTMLDivElement items;
    @Mock
    private HTMLAnchorElement addIcon;
    @Mock
    private HTMLDivElement addButtonContainer;
    @Mock
    private DataTypeConstraintEnumeration presenter;
    private DataTypeConstraintEnumerationView view;

    @Before
    public void setup() {
        this.view = (DataTypeConstraintEnumerationView)Mockito.spy((Object)new DataTypeConstraintEnumerationView(this.items, this.addIcon, this.addButtonContainer));
        this.view.init(this.presenter);
    }

    @Test
    public void testOnAddIconClick() {
        this.view.onAddIconClick((ClickEvent)Mockito.mock(ClickEvent.class));
        ((DataTypeConstraintEnumeration)Mockito.verify((Object)this.presenter)).addEnumerationItem();
    }

    @Test
    public void testClear() {
        Element element = (Element)Mockito.mock(Element.class);
        this.items.firstChild = element;
        Mockito.when((Object)this.items.removeChild((Node)element)).then(a -> {
            this.items.firstChild = null;
            return element;
        });
        this.view.clear();
        ((HTMLDivElement)Mockito.verify((Object)this.items)).removeChild((Node)element);
    }

    @Test
    public void testAddItem() {
        Element enumerationItem = (Element)Mockito.mock(Element.class);
        DragAndDropHelper helper = (DragAndDropHelper)Mockito.mock(DragAndDropHelper.class);
        this.items.childNodes = (NodeList)Mockito.mock(NodeList.class);
        ((DataTypeConstraintEnumerationView)Mockito.doReturn((Object)helper).when((Object)this.view)).getDragAndDropHelper();
        this.view.addItem(enumerationItem);
        ((HTMLDivElement)Mockito.verify((Object)this.items)).appendChild((Node)enumerationItem);
        ((DragAndDropHelper)Mockito.verify((Object)helper)).refreshItemsPosition();
        ((Element)Mockito.verify((Object)enumerationItem)).setAttribute("data-position", 0.0);
    }
}

