/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.enumeration;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.CSSStyleDeclaration;
import elemental2.dom.Element;
import elemental2.dom.Event;
import elemental2.dom.HTMLElement;
import elemental2.dom.MouseEvent;
import elemental2.dom.NodeList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.enumeration.DragAndDropHelper;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DragAndDropHelperTest {
    @Mock
    private HTMLElement dragArea;
    @Mock
    private HTMLElement addButtonContainer;
    @Mock
    private CSSStyleDeclaration addButtonContainerStyle;
    private DragAndDropHelper helper;

    @Before
    public void setup() {
        this.helper = (DragAndDropHelper)Mockito.spy((Object)new DragAndDropHelper(this.dragArea, this.addButtonContainer));
        this.addButtonContainer.style = this.addButtonContainerStyle;
    }

    @Test
    public void testRefreshItemsPosition() {
        HTMLElement element1 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element2 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element3 = (HTMLElement)Mockito.mock(HTMLElement.class);
        CSSStyleDeclaration element1Style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        CSSStyleDeclaration element2Style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        CSSStyleDeclaration element3Style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        element1.style = element1Style;
        element2.style = element2Style;
        element3.style = element3Style;
        element1.offsetHeight = 50.0;
        NodeList draggableItems = (NodeList)Mockito.spy((Object)new NodeList());
        ((NodeList)Mockito.doReturn((Object)element1).when((Object)draggableItems)).getAt(0);
        ((NodeList)Mockito.doReturn((Object)element2).when((Object)draggableItems)).getAt(1);
        ((NodeList)Mockito.doReturn((Object)element3).when((Object)draggableItems)).getAt(2);
        Mockito.when((Object)element1.getAttribute("data-position")).thenReturn((Object)"0");
        Mockito.when((Object)element2.getAttribute("data-position")).thenReturn((Object)"1");
        Mockito.when((Object)element3.getAttribute("data-position")).thenReturn((Object)"2");
        draggableItems.length = 3.0;
        Mockito.when((Object)this.dragArea.querySelectorAll(".draggable")).thenReturn((Object)draggableItems);
        this.helper.refreshItemsPosition();
        ((CSSStyleDeclaration)Mockito.verify((Object)element1Style)).setProperty("top", "0px");
        ((CSSStyleDeclaration)Mockito.verify((Object)element2Style)).setProperty("top", "50px");
        ((CSSStyleDeclaration)Mockito.verify((Object)element3Style)).setProperty("top", "100px");
        ((CSSStyleDeclaration)Mockito.verify((Object)this.addButtonContainerStyle)).setProperty("top", "150px");
    }

    @Test
    public void testPosition() {
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        boolean expected = true;
        Mockito.when((Object)element.getAttribute("data-position")).thenReturn((Object)String.valueOf(1));
        int actual = this.helper.position((Element)element);
        Assert.assertEquals((long)1L, (long)actual);
    }

    @Test
    public void testFindElementByPosition() {
        boolean position = true;
        this.helper.findElementByPosition(1);
        ((HTMLElement)Mockito.verify((Object)this.dragArea)).querySelector("[data-position=\"1\"]");
    }

    @Test
    public void testSwapElements() {
        Element a = (Element)Mockito.mock(Element.class);
        Element b = (Element)Mockito.mock(Element.class);
        ((DragAndDropHelper)Mockito.doReturn((Object)2).when((Object)this.helper)).position(a);
        ((DragAndDropHelper)Mockito.doReturn((Object)1).when((Object)this.helper)).position(b);
        ((DragAndDropHelper)Mockito.doNothing().when((Object)this.helper)).refreshItemsPosition();
        this.helper.swapElements(a, b);
        ((Element)Mockito.verify((Object)a)).setAttribute("data-position", 1.0);
        ((Element)Mockito.verify((Object)b)).setAttribute("data-position", 2.0);
    }

    @Test
    public void testOnDragAreaMouseDown() {
        int clientY = 123;
        boolean startYPosition = true;
        MouseEvent mouseEvent = (MouseEvent)Mockito.mock(MouseEvent.class);
        Element dragGrabber = (Element)Mockito.mock(Element.class);
        Element target = (Element)Mockito.mock(Element.class);
        HTMLElement draggable = (HTMLElement)Mockito.mock(HTMLElement.class);
        mouseEvent.clientY = 123.0;
        mouseEvent.target = target;
        Mockito.when((Object)target.closest(".drag-grabber")).thenReturn((Object)dragGrabber);
        Mockito.when((Object)dragGrabber.closest(".draggable")).thenReturn((Object)draggable);
        ((DragAndDropHelper)Mockito.doReturn((Object)1).when((Object)this.helper)).getTop(draggable);
        this.helper.onDragAreaMouseDown((Event)mouseEvent);
        Assert.assertEquals((long)1L, (long)this.helper.getStartYPosition());
        Assert.assertEquals((long)123L, (long)this.helper.getClickedYPosition());
        Assert.assertEquals((Object)draggable, (Object)this.helper.getDragging());
    }

    @Test
    public void testOnDragAreaMouseUp() {
        Event event = (Event)Mockito.mock(Event.class);
        ((DragAndDropHelper)Mockito.doNothing().when((Object)this.helper)).refreshItemsPosition();
        this.helper.onDragAreaMouseUp(event);
        Assert.assertEquals(null, (Object)this.helper.getDragging());
        Assert.assertEquals((long)0L, (long)this.helper.getClickedYPosition());
        Assert.assertEquals((long)0L, (long)this.helper.getStartYPosition());
        ((DragAndDropHelper)Mockito.verify((Object)this.helper)).refreshItemsPosition();
    }

    @Test
    public void testGetTop() {
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        CSSStyleDeclaration style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        int expected = 123;
        element.style = style;
        Mockito.when((Object)style.getPropertyValue("top")).thenReturn((Object)"123px");
        int actual = this.helper.getTop(element);
        Assert.assertEquals((long)123L, (long)actual);
    }

    @Test
    public void testSetTop() {
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        CSSStyleDeclaration style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        int expected = 123;
        element.style = style;
        this.helper.setTop(element, 123);
        ((CSSStyleDeclaration)Mockito.verify((Object)style)).setProperty("top", "123px");
    }

    @Test
    public void testOnDragAreaMouseMove() {
        HTMLElement dragging = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement oldElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        MouseEvent event = (MouseEvent)Mockito.mock(MouseEvent.class);
        int newPosition = 2;
        boolean oldPosition = true;
        int delta = 444;
        ((DragAndDropHelper)Mockito.doReturn((Object)dragging).when((Object)this.helper)).getDragging();
        ((DragAndDropHelper)Mockito.doReturn((Object)444).when((Object)this.helper)).getDelta(event);
        ((DragAndDropHelper)Mockito.doReturn((Object)2).when((Object)this.helper)).getNewPosition();
        ((DragAndDropHelper)Mockito.doReturn((Object)1).when((Object)this.helper)).position((Element)dragging);
        ((DragAndDropHelper)Mockito.doReturn((Object)oldElement).when((Object)this.helper)).findElementByPosition(2);
        ((DragAndDropHelper)Mockito.doNothing().when((Object)this.helper)).swapElements((Element)oldElement, (Element)dragging);
        ((DragAndDropHelper)Mockito.doNothing().when((Object)this.helper)).setTop(dragging, 444);
        this.helper.onDragAreaMouseMove((Event)event);
        ((DragAndDropHelper)Mockito.verify((Object)this.helper)).swapElements((Element)oldElement, (Element)dragging);
        ((DragAndDropHelper)Mockito.verify((Object)this.helper)).setTop(dragging, 444);
    }

    @Test
    public void testGetNewPositionFirstPosition() {
        boolean expected = true;
        HTMLElement dragging = (HTMLElement)Mockito.mock(HTMLElement.class);
        dragging.offsetHeight = 40.0;
        ((DragAndDropHelper)Mockito.doReturn((Object)dragging).when((Object)this.helper)).getDragging();
        ((DragAndDropHelper)Mockito.doReturn((Object)59).when((Object)this.helper)).getTop(dragging);
        int actual = this.helper.getNewPosition();
        Assert.assertEquals((long)1L, (long)actual);
    }

    @Test
    public void testGetNewPositionSecondPosition() {
        int expected = 2;
        HTMLElement dragging = (HTMLElement)Mockito.mock(HTMLElement.class);
        dragging.offsetHeight = 40.0;
        ((DragAndDropHelper)Mockito.doReturn((Object)dragging).when((Object)this.helper)).getDragging();
        ((DragAndDropHelper)Mockito.doReturn((Object)60).when((Object)this.helper)).getTop(dragging);
        int actual = this.helper.getNewPosition();
        Assert.assertEquals((long)2L, (long)actual);
    }

    @Test
    public void testGetDelta() {
        int clickedYPosition = 20;
        int mousePosition = 10;
        int expected = -10;
        MouseEvent mouseEvent = (MouseEvent)Mockito.mock(MouseEvent.class);
        mouseEvent.clientY = 10.0;
        ((DragAndDropHelper)Mockito.doReturn((Object)20).when((Object)this.helper)).getClickedYPosition();
        int actual = this.helper.getDelta(mouseEvent);
        Assert.assertEquals((long)-10L, (long)actual);
    }
}

