/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.range;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.Element;
import elemental2.dom.Event;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLInputElement;
import elemental2.dom.Node;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.DataTypeConstraintModal;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.TypedValueComponentSelector;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.TypedValueSelector;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.range.DataTypeConstraintRange;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.range.DataTypeConstraintRangeView;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypeConstraintRangeViewTest {
    @Mock
    private DataTypeConstraintModal modal;
    @Mock
    private Event event;
    @Mock
    private HTMLDivElement startValueContainer;
    @Mock
    private HTMLDivElement endValueContainer;
    @Mock
    private HTMLInputElement includeStartValue;
    @Mock
    private HTMLInputElement includeEndValue;
    @Mock
    private DataTypeConstraintRange presenter;
    @Mock
    private TypedValueComponentSelector startValueComponentSelector;
    @Mock
    private TypedValueComponentSelector endValueComponentSelector;
    @Mock
    private TypedValueSelector startValueComponent;
    @Mock
    private TypedValueSelector endValueComponent;
    @Mock
    private Element startValueElement;
    @Mock
    private Element endValueElement;
    private DataTypeConstraintRangeView view;

    @Before
    public void setup() {
        this.view = (DataTypeConstraintRangeView)Mockito.spy((Object)new DataTypeConstraintRangeView(this.startValueContainer, this.endValueContainer, this.includeStartValue, this.includeEndValue, this.startValueComponentSelector, this.endValueComponentSelector));
        Mockito.when((Object)this.startValueComponentSelector.makeSelectorForType((String)Matchers.any())).thenReturn((Object)this.startValueComponent);
        Mockito.when((Object)this.endValueComponentSelector.makeSelectorForType((String)Matchers.any())).thenReturn((Object)this.endValueComponent);
        Mockito.when((Object)this.startValueComponent.getElement()).thenReturn((Object)this.startValueElement);
        Mockito.when((Object)this.endValueComponent.getElement()).thenReturn((Object)this.endValueElement);
        this.view.init(this.presenter);
        this.view.setComponentSelector("someType");
        this.presenter.setModal(this.modal);
    }

    @Test
    public void testInit() {
        ((DataTypeConstraintRangeView)Mockito.verify((Object)this.view)).setupInputFields();
    }

    @Test
    public void testGetStartValue() {
        String expected = "someString";
        Mockito.when((Object)this.startValueComponent.getValue()).thenReturn((Object)"someString");
        String actual = this.view.getStartValue();
        Assert.assertEquals((Object)"someString", (Object)actual);
    }

    @Test
    public void testGetEndValue() {
        String expected = "someString";
        Mockito.when((Object)this.endValueComponent.getValue()).thenReturn((Object)"someString");
        String actual = this.view.getEndValue();
        Assert.assertEquals((Object)"someString", (Object)actual);
    }

    @Test
    public void testSetStartValue() {
        String expected = "someString";
        this.view.setStartValue("someString");
        ((TypedValueSelector)Mockito.verify((Object)this.startValueComponent)).setValue("someString");
    }

    @Test
    public void testSetEndValue() {
        String expected = "someString";
        this.view.setEndValue("someString");
        ((TypedValueSelector)Mockito.verify((Object)this.endValueComponent)).setValue("someString");
    }

    @Test
    public void testGetIncludeStartValue() {
        boolean expected = true;
        this.includeStartValue.checked = true;
        boolean actual = this.view.getIncludeStartValue();
        Assert.assertEquals((Object)true, (Object)actual);
    }

    @Test
    public void testSetIncludeStartValue() {
        boolean expected = true;
        this.view.setIncludeStartValue(true);
        boolean actual = this.includeStartValue.checked;
        Assert.assertEquals((Object)true, (Object)actual);
    }

    @Test
    public void testGetIncludeEndValue() {
        boolean expected = true;
        this.includeEndValue.checked = true;
        boolean actual = this.view.getIncludeEndValue();
        Assert.assertEquals((Object)true, (Object)actual);
    }

    @Test
    public void testSetIncludeEndValue() {
        boolean expected = true;
        this.view.setIncludeEndValue(true);
        boolean actual = this.includeEndValue.checked;
        Assert.assertEquals((Object)true, (Object)actual);
    }

    @Test
    public void testOnKeyUpEmptyValues() {
        Mockito.when((Object)this.startValueComponent.getValue()).thenReturn((Object)"");
        Mockito.when((Object)this.endValueComponent.getValue()).thenReturn((Object)"");
        this.view.onValueChanged((Object)this.event);
        ((DataTypeConstraintRange)Mockito.verify((Object)this.presenter)).disableOkButton();
        ((DataTypeConstraintRange)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).enableOkButton();
    }

    @Test
    public void testOnKeyUpNonEmptyValues() {
        Mockito.when((Object)this.startValueComponent.getValue()).thenReturn((Object)"1");
        Mockito.when((Object)this.endValueComponent.getValue()).thenReturn((Object)"2");
        this.view.onValueChanged((Object)this.event);
        ((DataTypeConstraintRange)Mockito.verify((Object)this.presenter)).enableOkButton();
        ((DataTypeConstraintRange)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).disableOkButton();
    }

    @Test
    public void testOnKeyUpNonEmptyStartValue() {
        Mockito.when((Object)this.startValueComponent.getValue()).thenReturn((Object)"123456");
        Mockito.when((Object)this.endValueComponent.getValue()).thenReturn((Object)"");
        this.view.onValueChanged((Object)this.event);
        ((DataTypeConstraintRange)Mockito.verify((Object)this.presenter)).disableOkButton();
        ((DataTypeConstraintRange)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).enableOkButton();
    }

    @Test
    public void testOnKeyUpNonEmptyEndValue() {
        Mockito.when((Object)this.startValueComponent.getValue()).thenReturn((Object)"");
        Mockito.when((Object)this.endValueComponent.getValue()).thenReturn((Object)"123456");
        this.view.onValueChanged((Object)this.event);
        ((DataTypeConstraintRange)Mockito.verify((Object)this.presenter)).disableOkButton();
        ((DataTypeConstraintRange)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).enableOkButton();
    }

    @Test
    public void testSetPlaceholders() {
        String value = "value";
        this.view.setPlaceholders("value");
        ((TypedValueSelector)Mockito.verify((Object)this.startValueComponent)).setPlaceholder("value");
        ((TypedValueSelector)Mockito.verify((Object)this.endValueComponent)).setPlaceholder("value");
    }

    @Test
    public void testSetComponentSelector() {
        String type = "type";
        this.view.setComponentSelector("type");
        ((TypedValueComponentSelector)Mockito.verify((Object)this.startValueComponentSelector)).makeSelectorForType("type");
        ((HTMLDivElement)Mockito.verify((Object)this.startValueContainer, (VerificationMode)Mockito.times((int)2))).appendChild((Node)this.startValueElement);
        ((TypedValueComponentSelector)Mockito.verify((Object)this.endValueComponentSelector)).makeSelectorForType("type");
        ((HTMLDivElement)Mockito.verify((Object)this.endValueContainer, (VerificationMode)Mockito.times((int)2))).appendChild((Node)this.endValueElement);
        ((DataTypeConstraintRangeView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setupInputFields();
    }
}

