/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.persistence;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.persistence.CreationType;
import org.kie.workbench.common.dmn.client.editors.types.persistence.ItemDefinitionRecordEngine;
import org.kie.workbench.common.dmn.client.editors.types.persistence.ItemDefinitionStore;
import org.kie.workbench.common.dmn.client.editors.types.persistence.handlers.DataTypeCreateHandler;
import org.kie.workbench.common.dmn.client.editors.types.persistence.handlers.DataTypeDestroyHandler;
import org.kie.workbench.common.dmn.client.editors.types.persistence.handlers.DataTypeUpdateHandler;
import org.kie.workbench.common.dmn.client.editors.types.persistence.handlers.ItemDefinitionCreateHandler;
import org.kie.workbench.common.dmn.client.editors.types.persistence.handlers.ItemDefinitionDestroyHandler;
import org.kie.workbench.common.dmn.client.editors.types.persistence.handlers.ItemDefinitionUpdateHandler;
import org.kie.workbench.common.dmn.client.editors.types.persistence.validation.DataTypeNameValidator;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class ItemDefinitionRecordEngineTest {
    @Mock
    private ItemDefinitionStore itemDefinitionStore;
    @Mock
    private ItemDefinitionDestroyHandler itemDefinitionDestroyHandler;
    @Mock
    private ItemDefinitionUpdateHandler itemDefinitionUpdateHandler;
    @Mock
    private ItemDefinitionCreateHandler itemDefinitionCreateHandler;
    @Mock
    private DataTypeDestroyHandler dataTypeDestroyHandler;
    @Mock
    private DataTypeUpdateHandler dataTypeUpdateHandler;
    @Mock
    private DataTypeCreateHandler dataTypeCreateHandler;
    @Mock
    private DataTypeNameValidator dataTypeNameValidator;
    private ItemDefinitionRecordEngine recordEngine;

    @Before
    public void setup() {
        this.recordEngine = (ItemDefinitionRecordEngine)Mockito.spy((Object)new ItemDefinitionRecordEngine(this.itemDefinitionStore, this.itemDefinitionDestroyHandler, this.itemDefinitionUpdateHandler, this.itemDefinitionCreateHandler, this.dataTypeDestroyHandler, this.dataTypeUpdateHandler, this.dataTypeCreateHandler, this.dataTypeNameValidator));
    }

    @Test
    public void testInit() {
        this.recordEngine.init();
        ((DataTypeDestroyHandler)Mockito.verify((Object)this.dataTypeDestroyHandler)).init(this.recordEngine);
        ((DataTypeUpdateHandler)Mockito.verify((Object)this.dataTypeUpdateHandler)).init(this.recordEngine);
    }

    @Test
    public void testUpdate() {
        String uuid = "uuid";
        String nameValue = "nameValue";
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        Name name = (Name)Mockito.mock(Name.class);
        List<DataType> expectedDependentDataTypes = Arrays.asList((DataType)Mockito.mock(DataType.class), (DataType)Mockito.mock(DataType.class));
        Mockito.when((Object)dataType.isValid()).thenReturn((Object)true);
        Mockito.when((Object)dataType.getUUID()).thenReturn((Object)"uuid");
        Mockito.when((Object)this.itemDefinitionStore.get("uuid")).thenReturn((Object)itemDefinition);
        Mockito.when((Object)itemDefinition.getName()).thenReturn((Object)name);
        Mockito.when((Object)name.getValue()).thenReturn((Object)"nameValue");
        Mockito.when((Object)this.dataTypeUpdateHandler.refreshDependentDataTypes(dataType, "nameValue")).thenReturn(expectedDependentDataTypes);
        List actualDependentDataTypes = this.recordEngine.update(dataType);
        ((ItemDefinitionRecordEngine)Mockito.verify((Object)this.recordEngine)).doUpdate(dataType, itemDefinition);
        Assert.assertEquals(expectedDependentDataTypes, (Object)actualDependentDataTypes);
    }

    @Test
    public void testUpdateWhenDataTypeIsNotValid() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        Mockito.when((Object)dataType.isValid()).thenReturn((Object)false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.recordEngine.update(dataType)).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("An invalid Data Type cannot be updated.");
    }

    @Test
    public void testDoUpdate() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        this.recordEngine.doUpdate(dataType, itemDefinition);
        ((DataTypeUpdateHandler)Mockito.verify((Object)this.dataTypeUpdateHandler)).update(dataType);
        ((ItemDefinitionUpdateHandler)Mockito.verify((Object)this.itemDefinitionUpdateHandler)).update(dataType, itemDefinition);
    }

    @Test
    public void testDestroy() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        List<DataType> expectedDependentDataTypes = Arrays.asList((DataType)Mockito.mock(DataType.class), (DataType)Mockito.mock(DataType.class));
        Mockito.when((Object)this.dataTypeDestroyHandler.refreshDependentDataTypes(dataType)).thenReturn(expectedDependentDataTypes);
        List actualDependentDataTypes = this.recordEngine.destroy(dataType);
        ((ItemDefinitionRecordEngine)Mockito.verify((Object)this.recordEngine)).doDestroy(dataType);
        Assert.assertEquals(expectedDependentDataTypes, (Object)actualDependentDataTypes);
    }

    @Test
    public void testCreate() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        List<DataType> expectedAffectedDataTypes = Arrays.asList((DataType)Mockito.mock(DataType.class), (DataType)Mockito.mock(DataType.class));
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        Mockito.when((Object)this.itemDefinitionCreateHandler.appendItemDefinition()).thenReturn((Object)itemDefinition);
        Mockito.when((Object)this.dataTypeCreateHandler.append(dataType, itemDefinition)).thenReturn(expectedAffectedDataTypes);
        List actualAffectedDataTypes = this.recordEngine.create(dataType);
        Assert.assertEquals(expectedAffectedDataTypes, (Object)actualAffectedDataTypes);
    }

    @Test
    public void testCreateWithCreationTypeNotNested() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        DataType reference = (DataType)Mockito.mock(DataType.class);
        List<DataType> expectedAffectedDataTypes = Arrays.asList((DataType)Mockito.mock(DataType.class), (DataType)Mockito.mock(DataType.class));
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        CreationType creationType = CreationType.ABOVE;
        Mockito.when((Object)this.itemDefinitionCreateHandler.insertItemDefinition(reference, creationType)).thenReturn((Object)itemDefinition);
        Mockito.when((Object)this.dataTypeCreateHandler.insert(dataType, reference, creationType, itemDefinition)).thenReturn(expectedAffectedDataTypes);
        List actualAffectedDataTypes = this.recordEngine.create(dataType, reference, creationType);
        Assert.assertEquals(expectedAffectedDataTypes, (Object)actualAffectedDataTypes);
    }

    @Test
    public void testCreateWithCreationTypeNested() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        DataType reference = (DataType)Mockito.mock(DataType.class);
        List<DataType> expectedAffectedDataTypes = Arrays.asList((DataType)Mockito.mock(DataType.class), (DataType)Mockito.mock(DataType.class));
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        Mockito.when((Object)this.itemDefinitionCreateHandler.insertNestedItemDefinition(reference)).thenReturn((Object)itemDefinition);
        Mockito.when((Object)this.dataTypeCreateHandler.insertNested(dataType, reference, itemDefinition)).thenReturn(expectedAffectedDataTypes);
        List actualAffectedDataTypes = this.recordEngine.create(dataType, reference, CreationType.NESTED);
        Assert.assertEquals(expectedAffectedDataTypes, (Object)actualAffectedDataTypes);
    }

    @Test
    public void testIsValidWhenItIsTrue() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        ((DataTypeNameValidator)Mockito.doReturn((Object)true).when((Object)this.dataTypeNameValidator)).isValid(dataType);
        Assert.assertTrue((boolean)this.recordEngine.isValid(dataType));
    }

    @Test
    public void testIsValidWhenItIsFalse() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        ((DataTypeNameValidator)Mockito.doReturn((Object)false).when((Object)this.dataTypeNameValidator)).isValid(dataType);
        Assert.assertFalse((boolean)this.recordEngine.isValid(dataType));
    }

    @Test
    public void testDoDestroy() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        this.recordEngine.doDestroy(dataType);
        ((DataTypeDestroyHandler)Mockito.verify((Object)this.dataTypeDestroyHandler)).destroy(dataType);
        ((ItemDefinitionDestroyHandler)Mockito.verify((Object)this.itemDefinitionDestroyHandler)).destroy(dataType);
    }
}

