/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.persistence.handlers;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.v1_1.Definitions;
import org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.persistence.ItemDefinitionStore;
import org.kie.workbench.common.dmn.client.editors.types.persistence.handlers.ItemDefinitionDestroyHandler;
import org.kie.workbench.common.dmn.client.editors.types.persistence.handlers.common.PropertiesPanelNotifier;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class ItemDefinitionDestroyHandlerTest {
    @Mock
    private ItemDefinitionStore itemDefinitionStore;
    @Mock
    private DMNGraphUtils dmnGraphUtils;
    @Mock
    private PropertiesPanelNotifier panelNotifier;
    private ItemDefinitionDestroyHandler handler;

    @Before
    public void setup() {
        this.handler = (ItemDefinitionDestroyHandler)Mockito.spy((Object)new ItemDefinitionDestroyHandler(this.itemDefinitionStore, this.dmnGraphUtils, this.panelNotifier));
    }

    @Test
    public void testDestroy() {
        String uuid = "uuid";
        String oldItemDefinitionName = "oldItemDefinitionName";
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        Name name = (Name)Mockito.mock(Name.class);
        final ItemDefinition itemDefinition = this.makeItemDefinition(new ItemDefinition[0]);
        ItemDefinition itemDefinitionParent = this.makeItemDefinition(itemDefinition);
        ArrayList<ItemDefinition> itemDefinitions = new ArrayList<ItemDefinition>(){
            {
                this.add(itemDefinition);
            }
        };
        Mockito.when((Object)name.getValue()).thenReturn((Object)"oldItemDefinitionName");
        Mockito.when((Object)this.itemDefinitionStore.get("uuid")).thenReturn((Object)itemDefinition);
        Mockito.when((Object)dataType.getUUID()).thenReturn((Object)"uuid");
        ((ItemDefinitionDestroyHandler)Mockito.doReturn(Optional.of(itemDefinitionParent)).when((Object)this.handler)).findItemDefinitionParent(dataType);
        ((ItemDefinition)Mockito.doReturn((Object)name).when((Object)itemDefinition)).getName();
        ((ItemDefinitionDestroyHandler)Mockito.doReturn((Object)itemDefinitions).when((Object)this.handler)).itemDefinitions();
        ((ItemDefinitionDestroyHandler)Mockito.doNothing().when((Object)this.handler)).notifyPropertiesPanel(Matchers.anyString());
        this.handler.destroy(dataType);
        Assert.assertEquals(Collections.emptyList(), (Object)itemDefinitionParent.getItemComponent());
        Assert.assertEquals(Collections.emptyList(), (Object)itemDefinitions);
        ((ItemDefinitionDestroyHandler)Mockito.verify((Object)this.handler)).notifyPropertiesPanel("oldItemDefinitionName");
    }

    @Test
    public void testNotifyPropertiesPanel() {
        String destroyedItemDefinition = "destroyedItemDefinition";
        Mockito.when((Object)this.panelNotifier.withOldLocalPart("destroyedItemDefinition")).thenReturn((Object)this.panelNotifier);
        Mockito.when((Object)this.panelNotifier.withNewQName((QName)Matchers.eq((Object)new QName()))).thenReturn((Object)this.panelNotifier);
        this.handler.notifyPropertiesPanel("destroyedItemDefinition");
        ((PropertiesPanelNotifier)Mockito.verify((Object)this.panelNotifier)).notifyPanel();
    }

    @Test
    public void testFindItemDefinitionParentWhenParentDoesNotExist() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        String parentUUID = "parentUUID";
        Mockito.when((Object)dataType.getParentUUID()).thenReturn((Object)"parentUUID");
        Mockito.when((Object)this.itemDefinitionStore.get("parentUUID")).thenReturn(null);
        Optional expectedParent = Optional.empty();
        Optional actualParent = this.handler.findItemDefinitionParent(dataType);
        Assert.assertEquals(expectedParent, (Object)actualParent);
    }

    @Test
    public void testFindItemDefinitionParentWhenParentDoesNotHaveTypeRef() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        ItemDefinition parent = this.makeItemDefinition(new ItemDefinition[0]);
        String parentUUID = "parentUUID";
        Mockito.when((Object)parent.getTypeRef()).thenReturn(null);
        Mockito.when((Object)dataType.getParentUUID()).thenReturn((Object)"parentUUID");
        Mockito.when((Object)this.itemDefinitionStore.get("parentUUID")).thenReturn((Object)parent);
        Optional<ItemDefinition> expectedParent = Optional.of(parent);
        Optional actualParent = this.handler.findItemDefinitionParent(dataType);
        Assert.assertEquals(expectedParent, (Object)actualParent);
    }

    @Test
    public void testFindItemDefinitionParentWhenItCouldNotBeFound() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        ItemDefinition parent = this.makeItemDefinition(new ItemDefinition[0]);
        String parentUUID = "parentUUID";
        String type = "type";
        String nameValue = "name";
        QName parentQName = (QName)Mockito.mock(QName.class);
        ItemDefinition itemDefinition = this.makeItemDefinition(new ItemDefinition[0]);
        Name name = (Name)Mockito.mock(Name.class);
        List<ItemDefinition> itemDefinitions = Collections.singletonList(itemDefinition);
        Mockito.when((Object)name.getValue()).thenReturn((Object)"name");
        Mockito.when((Object)itemDefinition.getName()).thenReturn((Object)name);
        Mockito.when((Object)parentQName.getLocalPart()).thenReturn((Object)"type");
        Mockito.when((Object)parent.getTypeRef()).thenReturn((Object)parentQName);
        Mockito.when((Object)dataType.getParentUUID()).thenReturn((Object)"parentUUID");
        Mockito.when((Object)this.itemDefinitionStore.get("parentUUID")).thenReturn((Object)parent);
        ((ItemDefinitionDestroyHandler)Mockito.doReturn(itemDefinitions).when((Object)this.handler)).itemDefinitions();
        Optional expectedParent = Optional.empty();
        Optional actualParent = this.handler.findItemDefinitionParent(dataType);
        Assert.assertEquals(expectedParent, (Object)actualParent);
    }

    @Test
    public void testFindItemDefinitionParentWhenItCouldBeFound() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        ItemDefinition parent = this.makeItemDefinition(new ItemDefinition[0]);
        String parentUUID = "parentUUID";
        String type = "type";
        QName parentQName = (QName)Mockito.mock(QName.class);
        ItemDefinition itemDefinition = this.makeItemDefinition(new ItemDefinition[0]);
        Name name = (Name)Mockito.mock(Name.class);
        List<ItemDefinition> itemDefinitions = Collections.singletonList(itemDefinition);
        Mockito.when((Object)name.getValue()).thenReturn((Object)"type");
        Mockito.when((Object)itemDefinition.getName()).thenReturn((Object)name);
        Mockito.when((Object)parentQName.getLocalPart()).thenReturn((Object)"type");
        Mockito.when((Object)parent.getTypeRef()).thenReturn((Object)parentQName);
        Mockito.when((Object)dataType.getParentUUID()).thenReturn((Object)"parentUUID");
        Mockito.when((Object)this.itemDefinitionStore.get("parentUUID")).thenReturn((Object)parent);
        ((ItemDefinitionDestroyHandler)Mockito.doReturn(itemDefinitions).when((Object)this.handler)).itemDefinitions();
        Optional<ItemDefinition> expectedParent = Optional.of(itemDefinition);
        Optional actualParent = this.handler.findItemDefinitionParent(dataType);
        Assert.assertEquals(expectedParent, (Object)actualParent);
    }

    @Test
    public void testItemDefinitions() {
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        ItemDefinition itemDefinition = this.makeItemDefinition(new ItemDefinition[0]);
        List<ItemDefinition> expectedItemDefinitions = Collections.singletonList(itemDefinition);
        Mockito.when((Object)this.dmnGraphUtils.getDefinitions()).thenReturn((Object)definitions);
        Mockito.when((Object)definitions.getItemDefinition()).thenReturn(expectedItemDefinitions);
        List actualItemDefinitions = this.handler.itemDefinitions();
        Assert.assertEquals(expectedItemDefinitions, (Object)actualItemDefinitions);
    }

    @Test
    public void testItemDefinitionsWhenDefinitionsIsNull() {
        List expectedItemDefinitions = Collections.emptyList();
        Mockito.when((Object)this.dmnGraphUtils.getDefinitions()).thenReturn(null);
        List actualItemDefinitions = this.handler.itemDefinitions();
        Assert.assertEquals(expectedItemDefinitions, (Object)actualItemDefinitions);
    }

    private ItemDefinition makeItemDefinition(ItemDefinition ... itemDefinitions) {
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.spy((Object)new ItemDefinition());
        itemDefinition.getItemComponent().addAll(Arrays.asList(itemDefinitions));
        return itemDefinition;
    }
}

