/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.persistence.handlers.common;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasTypeRef;
import org.kie.workbench.common.dmn.api.definition.HasVariable;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.api.definition.v1_1.IsInformationItem;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.editors.types.persistence.handlers.common.PropertiesPanelNotifier;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasSelectionEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.domainobject.DomainObject;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewImpl;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class PropertiesPanelNotifierTest {
    @Mock
    private EventSourceMock<RefreshFormPropertiesEvent> refreshFormPropertiesEvent;
    @Mock
    private SessionManager sessionManager;
    @Captor
    private ArgumentCaptor<RefreshFormPropertiesEvent> propertiesEventArgumentCaptor;
    private PropertiesPanelNotifier notifier;

    @Before
    public void setup() {
        this.notifier = (PropertiesPanelNotifier)Mockito.spy((Object)new PropertiesPanelNotifier(this.refreshFormPropertiesEvent, this.sessionManager));
    }

    @Test
    public void testNotifyPanel() {
        Node node1 = (Node)Mockito.mock(Node.class);
        Node node2 = (Node)Mockito.mock(Node.class);
        Object definition1 = Mockito.mock(Object.class);
        Object definition2 = Mockito.mock(Object.class);
        ((PropertiesPanelNotifier)Mockito.doReturn(Arrays.asList(node1, node2)).when((Object)this.notifier)).getNodes();
        ((PropertiesPanelNotifier)Mockito.doReturn((Object)definition1).when((Object)this.notifier)).getDefinition(node1);
        ((PropertiesPanelNotifier)Mockito.doReturn((Object)definition2).when((Object)this.notifier)).getDefinition(node2);
        this.notifier.notifyPanel();
        ((PropertiesPanelNotifier)Mockito.verify((Object)this.notifier)).notifyVariables(node1, definition1);
        ((PropertiesPanelNotifier)Mockito.verify((Object)this.notifier)).notifyExpressions(node2, definition2);
    }

    @Test
    public void testOnCanvasSelectionEvent() {
        CanvasSelectionEvent selectionEvent = (CanvasSelectionEvent)Mockito.mock(CanvasSelectionEvent.class);
        String uuid1 = "uuid1";
        String uuid2 = "uuid2";
        List<String> t = Arrays.asList("uuid1", "uuid2");
        Mockito.when((Object)selectionEvent.getIdentifiers()).thenReturn(t);
        this.notifier.onCanvasSelectionEvent(selectionEvent);
        ((PropertiesPanelNotifier)Mockito.verify((Object)this.notifier)).setSelectedElementUUID("uuid1");
    }

    @Test
    public void testOnDomainObjectSelectionEvent() {
        DomainObjectSelectionEvent selectionEvent = (DomainObjectSelectionEvent)Mockito.mock(DomainObjectSelectionEvent.class);
        DomainObject domainObject = (DomainObject)Mockito.mock(DomainObject.class);
        String uuid = "uuid";
        Mockito.when((Object)selectionEvent.getDomainObject()).thenReturn((Object)domainObject);
        Mockito.when((Object)domainObject.getDomainObjectUUID()).thenReturn((Object)"uuid");
        this.notifier.onDomainObjectSelectionEvent(selectionEvent);
        ((PropertiesPanelNotifier)Mockito.verify((Object)this.notifier)).setSelectedElementUUID("uuid");
    }

    @Test
    public void testNotifyExpressions() {
        Node node = (Node)Mockito.mock(Node.class);
        HasExpression hasExpression = (HasExpression)Mockito.mock(HasExpression.class);
        Expression expression = (Expression)Mockito.mock(Expression.class);
        HasTypeRef hasTypeRef1 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef2 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        Mockito.when((Object)expression.getHasTypeRefs()).thenReturn(Arrays.asList(hasTypeRef1, hasTypeRef2));
        Mockito.when((Object)hasExpression.getExpression()).thenReturn((Object)expression);
        ((PropertiesPanelNotifier)Mockito.doNothing().when((Object)this.notifier)).notifyOutdatedElement((Node)Matchers.any(), (HasTypeRef)Matchers.any());
        this.notifier.notifyExpressions(node, (Object)hasExpression);
        ((PropertiesPanelNotifier)Mockito.verify((Object)this.notifier)).notifyOutdatedElement(node, hasTypeRef1);
        ((PropertiesPanelNotifier)Mockito.verify((Object)this.notifier)).notifyOutdatedElement(node, hasTypeRef2);
    }

    @Test
    public void testNotifyExpressionsWhenDefinitionIsDoesNotHaveExpression() {
        Node node = (Node)Mockito.mock(Node.class);
        Object definition = Mockito.mock(Object.class);
        this.notifier.notifyExpressions(node, definition);
        ((PropertiesPanelNotifier)Mockito.verify((Object)this.notifier, (VerificationMode)Mockito.never())).notifyOutdatedElement((Node)Matchers.any(), (HasTypeRef)Matchers.any());
    }

    @Test
    public void testNotifyVariables() {
        Node node = (Node)Mockito.mock(Node.class);
        HasVariable hasVariable = (HasVariable)Mockito.mock(HasVariable.class);
        IsInformationItem informationItem = (IsInformationItem)Mockito.mock(IsInformationItem.class);
        Mockito.when((Object)hasVariable.getVariable()).thenReturn((Object)informationItem);
        ((PropertiesPanelNotifier)Mockito.doNothing().when((Object)this.notifier)).notifyOutdatedElement((Node)Matchers.any(), (HasTypeRef)Matchers.any());
        this.notifier.notifyVariables(node, (Object)hasVariable);
        ((PropertiesPanelNotifier)Mockito.verify((Object)this.notifier)).notifyOutdatedElement(node, (HasTypeRef)informationItem);
    }

    @Test
    public void testNotifyVariablesWhenDefinitionIsDoesNotHaveVariables() {
        Node node = (Node)Mockito.mock(Node.class);
        Object definition = Mockito.mock(Object.class);
        this.notifier.notifyVariables(node, definition);
        ((PropertiesPanelNotifier)Mockito.verify((Object)this.notifier, (VerificationMode)Mockito.never())).notifyOutdatedElement((Node)Matchers.any(), (HasTypeRef)Matchers.any());
    }

    @Test
    public void testNotifyOutdatedNodeWhenNodeIsOutdated() {
        Node node = (Node)Mockito.mock(Node.class);
        HasTypeRef elementTypeRef = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        QName newQName = (QName)Mockito.mock(QName.class);
        QName typeRef = (QName)Mockito.mock(QName.class);
        String oldLocalPart = "tPerson";
        String elementLocalPart = "tPerson";
        Mockito.when((Object)elementTypeRef.getTypeRef()).thenReturn((Object)typeRef);
        Mockito.when((Object)typeRef.getLocalPart()).thenReturn((Object)"tPerson");
        ((PropertiesPanelNotifier)Mockito.doNothing().when((Object)this.notifier)).refreshFormProperties((Node)Matchers.any());
        this.notifier.withOldLocalPart("tPerson").withNewQName(newQName).notifyOutdatedElement(node, elementTypeRef);
        ((HasTypeRef)Mockito.verify((Object)elementTypeRef)).setTypeRef(newQName);
        ((PropertiesPanelNotifier)Mockito.verify((Object)this.notifier)).refreshFormProperties(node);
    }

    @Test
    public void testNotifyOutdatedNodeWhenNodeIsNotOutdated() {
        Node node = (Node)Mockito.mock(Node.class);
        HasTypeRef elementTypeRef = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        QName newQName = (QName)Mockito.mock(QName.class);
        QName typeRef = (QName)Mockito.mock(QName.class);
        String oldLocalPart = "tPerson";
        String elementLocalPart = "";
        Mockito.when((Object)elementTypeRef.getTypeRef()).thenReturn((Object)typeRef);
        Mockito.when((Object)typeRef.getLocalPart()).thenReturn((Object)"");
        this.notifier.withOldLocalPart("tPerson").withNewQName(newQName).notifyOutdatedElement(node, elementTypeRef);
        ((HasTypeRef)Mockito.verify((Object)elementTypeRef, (VerificationMode)Mockito.never())).setTypeRef((QName)Matchers.any());
        ((PropertiesPanelNotifier)Mockito.verify((Object)this.notifier, (VerificationMode)Mockito.never())).refreshFormProperties((Node)Matchers.any());
    }

    @Test
    public void testGetDefinition() {
        Node node = (Node)Mockito.mock(Node.class);
        ViewImpl content = (ViewImpl)Mockito.mock(ViewImpl.class);
        Object expected = Mockito.mock(Object.class);
        Mockito.when((Object)content.getDefinition()).thenReturn(expected);
        Mockito.when((Object)node.getContent()).thenReturn((Object)content);
        Object actual = this.notifier.getDefinition(node);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetNodes() {
        Graph graph = (Graph)Mockito.mock(Graph.class);
        Node node1 = (Node)Mockito.mock(Node.class);
        Node node2 = (Node)Mockito.mock(Node.class);
        List<Node> expectedNodes = Arrays.asList(node1, node2);
        Mockito.when((Object)graph.nodes()).thenReturn(expectedNodes);
        ((PropertiesPanelNotifier)Mockito.doReturn(Optional.of(graph)).when((Object)this.notifier)).getGraph();
        List actualNodes = this.notifier.getNodes();
        Assert.assertEquals(expectedNodes, (Object)actualNodes);
    }

    @Test
    public void testGetGraph() {
        ClientSession clientSession = (ClientSession)Mockito.mock(ClientSession.class);
        CanvasHandler canvasHandler = (CanvasHandler)Mockito.mock(CanvasHandler.class);
        Diagram diagram = (Diagram)Mockito.mock(Diagram.class);
        Optional<Object> expected = Optional.of(Mockito.mock(Graph.class));
        Mockito.when((Object)diagram.getGraph()).thenReturn(expected.get());
        Mockito.when((Object)canvasHandler.getDiagram()).thenReturn((Object)diagram);
        Mockito.when((Object)clientSession.getCanvasHandler()).thenReturn((Object)canvasHandler);
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)clientSession);
        Optional actual = this.notifier.getGraph();
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testRefreshFormPropertiesWhenPropertiesPanelIsUpdated() {
        Node node = (Node)Mockito.mock(Node.class);
        ClientSession clientSession = (ClientSession)Mockito.mock(ClientSession.class);
        String uuid = "uuid";
        Mockito.when((Object)node.getUUID()).thenReturn((Object)"uuid");
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)clientSession);
        Mockito.when((Object)this.notifier.getSelectedElementUUID()).thenReturn(Optional.of("uuid"));
        this.notifier.refreshFormProperties(node);
        ((EventSourceMock)Mockito.verify(this.refreshFormPropertiesEvent)).fire(this.propertiesEventArgumentCaptor.capture());
        RefreshFormPropertiesEvent value = (RefreshFormPropertiesEvent)this.propertiesEventArgumentCaptor.getValue();
        Assert.assertEquals((Object)"uuid", (Object)value.getUuid());
        Assert.assertEquals((Object)clientSession, (Object)value.getSession());
    }

    @Test
    public void testRefreshFormPropertiesWhenPropertiesPanelIsNotUpdated() {
        Node node = (Node)Mockito.mock(Node.class);
        ClientSession clientSession = (ClientSession)Mockito.mock(ClientSession.class);
        Mockito.when((Object)node.getUUID()).thenReturn((Object)"uuid1");
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)clientSession);
        Mockito.when((Object)this.notifier.getSelectedElementUUID()).thenReturn(Optional.of("uuid2"));
        this.notifier.refreshFormProperties(node);
        ((EventSourceMock)Mockito.verify(this.refreshFormPropertiesEvent, (VerificationMode)Mockito.never())).fire(Matchers.any());
    }
}

