/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.search;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.HTMLElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeList;
import org.kie.workbench.common.dmn.client.editors.types.search.DataTypeSearchBar;
import org.kie.workbench.common.dmn.client.editors.types.search.DataTypeSearchEngine;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypeSearchBarTest {
    @Mock
    private DataTypeSearchBar.View view;
    @Mock
    private DataTypeSearchEngine searchEngine;
    @Mock
    private DataTypeList dataTypeList;
    private DataTypeSearchBar searchBar;

    @Before
    public void setup() {
        this.searchBar = (DataTypeSearchBar)Mockito.spy((Object)new DataTypeSearchBar(this.view, this.searchEngine, this.dataTypeList));
    }

    @Test
    public void testSetup() {
        this.searchBar.setup();
        ((DataTypeSearchBar.View)Mockito.verify((Object)this.view)).init((Object)this.searchBar);
    }

    @Test
    public void testGetElement() {
        HTMLElement expectedElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.view.getElement()).thenReturn((Object)expectedElement);
        HTMLElement actualElement = this.searchBar.getElement();
        Assert.assertEquals((Object)expectedElement, (Object)actualElement);
    }

    @Test
    public void testRefresh() {
        String currentSearch = "currentSearch";
        ((DataTypeSearchBar)Mockito.doReturn((Object)"currentSearch").when((Object)this.searchBar)).getCurrentSearch();
        this.searchBar.refresh();
        ((DataTypeSearchBar)Mockito.verify((Object)this.searchBar)).search("currentSearch");
    }

    @Test
    public void testReset() {
        this.searchBar.reset();
        ((DataTypeSearchBar)Mockito.verify((Object)this.searchBar)).setCurrentSearch("");
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).showListItems();
        ((DataTypeSearchBar.View)Mockito.verify((Object)this.view)).resetSearchBar();
    }

    @Test
    public void testSearchWhenKeywordIsNotEmpty() {
        String keyword = "keyword";
        List<DataType> results = Arrays.asList((DataType)Mockito.mock(DataType.class), (DataType)Mockito.mock(DataType.class));
        Mockito.when((Object)this.searchEngine.search("keyword")).thenReturn(results);
        this.searchBar.search("keyword");
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).showListItems();
        ((DataTypeSearchBar)Mockito.verify((Object)this.searchBar)).setCurrentSearch("keyword");
        ((DataTypeSearchBar.View)Mockito.verify((Object)this.view)).showSearchResults(results);
    }

    @Test
    public void testSearchWhenTheSearchResultIsEmpty() {
        String keyword = "keyword";
        List results = Collections.emptyList();
        Mockito.when((Object)this.searchEngine.search("keyword")).thenReturn(results);
        this.searchBar.search("keyword");
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).showNoDataTypesFound();
        ((DataTypeSearchBar)Mockito.verify((Object)this.searchBar)).setCurrentSearch("keyword");
        ((DataTypeSearchBar.View)Mockito.verify((Object)this.view)).showSearchResults(results);
    }

    @Test
    public void testSearchWhenKeywordIsEmpty() {
        String keyword = "";
        Mockito.when((Object)this.searchEngine.search("")).thenReturn(Collections.emptyList());
        this.searchBar.search("");
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).showNoDataTypesFound();
        ((DataTypeSearchBar)Mockito.verify((Object)this.searchBar, (VerificationMode)Mockito.times((int)2))).setCurrentSearch("");
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).showListItems();
        ((DataTypeSearchBar.View)Mockito.verify((Object)this.view)).resetSearchBar();
    }

    @Test
    public void testSearchWhenKeywordIsNull() {
        String keyword = null;
        Mockito.when((Object)this.searchEngine.search(keyword)).thenReturn(Collections.emptyList());
        this.searchBar.search(keyword);
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).showNoDataTypesFound();
        ((DataTypeSearchBar)Mockito.verify((Object)this.searchBar)).setCurrentSearch(keyword);
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).showListItems();
        ((DataTypeSearchBar.View)Mockito.verify((Object)this.view)).resetSearchBar();
    }

    @Test
    public void testIsEnabledWhenItReturnsTrue() {
        ((DataTypeSearchBar)Mockito.doReturn((Object)"something").when((Object)this.searchBar)).getCurrentSearch();
        Assert.assertTrue((boolean)this.searchBar.isEnabled());
    }

    @Test
    public void testIsEnabledWhenItReturnsFalse() {
        ((DataTypeSearchBar)Mockito.doReturn((Object)"").when((Object)this.searchBar)).getCurrentSearch();
        Assert.assertFalse((boolean)this.searchBar.isEnabled());
    }

    @Test
    public void testGetResultsContainer() {
        HTMLElement expectedElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.dataTypeList.getListItemsElement()).thenReturn((Object)expectedElement);
        HTMLElement actualElement = this.searchBar.getResultsContainer();
        Assert.assertEquals((Object)expectedElement, (Object)actualElement);
    }
}

