/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.search;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.DOMTokenList;
import elemental2.dom.DomGlobal;
import elemental2.dom.Element;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLInputElement;
import elemental2.dom.NodeList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.search.DataTypeSearchBar;
import org.kie.workbench.common.dmn.client.editors.types.search.DataTypeSearchBarView;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypeSearchBarViewTest {
    @Mock
    private HTMLInputElement searchBar;
    @Mock
    private HTMLElement searchIcon;
    @Mock
    private HTMLButtonElement closeSearch;
    @Mock
    private DataTypeSearchBar presenter;
    @Mock
    private TranslationService translationService;
    @Captor
    private ArgumentCaptor<DomGlobal.SetTimeoutCallbackFn> callback;
    private DataTypeSearchBarView view;

    @Before
    public void setup() {
        this.view = (DataTypeSearchBarView)Mockito.spy((Object)new DataTypeSearchBarView(this.searchBar, this.searchIcon, this.closeSearch, this.translationService));
        this.view.init(this.presenter);
        this.searchIcon.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.closeSearch.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
    }

    @Test
    public void testSetupSearchBar() {
        String search = "Search...";
        Mockito.when((Object)this.translationService.format("DataTypeSearchBarView.Search", new Object[0])).thenReturn((Object)"Search...");
        this.view.setupSearchBar();
        Assert.assertEquals((Object)this.searchBar.placeholder, (Object)"Search...");
    }

    @Test
    public void testOnSearchBarCloseButton() {
        this.view.onSearchBarCloseButton((ClickEvent)Mockito.mock(ClickEvent.class));
        ((DataTypeSearchBar)Mockito.verify((Object)this.presenter)).reset();
    }

    @Test
    public void testOnSearchBarKeyUpEventWhenKeyPressedIsEscape() {
        KeyUpEvent event = (KeyUpEvent)Mockito.mock(KeyUpEvent.class);
        Mockito.when((Object)event.getNativeKeyCode()).thenReturn((Object)27);
        this.view.onSearchBarKeyUpEvent(event);
        ((DataTypeSearchBar)Mockito.verify((Object)this.presenter)).reset();
    }

    @Test
    public void testOnSearchBarKeyUpEventWhenKeyPressedIsNotEscape() {
        KeyUpEvent event = (KeyUpEvent)Mockito.mock(KeyUpEvent.class);
        Mockito.when((Object)event.getNativeKeyCode()).thenReturn((Object)17);
        ((DataTypeSearchBarView)Mockito.doNothing().when((Object)this.view)).search();
        this.view.onSearchBarKeyUpEvent(event);
        ((DataTypeSearchBarView)Mockito.verify((Object)this.view)).search();
    }

    @Test
    public void testOnSearchBarKeyDownEvent() {
        this.view.onSearchBarKeyDownEvent((KeyDownEvent)Mockito.mock(KeyDownEvent.class));
        ((DataTypeSearchBarView)Mockito.verify((Object)this.view)).refreshSearchBarState();
    }

    @Test
    public void testOnSearchBarChangeEvent() {
        this.view.onSearchBarChangeEvent((ChangeEvent)Mockito.mock(ChangeEvent.class));
        ((DataTypeSearchBarView)Mockito.verify((Object)this.view)).refreshSearchBarState();
    }

    @Test
    public void testShowSearchResults() {
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        DataType dataType2 = (DataType)Mockito.mock(DataType.class);
        DataType dataType3 = (DataType)Mockito.mock(DataType.class);
        Element element1 = (Element)Mockito.mock(Element.class);
        Element element2 = (Element)Mockito.mock(Element.class);
        List<DataType> results = Arrays.asList(dataType1, dataType2);
        ((DataTypeSearchBarView)Mockito.doReturn(Optional.of(element1)).when((Object)this.view)).getResultEntry(dataType1);
        ((DataTypeSearchBarView)Mockito.doReturn(Optional.of(element2)).when((Object)this.view)).getResultEntry(dataType2);
        ((DataTypeSearchBarView)Mockito.doReturn(Optional.empty()).when((Object)this.view)).getResultEntry(dataType3);
        ((DataTypeSearchBarView)Mockito.doNothing().when((Object)this.view)).enableSearch();
        ((DataTypeSearchBarView)Mockito.doNothing().when((Object)this.view)).disableResults();
        element1.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        element2.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.showSearchResults(results);
        ((DataTypeSearchBarView)Mockito.verify((Object)this.view)).enableSearch();
        ((DataTypeSearchBarView)Mockito.verify((Object)this.view)).disableResults();
        ((DOMTokenList)Mockito.verify((Object)element1.classList)).add(new String[]{"kie-search-engine-result"});
        ((DOMTokenList)Mockito.verify((Object)element2.classList)).add(new String[]{"kie-search-engine-result"});
    }

    @Test
    public void testResetSearchBar() {
        this.searchBar.value = "something";
        ((DataTypeSearchBarView)Mockito.doNothing().when((Object)this.view)).disableSearch();
        ((DataTypeSearchBarView)Mockito.doNothing().when((Object)this.view)).disableResults();
        this.view.resetSearchBar();
        Assert.assertEquals((Object)this.searchBar.value, (Object)"");
        ((DataTypeSearchBarView)Mockito.verify((Object)this.view)).refreshSearchBarState();
        ((DataTypeSearchBarView)Mockito.verify((Object)this.view)).disableSearch();
        ((DataTypeSearchBarView)Mockito.verify((Object)this.view)).disableResults();
    }

    @Test
    public void testEnableSearch() {
        HTMLElement resultsContainer = (HTMLElement)Mockito.mock(HTMLElement.class);
        resultsContainer.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)this.presenter.getResultsContainer()).thenReturn((Object)resultsContainer);
        this.view.enableSearch();
        ((DOMTokenList)Mockito.verify((Object)resultsContainer.classList)).add(new String[]{"kie-search-engine-enabled"});
    }

    @Test
    public void testDisableSearch() {
        HTMLElement resultsContainer = (HTMLElement)Mockito.mock(HTMLElement.class);
        resultsContainer.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)this.presenter.getResultsContainer()).thenReturn((Object)resultsContainer);
        this.view.disableSearch();
        ((DOMTokenList)Mockito.verify((Object)resultsContainer.classList)).remove(new String[]{"kie-search-engine-enabled"});
    }

    @Test
    public void testSearch() {
        String keyword = "keyword";
        ((DataTypeSearchBarView)Mockito.doNothing().when((Object)this.view)).setTimeout((DomGlobal.SetTimeoutCallbackFn)Matchers.any(), (double)Matchers.anyInt());
        this.searchBar.value = "keyword";
        this.view.search();
        ((DataTypeSearchBarView)Mockito.verify((Object)this.view)).setTimeout((DomGlobal.SetTimeoutCallbackFn)this.callback.capture(), Matchers.eq((double)500.0));
        ((DomGlobal.SetTimeoutCallbackFn)this.callback.getValue()).onInvoke(new Object[0]);
        ((DataTypeSearchBar)Mockito.verify((Object)this.presenter)).search("keyword");
    }

    @Test
    public void testDisableResults() {
        HTMLElement resultsContainer = (HTMLElement)Mockito.mock(HTMLElement.class);
        NodeList results = (NodeList)Mockito.spy((Object)new NodeList());
        Element element1 = (Element)Mockito.mock(Element.class);
        Element element2 = (Element)Mockito.mock(Element.class);
        Mockito.when((Object)this.presenter.getResultsContainer()).thenReturn((Object)resultsContainer);
        Mockito.when((Object)resultsContainer.querySelectorAll(".kie-search-engine-result")).thenReturn((Object)results);
        ((NodeList)Mockito.doReturn((Object)element1).when((Object)results)).getAt(0);
        ((NodeList)Mockito.doReturn((Object)element2).when((Object)results)).getAt(1);
        element1.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        element2.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        results.length = 2.0;
        this.view.disableResults();
        ((DOMTokenList)Mockito.verify((Object)element1.classList)).remove(new String[]{"kie-search-engine-result"});
        ((DOMTokenList)Mockito.verify((Object)element2.classList)).remove(new String[]{"kie-search-engine-result"});
    }

    @Test
    public void testRefreshSearchBarStateWhenItsActive() {
        this.searchBar.value = "keyword";
        this.view.refreshSearchBarState();
        ((DOMTokenList)Mockito.verify((Object)this.searchIcon.classList)).add(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)this.closeSearch.classList)).remove(new String[]{"hidden"});
    }

    @Test
    public void testRefreshSearchBarStateWhenItsNotActive() {
        this.searchBar.value = "";
        this.view.refreshSearchBarState();
        ((DOMTokenList)Mockito.verify((Object)this.searchIcon.classList)).remove(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)this.closeSearch.classList)).add(new String[]{"hidden"});
    }
}

