/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.graph;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.v1_1.DRGElement;
import org.kie.workbench.common.dmn.api.definition.v1_1.Definitions;
import org.kie.workbench.common.dmn.api.graph.DMNDiagramUtils;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNGraphUtilsTest {
    @Mock
    private SessionManager sessionManager;
    @Mock
    private DMNDiagramUtils dmnDiagramUtils;
    @Mock
    private ClientSession clientSession;
    @Mock
    private CanvasHandler canvasHandler;
    @Mock
    private Diagram diagram;
    private DMNGraphUtils utils;

    @Before
    public void setup() {
        this.utils = new DMNGraphUtils(this.sessionManager, this.dmnDiagramUtils);
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.clientSession);
        Mockito.when((Object)this.clientSession.getCanvasHandler()).thenReturn((Object)this.canvasHandler);
        Mockito.when((Object)this.canvasHandler.getDiagram()).thenReturn((Object)this.diagram);
    }

    @Test
    public void testGetDefinitions() {
        Definitions expectedDefinitions = (Definitions)Mockito.mock(Definitions.class);
        Mockito.when((Object)this.dmnDiagramUtils.getDefinitions(this.diagram)).thenReturn((Object)expectedDefinitions);
        Definitions actualDefinitions = this.utils.getDefinitions();
        Assert.assertNotNull((Object)actualDefinitions);
        Assert.assertEquals((Object)expectedDefinitions, (Object)actualDefinitions);
    }

    @Test
    public void testGetDefinitionsWithDiagram() {
        Definitions expectedDefinitions = (Definitions)Mockito.mock(Definitions.class);
        Diagram diagram = (Diagram)Mockito.mock(Diagram.class);
        Mockito.when((Object)this.dmnDiagramUtils.getDefinitions(diagram)).thenReturn((Object)expectedDefinitions);
        Definitions actualDefinitions = this.utils.getDefinitions(diagram);
        Assert.assertNotNull((Object)actualDefinitions);
        Assert.assertEquals((Object)expectedDefinitions, (Object)actualDefinitions);
    }

    @Test
    public void testGetDiagram() {
        Diagram actualDiagram = this.utils.getDiagram();
        Assert.assertEquals((Object)this.diagram, (Object)actualDiagram);
    }

    @Test
    public void testGetCanvasHandler() {
        CanvasHandler actualCanvasHandler = this.utils.getCanvasHandler();
        Assert.assertEquals((Object)this.canvasHandler, (Object)actualCanvasHandler);
    }

    @Test
    public void testGetDRGElements() {
        List<DRGElement> expectedDRGElements = Arrays.asList((DRGElement)Mockito.mock(DRGElement.class), (DRGElement)Mockito.mock(DRGElement.class));
        Mockito.when((Object)this.dmnDiagramUtils.getNodes(this.diagram)).thenReturn(expectedDRGElements);
        List actualDRGElements = this.utils.getDRGElements();
        Assert.assertEquals(expectedDRGElements, (Object)actualDRGElements);
    }
}

