/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.shape.def;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.commons.util.Maps;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionService;
import org.kie.workbench.common.dmn.client.resources.DMNDecisionServiceSVGViewFactory;
import org.kie.workbench.common.dmn.client.resources.DMNSVGGlyphFactory;
import org.kie.workbench.common.dmn.client.shape.def.DMNDecisionServiceSVGShapeDefImpl;
import org.kie.workbench.common.stunner.core.client.components.palette.AbstractPalette;
import org.kie.workbench.common.stunner.core.client.shape.TextWrapperStrategy;
import org.kie.workbench.common.stunner.core.client.shape.view.HasTitle;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.client.shape.view.handler.FontHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.handler.SizeHandler;
import org.kie.workbench.common.stunner.core.definition.shape.ShapeGlyph;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewImpl;
import org.kie.workbench.common.stunner.svg.client.shape.view.SVGShapeView;
import org.kie.workbench.common.stunner.svg.client.shape.view.SVGShapeViewResource;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNDecisionServiceSVGShapeDefImplTest {
    private static final String DEFINITION_ID = "definition-id";
    @Mock
    private DMNDecisionServiceSVGViewFactory viewFactory;
    @Mock
    private SVGShapeViewResource viewResource;
    private DMNDecisionServiceSVGShapeDefImpl shapeDef;

    @Before
    public void setup() {
        this.shapeDef = new DMNDecisionServiceSVGShapeDefImpl();
        Mockito.when((Object)this.viewFactory.decisionService()).thenReturn((Object)this.viewResource);
    }

    @Test
    public void testNewViewInstance() {
        DecisionService decisionService = new DecisionService();
        this.shapeDef.newViewInstance(this.viewFactory, decisionService);
        ((DMNDecisionServiceSVGViewFactory)Mockito.verify((Object)this.viewFactory)).decisionService();
        ((SVGShapeViewResource)Mockito.verify((Object)this.viewResource)).build(decisionService.getDimensionsSet().getWidth().getValue(), decisionService.getDimensionsSet().getHeight().getValue(), true);
    }

    @Test
    public void testNewSizeHandler() {
        DecisionService decisionService = new DecisionService();
        ViewImpl view = new ViewImpl((Object)decisionService, Bounds.create((double)0.0, (double)0.0, (double)200.0, (double)200.0));
        SVGShapeView shapeView = (SVGShapeView)Mockito.mock(SVGShapeView.class);
        SizeHandler handler = this.shapeDef.newSizeHandler();
        handler.handle((View)view, (ShapeView)shapeView);
        ((SVGShapeView)Mockito.verify((Object)shapeView)).setMinWidth(Double.valueOf(decisionService.getDimensionsSet().getMinimumWidth()));
        ((SVGShapeView)Mockito.verify((Object)shapeView)).setMaxWidth(Double.valueOf(decisionService.getDimensionsSet().getMaximumWidth()));
        ((SVGShapeView)Mockito.verify((Object)shapeView)).setMinHeight(Double.valueOf(decisionService.getDividerLineY().getValue() + 50.0));
        ((SVGShapeView)Mockito.verify((Object)shapeView)).setMaxHeight(Double.valueOf(decisionService.getDimensionsSet().getMaximumHeight()));
    }

    @Test
    public void testNewFontHandler() {
        DecisionService decisionService = new DecisionService();
        SVGShapeView shapeView = (SVGShapeView)Mockito.mock(SVGShapeView.class);
        FontHandler handler = this.shapeDef.newFontHandler();
        handler.handle((Object)decisionService, (ShapeView)shapeView);
        ((SVGShapeView)Mockito.verify((Object)shapeView)).setTitlePosition(HasTitle.VerticalAlignment.TOP, HasTitle.HorizontalAlignment.CENTER, HasTitle.ReferencePosition.INSIDE, HasTitle.Orientation.HORIZONTAL);
        ((SVGShapeView)Mockito.verify((Object)shapeView)).setMargins(new Maps.Builder().put((Object)HasTitle.VerticalAlignment.TOP, (Object)20.0).build());
        ((SVGShapeView)Mockito.verify((Object)shapeView)).setTextWrapper(TextWrapperStrategy.TRUNCATE);
    }

    @Test
    public void testGetToolboxGlyph() {
        AssertionsForClassTypes.assertThat((Object)this.shapeDef.getGlyph(DecisionService.class, DEFINITION_ID)).isInstanceOf(ShapeGlyph.class);
    }

    @Test
    public void testGetPaletteGlyphWithConsumer() {
        AssertionsForClassTypes.assertThat((Object)this.shapeDef.getGlyph(DecisionService.class, AbstractPalette.PaletteGlyphConsumer.class, DEFINITION_ID)).isEqualTo((Object)DMNSVGGlyphFactory.DECISION_SERVICE_PALETTE);
    }
}

