/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.shape.def;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.DMNViewDefinition;
import org.kie.workbench.common.dmn.api.definition.v1_1.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.v1_1.Decision;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionService;
import org.kie.workbench.common.dmn.api.definition.v1_1.InputData;
import org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeSource;
import org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation;
import org.kie.workbench.common.dmn.client.resources.DMNSVGGlyphFactory;
import org.kie.workbench.common.dmn.client.resources.DMNSVGViewFactory;
import org.kie.workbench.common.dmn.client.shape.def.DMNSVGShapeDefImpl;
import org.kie.workbench.common.stunner.core.client.components.palette.AbstractPalette;
import org.kie.workbench.common.stunner.core.definition.shape.ShapeGlyph;
import org.kie.workbench.common.stunner.svg.client.shape.view.SVGShapeViewResource;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNSVGShapeDefImplTest {
    private static final String DEFINITION_ID = "definition-id";
    @Mock
    private DMNSVGViewFactory viewFactory;
    @Mock
    private SVGShapeViewResource viewResource;
    private DMNSVGShapeDefImpl shapeDef;

    @Before
    public void setup() {
        this.shapeDef = new DMNSVGShapeDefImpl();
        Mockito.when((Object)this.viewFactory.businessKnowledgeModel()).thenReturn((Object)this.viewResource);
        Mockito.when((Object)this.viewFactory.decision()).thenReturn((Object)this.viewResource);
        Mockito.when((Object)this.viewFactory.diagram()).thenReturn((Object)this.viewResource);
        Mockito.when((Object)this.viewFactory.inputData()).thenReturn((Object)this.viewResource);
        Mockito.when((Object)this.viewFactory.knowledgeSource()).thenReturn((Object)this.viewResource);
        Mockito.when((Object)this.viewFactory.textAnnotation()).thenReturn((Object)this.viewResource);
    }

    @Test
    public void testNewViewInstance() {
        BusinessKnowledgeModel businessKnowledgeModel = new BusinessKnowledgeModel();
        this.shapeDef.newViewInstance(this.viewFactory, (DMNViewDefinition)businessKnowledgeModel);
        ((DMNSVGViewFactory)Mockito.verify((Object)this.viewFactory)).businessKnowledgeModel();
        ((SVGShapeViewResource)Mockito.verify((Object)this.viewResource)).build(businessKnowledgeModel.getDimensionsSet().getWidth().getValue(), businessKnowledgeModel.getDimensionsSet().getHeight().getValue(), true);
        Mockito.reset((Object[])new SVGShapeViewResource[]{this.viewResource});
        Decision decision = new Decision();
        this.shapeDef.newViewInstance(this.viewFactory, (DMNViewDefinition)decision);
        ((DMNSVGViewFactory)Mockito.verify((Object)this.viewFactory)).decision();
        ((SVGShapeViewResource)Mockito.verify((Object)this.viewResource)).build(decision.getDimensionsSet().getWidth().getValue(), decision.getDimensionsSet().getHeight().getValue(), true);
        Mockito.reset((Object[])new SVGShapeViewResource[]{this.viewResource});
        this.shapeDef.newViewInstance(this.viewFactory, (DMNViewDefinition)new InputData());
        ((DMNSVGViewFactory)Mockito.verify((Object)this.viewFactory)).inputData();
        ((SVGShapeViewResource)Mockito.verify((Object)this.viewResource)).build(businessKnowledgeModel.getDimensionsSet().getWidth().getValue(), businessKnowledgeModel.getDimensionsSet().getHeight().getValue(), true);
        Mockito.reset((Object[])new SVGShapeViewResource[]{this.viewResource});
        KnowledgeSource knowledgeSource = new KnowledgeSource();
        this.shapeDef.newViewInstance(this.viewFactory, (DMNViewDefinition)knowledgeSource);
        ((DMNSVGViewFactory)Mockito.verify((Object)this.viewFactory)).knowledgeSource();
        ((SVGShapeViewResource)Mockito.verify((Object)this.viewResource)).build(knowledgeSource.getDimensionsSet().getWidth().getValue(), knowledgeSource.getDimensionsSet().getHeight().getValue(), true);
        Mockito.reset((Object[])new SVGShapeViewResource[]{this.viewResource});
        TextAnnotation textAnnotation = new TextAnnotation();
        this.shapeDef.newViewInstance(this.viewFactory, (DMNViewDefinition)textAnnotation);
        ((DMNSVGViewFactory)Mockito.verify((Object)this.viewFactory)).textAnnotation();
        ((SVGShapeViewResource)Mockito.verify((Object)this.viewResource)).build(textAnnotation.getDimensionsSet().getWidth().getValue(), textAnnotation.getDimensionsSet().getHeight().getValue(), true);
    }

    @Test
    public void testGetToolboxGlyph() {
        Assert.assertEquals((Object)DMNSVGGlyphFactory.BUSINESS_KNOWLEDGE_MODEL_TOOLBOX, (Object)this.shapeDef.getGlyph(BusinessKnowledgeModel.class, DEFINITION_ID));
        Assert.assertEquals((Object)DMNSVGGlyphFactory.DECISION_TOOLBOX, (Object)this.shapeDef.getGlyph(Decision.class, DEFINITION_ID));
        Assert.assertEquals((Object)DMNSVGGlyphFactory.INPUT_DATA_TOOLBOX, (Object)this.shapeDef.getGlyph(InputData.class, DEFINITION_ID));
        Assert.assertEquals((Object)DMNSVGGlyphFactory.KNOWLEDGE_SOURCE_TOOLBOX, (Object)this.shapeDef.getGlyph(KnowledgeSource.class, DEFINITION_ID));
        Assert.assertEquals((Object)DMNSVGGlyphFactory.TEXT_ANNOTATION_TOOLBOX, (Object)this.shapeDef.getGlyph(TextAnnotation.class, DEFINITION_ID));
        Assert.assertTrue((boolean)(this.shapeDef.getGlyph(DMNViewDefinition.class, DEFINITION_ID) instanceof ShapeGlyph));
    }

    @Test
    public void testGetPaletteGlyphWithConsumer() {
        Assert.assertEquals((Object)DMNSVGGlyphFactory.BUSINESS_KNOWLEDGE_MODEL_PALETTE, (Object)this.shapeDef.getGlyph(BusinessKnowledgeModel.class, AbstractPalette.PaletteGlyphConsumer.class, DEFINITION_ID));
        Assert.assertEquals((Object)DMNSVGGlyphFactory.DECISION_PALETTE, (Object)this.shapeDef.getGlyph(Decision.class, AbstractPalette.PaletteGlyphConsumer.class, DEFINITION_ID));
        Assert.assertEquals((Object)DMNSVGGlyphFactory.DECISION_SERVICE_PALETTE, (Object)this.shapeDef.getGlyph(DecisionService.class, AbstractPalette.PaletteGlyphConsumer.class, DEFINITION_ID));
        Assert.assertEquals((Object)DMNSVGGlyphFactory.INPUT_DATA_PALETTE, (Object)this.shapeDef.getGlyph(InputData.class, AbstractPalette.PaletteGlyphConsumer.class, DEFINITION_ID));
        Assert.assertEquals((Object)DMNSVGGlyphFactory.KNOWLEDGE_SOURCE_PALETTE, (Object)this.shapeDef.getGlyph(KnowledgeSource.class, AbstractPalette.PaletteGlyphConsumer.class, DEFINITION_ID));
        Assert.assertEquals((Object)DMNSVGGlyphFactory.TEXT_ANNOTATION_PALETTE, (Object)this.shapeDef.getGlyph(TextAnnotation.class, AbstractPalette.PaletteGlyphConsumer.class, DEFINITION_ID));
        Assert.assertEquals((Object)true, (Object)(this.shapeDef.getGlyph(DMNViewDefinition.class, AbstractPalette.PaletteGlyphConsumer.class, DEFINITION_ID) instanceof ShapeGlyph));
    }
}

