/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.shape.factory;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.DMNDefinition;
import org.kie.workbench.common.dmn.api.definition.v1_1.Association;
import org.kie.workbench.common.dmn.api.definition.v1_1.AuthorityRequirement;
import org.kie.workbench.common.dmn.api.definition.v1_1.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNDiagram;
import org.kie.workbench.common.dmn.api.definition.v1_1.Decision;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionService;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationRequirement;
import org.kie.workbench.common.dmn.api.definition.v1_1.InputData;
import org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeRequirement;
import org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeSource;
import org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation;
import org.kie.workbench.common.dmn.client.shape.def.DMNConnectorShapeDefImpl;
import org.kie.workbench.common.dmn.client.shape.def.DMNSVGShapeDefImpl;
import org.kie.workbench.common.dmn.client.shape.factory.DMNConnectorShapeFactory;
import org.kie.workbench.common.dmn.client.shape.factory.DMNDecisionServiceShapeFactory;
import org.kie.workbench.common.dmn.client.shape.factory.DMNShapeFactory;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.factory.DelegateShapeFactory;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeFactory;
import org.kie.workbench.common.stunner.core.definition.shape.ShapeDef;
import org.kie.workbench.common.stunner.svg.client.shape.factory.SVGShapeFactory;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNShapeFactoryTest {
    private static final String DEFINITION_ID = "definition-id";
    @Mock
    private SVGShapeFactory svgShapeFactory;
    @Mock
    private DMNConnectorShapeFactory dmnConnectorShapeFactory;
    @Mock
    private DMNDecisionServiceShapeFactory dmnDecisionServiceShapeFactory;
    @Mock
    private DelegateShapeFactory<DMNDefinition, Shape> delegateShapeFactory;
    @Mock
    private DMNDefinition definition;
    @Captor
    private ArgumentCaptor<Supplier> shapeDefFactoryCaptor;
    private DMNShapeFactory factory;

    @Before
    public void setup() {
        this.factory = new DMNShapeFactory(this.svgShapeFactory, this.dmnConnectorShapeFactory, this.dmnDecisionServiceShapeFactory, this.delegateShapeFactory);
        Mockito.when((Object)this.delegateShapeFactory.delegate((Class)Matchers.any(Class.class), (ShapeDef)Matchers.any(ShapeDef.class), (Supplier)Matchers.any(Supplier.class))).thenReturn(this.delegateShapeFactory);
    }

    @Test
    public void testInit() {
        this.factory.init();
        ((DelegateShapeFactory)Mockito.verify(this.delegateShapeFactory)).delegate((Class)Matchers.eq(DMNDiagram.class), (ShapeDef)Matchers.any(DMNSVGShapeDefImpl.class), (Supplier)this.shapeDefFactoryCaptor.capture());
        Assert.assertEquals((Object)this.svgShapeFactory, ((Supplier)this.shapeDefFactoryCaptor.getValue()).get());
        ((DelegateShapeFactory)Mockito.verify(this.delegateShapeFactory)).delegate((Class)Matchers.eq(InputData.class), (ShapeDef)Matchers.any(DMNSVGShapeDefImpl.class), (Supplier)this.shapeDefFactoryCaptor.capture());
        Assert.assertEquals((Object)this.svgShapeFactory, ((Supplier)this.shapeDefFactoryCaptor.getValue()).get());
        ((DelegateShapeFactory)Mockito.verify(this.delegateShapeFactory)).delegate((Class)Matchers.eq(KnowledgeSource.class), (ShapeDef)Matchers.any(DMNSVGShapeDefImpl.class), (Supplier)this.shapeDefFactoryCaptor.capture());
        Assert.assertEquals((Object)this.svgShapeFactory, ((Supplier)this.shapeDefFactoryCaptor.getValue()).get());
        ((DelegateShapeFactory)Mockito.verify(this.delegateShapeFactory)).delegate((Class)Matchers.eq(BusinessKnowledgeModel.class), (ShapeDef)Matchers.any(DMNSVGShapeDefImpl.class), (Supplier)this.shapeDefFactoryCaptor.capture());
        Assert.assertEquals((Object)this.svgShapeFactory, ((Supplier)this.shapeDefFactoryCaptor.getValue()).get());
        ((DelegateShapeFactory)Mockito.verify(this.delegateShapeFactory)).delegate((Class)Matchers.eq(Decision.class), (ShapeDef)Matchers.any(DMNSVGShapeDefImpl.class), (Supplier)this.shapeDefFactoryCaptor.capture());
        Assert.assertEquals((Object)this.svgShapeFactory, ((Supplier)this.shapeDefFactoryCaptor.getValue()).get());
        ((DelegateShapeFactory)Mockito.verify(this.delegateShapeFactory)).delegate((Class)Matchers.eq(TextAnnotation.class), (ShapeDef)Matchers.any(DMNSVGShapeDefImpl.class), (Supplier)this.shapeDefFactoryCaptor.capture());
        Assert.assertEquals((Object)this.svgShapeFactory, ((Supplier)this.shapeDefFactoryCaptor.getValue()).get());
        ((DelegateShapeFactory)Mockito.verify(this.delegateShapeFactory)).delegate((Class)Matchers.eq(Association.class), (ShapeDef)Matchers.any(DMNConnectorShapeDefImpl.class), (Supplier)this.shapeDefFactoryCaptor.capture());
        Assert.assertEquals((Object)this.dmnConnectorShapeFactory, ((Supplier)this.shapeDefFactoryCaptor.getValue()).get());
        ((DelegateShapeFactory)Mockito.verify(this.delegateShapeFactory)).delegate((Class)Matchers.eq(AuthorityRequirement.class), (ShapeDef)Matchers.any(DMNConnectorShapeDefImpl.class), (Supplier)this.shapeDefFactoryCaptor.capture());
        Assert.assertEquals((Object)this.dmnConnectorShapeFactory, ((Supplier)this.shapeDefFactoryCaptor.getValue()).get());
        ((DelegateShapeFactory)Mockito.verify(this.delegateShapeFactory)).delegate((Class)Matchers.eq(InformationRequirement.class), (ShapeDef)Matchers.any(DMNConnectorShapeDefImpl.class), (Supplier)this.shapeDefFactoryCaptor.capture());
        Assert.assertEquals((Object)this.dmnConnectorShapeFactory, ((Supplier)this.shapeDefFactoryCaptor.getValue()).get());
        ((DelegateShapeFactory)Mockito.verify(this.delegateShapeFactory)).delegate((Class)Matchers.eq(KnowledgeRequirement.class), (ShapeDef)Matchers.any(DMNConnectorShapeDefImpl.class), (Supplier)this.shapeDefFactoryCaptor.capture());
        Assert.assertEquals((Object)this.dmnConnectorShapeFactory, ((Supplier)this.shapeDefFactoryCaptor.getValue()).get());
        ((DelegateShapeFactory)Mockito.verify(this.delegateShapeFactory)).delegate((Class)Matchers.eq(DecisionService.class), (ShapeDef)Matchers.any(DMNSVGShapeDefImpl.class), (Supplier)this.shapeDefFactoryCaptor.capture());
        Assert.assertEquals((Object)this.dmnDecisionServiceShapeFactory, ((Supplier)this.shapeDefFactoryCaptor.getValue()).get());
    }

    @Test
    public void testNewShape() {
        this.factory.newShape(this.definition);
        ((DelegateShapeFactory)Mockito.verify(this.delegateShapeFactory)).newShape((Object)this.definition);
    }

    @Test
    public void testGetGlyph() {
        this.factory.getGlyph(DEFINITION_ID);
        ((DelegateShapeFactory)Mockito.verify(this.delegateShapeFactory)).getGlyph(DEFINITION_ID);
    }

    @Test
    public void testGetGlyphWithConsumer() {
        this.factory.getGlyph(DEFINITION_ID, ShapeFactory.GlyphConsumer.class);
        ((DelegateShapeFactory)Mockito.verify(this.delegateShapeFactory)).getGlyph(DEFINITION_ID, ShapeFactory.GlyphConsumer.class);
    }
}

