/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.columns;

import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.HasTypeRef;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ContextGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.InformationItemCell;
import org.kie.workbench.common.dmn.client.editors.types.HasNameAndTypeRef;
import org.kie.workbench.common.dmn.client.editors.types.NameAndDataTypePopoverView;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.EditableNameAndDataTypeColumn;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.HasCellEditorControls;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCell;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellEditContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;

@RunWith(value=LienzoMockitoTestRunner.class)
public class EditableNameAndDataTypeColumnTest {
    private static final int UI_ROW_INDEX = 0;
    private static final int UI_COLUMN_INDEX = 1;
    private static final double ABSOLUTE_CELL_X = 100.0;
    private static final double ABSOLUTE_CELL_Y = 200.0;
    private static final double RELATIVE_X = 105.0;
    private static final double RELATIVE_Y = 210.0;
    private static final String NEW_NAME = "new name";
    private static final Optional<String> EDITOR_TITLE = Optional.of("editor");
    @Mock
    private GridColumn.HeaderMetaData headerMetaData;
    @Mock
    private ContextGrid gridWidget;
    @Mock
    private Predicate<Integer> isEditable;
    @Mock
    private Consumer<HasName> clearDisplayNameConsumer;
    @Mock
    private BiConsumer<HasName, Name> setDisplayNameConsumer;
    @Mock
    private BiConsumer<HasTypeRef, QName> setTypeRefConsumer;
    @Mock
    private CellEditorControlsView.Presenter cellEditorControls;
    @Mock
    private NameAndDataTypePopoverView.Presenter editor;
    @Mock
    private GridBodyCellEditContext context;
    @Mock
    private Consumer<GridCellValue<InformationItemCell.HasNameCell>> callback;
    @Spy
    private InformationItem informationItem = new InformationItem();
    @Captor
    private ArgumentCaptor<HasNameAndTypeRef> hasNameAndDataTypeControlCaptor;
    @Captor
    private ArgumentCaptor<Name> nameCaptor;
    private GridCell<InformationItemCell.HasNameCell> cell;
    private EditableNameAndDataTypeColumn column;

    @Before
    public void setup() {
        Mockito.when((Object)this.gridWidget.getExpression()).thenReturn(Optional::empty);
        this.cell = new BaseGridCell((GridCellValue)new BaseGridCellValue((Object)InformationItemCell.HasNameAndDataTypeCell.wrap((InformationItem)this.informationItem)));
        this.column = (EditableNameAndDataTypeColumn)Mockito.spy((Object)new EditableNameAndDataTypeColumn<ContextGrid>(this.headerMetaData, 100.0, this.gridWidget, this.isEditable, this.clearDisplayNameConsumer, this.setDisplayNameConsumer, this.setTypeRefConsumer, this.cellEditorControls, this.editor, EDITOR_TITLE){});
        Mockito.when((Object)this.context.getRelativeLocation()).thenReturn(Optional.of(new Point2D(105.0, 210.0)));
        Mockito.when((Object)this.context.getRowIndex()).thenReturn((Object)0);
        Mockito.when((Object)this.context.getColumnIndex()).thenReturn((Object)1);
        Mockito.when((Object)this.context.getAbsoluteCellX()).thenReturn((Object)100.0);
        Mockito.when((Object)this.context.getAbsoluteCellY()).thenReturn((Object)200.0);
        Mockito.when((Object)this.gridWidget.getParentInformation()).thenReturn((Object)new GridCellTuple(0, 0, (GridWidget)this.gridWidget));
    }

    @Test
    public void testIsMovable() {
        Assertions.assertThat((boolean)this.column.isMovable()).isFalse();
    }

    @Test
    public void testIsResizable() {
        Assertions.assertThat((boolean)this.column.isResizable()).isTrue();
    }

    @Test
    public void testEditWhenRowIsNotEditable() {
        Mockito.when((Object)this.isEditable.test(Matchers.anyInt())).thenReturn((Object)false);
        this.column.edit(this.cell, this.context, this.callback);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.editor});
    }

    @Test
    public void testEditWhenRowIsEditable() {
        Mockito.when((Object)this.isEditable.test(Matchers.anyInt())).thenReturn((Object)true);
        this.column.edit(this.cell, this.context, this.callback);
        ((NameAndDataTypePopoverView.Presenter)Mockito.verify((Object)this.editor)).bind(Matchers.any(HasNameAndTypeRef.class), Matchers.eq((int)0), Matchers.eq((int)1));
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls)).show((HasCellEditorControls.Editor)Matchers.eq((Object)this.editor), (Optional)Matchers.eq(EDITOR_TITLE), Matchers.eq((int)105), Matchers.eq((int)210));
    }

    @Test
    public void testEditGetters() {
        this.mockEditAction();
        HasNameAndTypeRef hasNameAndTypeRef = (HasNameAndTypeRef)this.hasNameAndDataTypeControlCaptor.getValue();
        hasNameAndTypeRef.getName();
        ((InformationItem)Mockito.verify((Object)this.informationItem)).getName();
        hasNameAndTypeRef.getTypeRef();
        ((InformationItem)Mockito.verify((Object)this.informationItem)).getTypeRef();
        hasNameAndTypeRef.getHasTypeRefs();
        ((InformationItem)Mockito.verify((Object)this.informationItem)).getHasTypeRefs();
        Assertions.assertThat((Object)hasNameAndTypeRef.asDMNModelInstrumentedBase()).isEqualTo((Object)this.informationItem);
    }

    @Test
    public void testEditSetNameNoChange() {
        this.mockEditAction();
        HasNameAndTypeRef hasNameAndTypeRef = (HasNameAndTypeRef)this.hasNameAndDataTypeControlCaptor.getValue();
        hasNameAndTypeRef.setName(this.informationItem.getName());
        ((Consumer)Mockito.verify(this.clearDisplayNameConsumer, (VerificationMode)Mockito.never())).accept(Matchers.any(HasName.class));
        ((BiConsumer)Mockito.verify(this.setDisplayNameConsumer, (VerificationMode)Mockito.never())).accept(Matchers.anyObject(), Matchers.any(Name.class));
    }

    @Test
    public void testEditSetNameChanged() {
        this.mockEditAction();
        HasNameAndTypeRef hasNameAndTypeRef = (HasNameAndTypeRef)this.hasNameAndDataTypeControlCaptor.getValue();
        hasNameAndTypeRef.setName(new Name(NEW_NAME));
        ((Consumer)Mockito.verify(this.clearDisplayNameConsumer, (VerificationMode)Mockito.never())).accept(Matchers.any(HasName.class));
        ((BiConsumer)Mockito.verify(this.setDisplayNameConsumer)).accept(Matchers.eq((Object)this.cell.getValue().getValue()), this.nameCaptor.capture());
        Assertions.assertThat((String)((Name)this.nameCaptor.getValue()).getValue()).isEqualTo((Object)NEW_NAME);
    }

    @Test
    public void testEditSetNameChangedToEmpty() {
        this.mockEditAction();
        HasNameAndTypeRef hasNameAndTypeRef = (HasNameAndTypeRef)this.hasNameAndDataTypeControlCaptor.getValue();
        hasNameAndTypeRef.setName(null);
        ((Consumer)Mockito.verify(this.clearDisplayNameConsumer)).accept(Matchers.eq((Object)this.cell.getValue().getValue()));
        ((BiConsumer)Mockito.verify(this.setDisplayNameConsumer, (VerificationMode)Mockito.never())).accept(Matchers.anyObject(), Matchers.any(Name.class));
    }

    @Test
    public void testEditSetTypeRefNoChange() {
        this.mockEditAction();
        HasNameAndTypeRef hasNameAndTypeRef = (HasNameAndTypeRef)this.hasNameAndDataTypeControlCaptor.getValue();
        hasNameAndTypeRef.setTypeRef(new QName());
        ((BiConsumer)Mockito.verify(this.setTypeRefConsumer, (VerificationMode)Mockito.never())).accept(Matchers.anyObject(), Matchers.any(QName.class));
    }

    @Test
    public void testEditSetTypeRefChanged() {
        this.mockEditAction();
        HasNameAndTypeRef hasNameAndTypeRef = (HasNameAndTypeRef)this.hasNameAndDataTypeControlCaptor.getValue();
        QName feel = new QName(DMNModelInstrumentedBase.Namespace.DMN.getUri(), "", DMNModelInstrumentedBase.Namespace.DMN.getPrefix());
        hasNameAndTypeRef.setTypeRef(feel);
        ((BiConsumer)Mockito.verify(this.setTypeRefConsumer)).accept(Matchers.eq((Object)((InformationItemCell.HasNameAndDataTypeCell)this.cell.getValue().getValue())), Matchers.eq((Object)feel));
    }

    @Test
    public void testDefaultValue() {
        Assertions.assertThat((String)((InformationItemCell.HasNameCell)this.column.makeDefaultCellValue().getValue()).getName().getValue()).isEmpty();
    }

    @Test
    public void testSetWidth() {
        this.column.setWidth(200.0);
        ((EditableNameAndDataTypeColumn)Mockito.verify((Object)this.column)).updateWidthOfPeers();
    }

    private void mockEditAction() {
        Mockito.when((Object)this.isEditable.test(Matchers.anyInt())).thenReturn((Object)true);
        this.column.edit(this.cell, this.context, this.callback);
        ((NameAndDataTypePopoverView.Presenter)Mockito.verify((Object)this.editor)).bind(this.hasNameAndDataTypeControlCaptor.capture(), Matchers.eq((int)0), Matchers.eq((int)1));
    }
}

