/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.columns.factory;

import com.ait.lienzo.client.core.types.Transform;
import com.google.gwt.user.client.ui.AbsolutePanel;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.dmn.client.widgets.grid.model.BaseUIModelMapper;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.command.Command;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.dom.impl.BaseDOMElement;
import org.uberfire.ext.wires.core.grids.client.widget.dom.single.impl.BaseSingletonDOMElementFactory;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLayerRedrawManager;

public abstract class BaseSingletonDOMElementFactoryTest<F extends BaseSingletonDOMElementFactory, E extends BaseDOMElement> {
    @Mock
    private GridBodyCellRenderContext context;
    @Mock
    private Consumer<E> onCreation;
    @Mock
    private Consumer<E> onDisplay;
    @Mock
    private EditorSession session;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Captor
    private ArgumentCaptor<GridLayerRedrawManager.PrioritizedCommand> commandArgumentCaptor;
    @Captor
    private ArgumentCaptor<E> domElementOnCreationArgumentCaptor;
    @Captor
    private ArgumentCaptor<E> domElementOnDisplayArgumentCaptor;
    @Mock
    protected DMNGridPanel gridPanel;
    @Mock
    protected GridLayer gridLayer;
    @Mock
    protected GridWidget gridWidget;
    @Mock
    protected SessionManager sessionManager;
    @Mock
    protected SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    protected BaseUIModelMapper<?> uiModelMapper;

    @Before
    public void setup() {
        Mockito.when((Object)this.context.getTransform()).thenReturn((Object)new Transform());
        Mockito.when((Object)this.gridLayer.getDomElementContainer()).thenReturn((Object)new AbsolutePanel());
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getCanvasHandler()).thenReturn((Object)this.canvasHandler);
        Mockito.when((Object)this.gridWidget.getModel()).thenReturn((Object)new BaseGridData());
    }

    @Test
    public void checkAttachDomElement() {
        F factory = this.getFactoryForAttachDomElementTest();
        factory.attachDomElement(this.context, this.onCreation, this.onDisplay);
        ((GridLayer)Mockito.verify((Object)this.gridLayer)).batch((GridLayerRedrawManager.PrioritizedCommand)this.commandArgumentCaptor.capture());
        GridLayerRedrawManager.PrioritizedCommand command = (GridLayerRedrawManager.PrioritizedCommand)this.commandArgumentCaptor.getValue();
        command.execute();
        ((Consumer)Mockito.verify(this.onCreation)).accept(this.domElementOnCreationArgumentCaptor.capture());
        BaseDOMElement domElementOnCreation = (BaseDOMElement)this.domElementOnCreationArgumentCaptor.getValue();
        ((BaseDOMElement)Mockito.verify((Object)domElementOnCreation)).setContext((GridBodyCellRenderContext)Mockito.eq((Object)this.context));
        ((BaseDOMElement)Mockito.verify((Object)domElementOnCreation)).initialise((GridBodyCellRenderContext)Mockito.eq((Object)this.context));
        ((Consumer)Mockito.verify(this.onDisplay)).accept(this.domElementOnDisplayArgumentCaptor.capture());
        BaseDOMElement domElementOnDisplay = (BaseDOMElement)this.domElementOnDisplayArgumentCaptor.getValue();
        ((BaseDOMElement)Mockito.verify((Object)domElementOnDisplay)).attach();
        Assert.assertEquals((Object)domElementOnCreation, (Object)domElementOnDisplay);
    }

    @Test
    public void checkFlush() {
        F factory = this.getFactoryForFlushTest();
        factory.attachDomElement(this.context, this.onCreation, this.onDisplay);
        ((GridLayer)Mockito.verify((Object)this.gridLayer)).batch((GridLayerRedrawManager.PrioritizedCommand)this.commandArgumentCaptor.capture());
        GridLayerRedrawManager.PrioritizedCommand command = (GridLayerRedrawManager.PrioritizedCommand)this.commandArgumentCaptor.getValue();
        command.execute();
        factory.flush();
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Mockito.eq((Object)this.canvasHandler), (Command)Mockito.any(AbstractCanvasGraphCommand.class));
    }

    protected abstract F getFactoryForAttachDomElementTest();

    protected abstract F getFactoryForFlushTest();
}

