/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.controls.container;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Optional;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.session.DMNSession;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlImpl;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControls;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=LienzoMockitoTestRunner.class)
public class CellEditorControlImplTest {
    @Mock
    private DMNSession session;
    @Mock
    private DMNGridPanel gridPanel;
    @Mock
    private CellEditorControls editorControls;
    @Captor
    private ArgumentCaptor<Optional<Supplier<DMNGridPanel>>> gridPanelSupplierArgumentCaptor;
    private CellEditorControlImpl control;

    @Before
    public void setup() {
        this.control = new CellEditorControlImpl(this.editorControls);
        Mockito.when((Object)this.session.getGridPanel()).thenReturn((Object)this.gridPanel);
    }

    @Test
    public void testBind() {
        this.control.bind(this.session);
        ((CellEditorControls)Mockito.verify((Object)this.editorControls)).setGridPanelSupplier((Optional)this.gridPanelSupplierArgumentCaptor.capture());
        Optional gridPanelSupplier = (Optional)this.gridPanelSupplierArgumentCaptor.getValue();
        Assert.assertTrue((boolean)gridPanelSupplier.isPresent());
        Assert.assertEquals((Object)this.gridPanel, ((Supplier)gridPanelSupplier.get()).get());
    }

    @Test
    public void testDoDestroy() {
        this.control.bind(this.session);
        Mockito.reset((Object[])new CellEditorControls[]{this.editorControls});
        this.control.doDestroy();
        ((CellEditorControls)Mockito.verify((Object)this.editorControls)).setGridPanelSupplier((Optional)this.gridPanelSupplierArgumentCaptor.capture());
        Optional gridPanelSupplier = (Optional)this.gridPanelSupplierArgumentCaptor.getValue();
        Assert.assertFalse((boolean)gridPanelSupplier.isPresent());
    }
}

