/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.controls.container;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.jboss.errai.common.client.dom.Body;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Document;
import org.jboss.errai.common.client.dom.EventListener;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsViewImpl;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class CellEditorControlsViewImplTest {
    @Mock
    private Document document;
    @Mock
    private Div cellEditorControls;
    @Mock
    private Div cellEditorControlsContainer;
    @Mock
    private Body body;
    @Mock
    private ElementWrapperWidget<?> elementWrapperWidget;
    @Captor
    private ArgumentCaptor<EventListener> mouseDownListenerCaptor;
    @Captor
    private ArgumentCaptor<EventListener> mouseWheelListenerCaptor;
    private CellEditorControlsViewImpl view;

    @Before
    public void setup() {
        Mockito.when((Object)this.document.getBody()).thenReturn((Object)this.body);
        this.view = (CellEditorControlsViewImpl)Mockito.spy((Object)new CellEditorControlsViewImpl(this.document, this.cellEditorControls, this.cellEditorControlsContainer));
        ((CellEditorControlsViewImpl)Mockito.doReturn(this.elementWrapperWidget).when((Object)this.view)).getWidget();
        ((CellEditorControlsViewImpl)Mockito.doNothing().when((Object)this.view)).addWidgetToRootPanel((ElementWrapperWidget)Matchers.any());
        ((CellEditorControlsViewImpl)Mockito.doNothing().when((Object)this.view)).removeWidgetFromRootPanel((ElementWrapperWidget)Matchers.any());
    }

    @Test
    public void testPostConstruct() {
        this.view.setup();
        ((CellEditorControlsViewImpl)Mockito.verify((Object)this.view)).addWidgetToRootPanel(this.elementWrapperWidget);
        ((Body)Mockito.verify((Object)this.body)).addEventListener((String)Matchers.eq((Object)"mousedown"), (EventListener)this.mouseDownListenerCaptor.capture(), Matchers.eq((boolean)false));
        ((Body)Mockito.verify((Object)this.body)).addEventListener((String)Matchers.eq((Object)"mousewheel"), (EventListener)this.mouseWheelListenerCaptor.capture(), Matchers.eq((boolean)false));
    }

    @Test
    public void testPreDestroy() {
        this.testPostConstruct();
        this.view.destroy();
        ((CellEditorControlsViewImpl)Mockito.verify((Object)this.view)).removeWidgetFromRootPanel(this.elementWrapperWidget);
        ((Body)Mockito.verify((Object)this.body)).removeEventListener((String)Matchers.eq((Object)"mousedown"), (EventListener)Matchers.eq((Object)this.mouseDownListenerCaptor.getValue()), Matchers.eq((boolean)false));
        ((Body)Mockito.verify((Object)this.body)).removeEventListener((String)Matchers.eq((Object)"mousewheel"), (EventListener)Matchers.eq((Object)this.mouseWheelListenerCaptor.getValue()), Matchers.eq((boolean)false));
    }
}

