/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.controls.list;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Java6Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.HasListSelectorControl;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelector;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ListSelectorTest {
    @Mock
    private HasListSelectorControl.ListSelectorItem listSelectorItem1;
    @Mock
    private HasListSelectorControl.ListSelectorItem listSelectorItem2;
    @Mock
    private ListSelectorView view;
    @Mock
    private HasListSelectorControl bound;
    @Captor
    private ArgumentCaptor<List<HasListSelectorControl.ListSelectorItem>> itemsCaptor;
    private ListSelectorView.Presenter listSelector;

    @Before
    public void setup() {
        this.listSelector = new ListSelector(this.view);
        Mockito.when((Object)this.bound.getItems(Matchers.anyInt(), Matchers.anyInt())).thenReturn(Arrays.asList(this.listSelectorItem1, this.listSelectorItem2));
    }

    @Test
    public void testInit() {
        ((ListSelectorView)Mockito.verify((Object)this.view)).init(Matchers.eq((Object)this.listSelector));
    }

    @Test
    public void testShow() {
        this.listSelector.bind((Object)this.bound, 0, 0);
        this.listSelector.show(Optional.empty());
        ((ListSelectorView)Mockito.verify((Object)this.view)).show();
    }

    @Test
    public void testHide() {
        this.listSelector.bind((Object)this.bound, 0, 0);
        this.listSelector.hide();
        ((ListSelectorView)Mockito.verify((Object)this.view)).hide();
    }

    @Test
    public void testBindWithItems() {
        this.listSelector.bind((Object)this.bound, 0, 0);
        ((ListSelectorView)Mockito.verify((Object)this.view)).setItems((List)this.itemsCaptor.capture());
        Java6Assertions.assertThat((List)((List)this.itemsCaptor.getValue())).containsOnly((Object[])new HasListSelectorControl.ListSelectorItem[]{this.listSelectorItem1, this.listSelectorItem2});
        this.listSelector.show(Optional.empty());
        ((ListSelectorView)Mockito.verify((Object)this.view)).show();
    }

    @Test
    public void testBindWithNoItems() {
        Mockito.when((Object)this.bound.getItems(Matchers.anyInt(), Matchers.anyInt())).thenReturn(Collections.emptyList());
        this.listSelector.bind((Object)this.bound, 0, 0);
        ((ListSelectorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setItems(Matchers.anyList());
        this.listSelector.show(Optional.empty());
        ((ListSelectorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).show();
    }

    @Test
    public void testOnItemSelected() {
        this.listSelector.bind((Object)this.bound, 0, 0);
        this.listSelector.onItemSelected(this.listSelectorItem2);
        ((HasListSelectorControl)Mockito.verify((Object)this.bound)).onItemSelected((HasListSelectorControl.ListSelectorItem)Matchers.eq((Object)this.listSelectorItem2));
    }
}

