/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.handlers;

import com.ait.lienzo.client.core.event.AbstractNodeMouseEvent;
import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Optional;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.expressions.types.literal.LiteralExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.handlers.DelegatingGridWidgetCellSelectorMouseEventHandler;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.CellSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridSelectionManager;

@RunWith(value=LienzoMockitoTestRunner.class)
public class DelegatingGridWidgetCellSelectorMouseEventHandlerTest {
    private static final int PARENT_ROW_INDEX = 0;
    private static final int PARENT_COLUMN_INDEX = 1;
    @Mock
    private GridSelectionManager selectionManager;
    @Mock
    private GridCellTuple parent;
    @Mock
    private GridWidget parentGridWidget;
    @Mock
    private CellSelectionManager parentCellSelectionManager;
    @Mock
    private LiteralExpressionGrid gridWidget;
    @Mock
    private Point2D relativeLocation;
    @Mock
    private AbstractNodeMouseEvent event;
    @Mock
    private Layer layer;
    private Optional<Integer> uiHeaderRowIndex;
    private Optional<Integer> uiHeaderColumnIndex;
    private Optional<Integer> uiRowIndex;
    private Optional<Integer> uiColumnIndex;
    private DelegatingGridWidgetCellSelectorMouseEventHandler handler;

    private void setupGrid(Supplier<GridCellTuple> parentSupplier, Supplier<Integer> nestingSupplier) {
        this.handler = (DelegatingGridWidgetCellSelectorMouseEventHandler)Mockito.spy((Object)new DelegatingGridWidgetCellSelectorMouseEventHandler(this.selectionManager, parentSupplier, nestingSupplier));
        Mockito.when((Object)this.parent.getGridWidget()).thenReturn((Object)this.parentGridWidget);
        Mockito.when((Object)this.parent.getRowIndex()).thenReturn((Object)0);
        Mockito.when((Object)this.parent.getColumnIndex()).thenReturn((Object)1);
        Mockito.when((Object)this.parentGridWidget.getCellSelectionManager()).thenReturn((Object)this.parentCellSelectionManager);
        Mockito.when((Object)this.parentGridWidget.getLayer()).thenReturn((Object)this.layer);
    }

    @Test
    public void testOnNodeMouseEventWhenNotNested() {
        this.setupGrid(() -> null, () -> 0);
        this.uiHeaderRowIndex = Optional.of(0);
        this.uiHeaderColumnIndex = Optional.of(1);
        this.uiRowIndex = Optional.of(2);
        this.uiColumnIndex = Optional.of(3);
        this.handler.onNodeMouseEvent((GridWidget)this.gridWidget, this.relativeLocation, this.uiHeaderRowIndex, this.uiHeaderColumnIndex, this.uiRowIndex, this.uiColumnIndex, this.event);
        ((DelegatingGridWidgetCellSelectorMouseEventHandler)Mockito.verify((Object)this.handler)).doSuperOnNodeMouseEvent((GridWidget)Matchers.eq((Object)this.gridWidget), (Point2D)Matchers.eq((Object)this.relativeLocation), (Optional)Matchers.eq(this.uiHeaderRowIndex), (Optional)Matchers.eq(this.uiHeaderColumnIndex), (Optional)Matchers.eq(this.uiRowIndex), (Optional)Matchers.eq(this.uiColumnIndex), (AbstractNodeMouseEvent)Matchers.eq((Object)this.event));
    }

    @Test
    public void testOnNodeMouseEventWhenNestedOnHeader() {
        this.setupGrid(() -> this.parent, () -> 1);
        this.uiHeaderRowIndex = Optional.of(0);
        this.uiHeaderColumnIndex = Optional.of(1);
        this.uiRowIndex = Optional.empty();
        this.uiColumnIndex = Optional.empty();
        Assertions.assertThat((boolean)this.handler.onNodeMouseEvent((GridWidget)this.gridWidget, this.relativeLocation, this.uiHeaderRowIndex, this.uiHeaderColumnIndex, this.uiRowIndex, this.uiColumnIndex, this.event)).isFalse();
    }

    @Test
    public void testOnNodeMouseEventWhenNestedOnBodyWithoutSelectionChange() {
        Mockito.when((Object)this.event.isShiftKeyDown()).thenReturn((Object)false);
        Mockito.when((Object)this.event.isControlKeyDown()).thenReturn((Object)true);
        Mockito.when((Object)this.parentCellSelectionManager.selectCell(Matchers.anyInt(), Matchers.anyInt(), Matchers.anyBoolean(), Matchers.anyBoolean())).thenReturn((Object)false);
        this.setupGrid(() -> this.parent, () -> 1);
        this.uiHeaderRowIndex = Optional.empty();
        this.uiHeaderColumnIndex = Optional.empty();
        this.uiRowIndex = Optional.of(0);
        this.uiColumnIndex = Optional.of(1);
        Assertions.assertThat((boolean)this.handler.onNodeMouseEvent((GridWidget)this.gridWidget, this.relativeLocation, this.uiHeaderRowIndex, this.uiHeaderColumnIndex, this.uiRowIndex, this.uiColumnIndex, this.event)).isFalse();
        ((CellSelectionManager)Mockito.verify((Object)this.parentCellSelectionManager)).selectCell(Matchers.eq((int)0), Matchers.eq((int)1), Matchers.eq((boolean)false), Matchers.eq((boolean)true));
        ((LiteralExpressionGrid)Mockito.verify((Object)this.gridWidget)).doAfterSelectionChange(Matchers.eq((int)0), Matchers.eq((int)1));
    }

    @Test
    public void testOnNodeMouseEventWhenNestedOnBodyWithSelectionChange() {
        Mockito.when((Object)this.event.isShiftKeyDown()).thenReturn((Object)false);
        Mockito.when((Object)this.event.isControlKeyDown()).thenReturn((Object)true);
        Mockito.when((Object)this.parentGridWidget.isSelected()).thenReturn((Object)false);
        Mockito.when((Object)this.parentCellSelectionManager.selectCell(Matchers.anyInt(), Matchers.anyInt(), Matchers.anyBoolean(), Matchers.anyBoolean())).thenReturn((Object)true);
        this.setupGrid(() -> this.parent, () -> 1);
        this.uiHeaderRowIndex = Optional.empty();
        this.uiHeaderColumnIndex = Optional.empty();
        this.uiRowIndex = Optional.of(0);
        this.uiColumnIndex = Optional.of(1);
        Assertions.assertThat((boolean)this.handler.onNodeMouseEvent((GridWidget)this.gridWidget, this.relativeLocation, this.uiHeaderRowIndex, this.uiHeaderColumnIndex, this.uiRowIndex, this.uiColumnIndex, this.event)).isTrue();
        ((CellSelectionManager)Mockito.verify((Object)this.parentCellSelectionManager)).selectCell(Matchers.eq((int)0), Matchers.eq((int)1), Matchers.eq((boolean)false), Matchers.eq((boolean)true));
        ((Layer)Mockito.verify((Object)this.layer)).batch();
        ((LiteralExpressionGrid)Mockito.verify((Object)this.gridWidget)).doAfterSelectionChange(Matchers.eq((int)0), Matchers.eq((int)1));
        ((GridSelectionManager)Mockito.verify((Object)this.selectionManager)).select((GridWidget)Matchers.eq((Object)this.parentGridWidget));
    }
}

