/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.model;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.HashMap;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.model.ExpressionEditorGridRow;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCell;

@RunWith(value=LienzoMockitoTestRunner.class)
public class ExpressionEditorGridRowTest {
    @Mock
    private BaseExpressionGrid view;

    @Test
    public void testEmptyRow() throws Exception {
        ExpressionEditorGridRow row = new ExpressionEditorGridRow();
        Assertions.assertThat((double)row.getHeight()).isEqualTo(48.0);
    }

    @Test
    public void testRowNoHigherThanDefault() throws Exception {
        GridRow row = (GridRow)Mockito.spy(ExpressionEditorGridRow.class);
        HashMap<Integer, GridCell> cells = new HashMap<Integer, GridCell>(){
            {
                ((BaseExpressionGrid)Mockito.doReturn((Object)47.0).when((Object)ExpressionEditorGridRowTest.this.view)).getHeight();
                this.put(0, new BaseGridCell((GridCellValue)new ExpressionCellValue(Optional.of(ExpressionEditorGridRowTest.this.view))));
            }
        };
        ((GridRow)Mockito.doReturn((Object)cells).when((Object)row)).getCells();
        Assertions.assertThat((double)row.getHeight()).isBetween(Double.valueOf(0.0), Double.valueOf(48.0));
    }

    @Test
    public void testRowHigherThanDefault() throws Exception {
        GridRow row = (GridRow)Mockito.spy(ExpressionEditorGridRow.class);
        HashMap<Integer, GridCell> cells = new HashMap<Integer, GridCell>(){
            {
                ((BaseExpressionGrid)Mockito.doReturn((Object)49.0).when((Object)ExpressionEditorGridRowTest.this.view)).getHeight();
                this.put(0, new BaseGridCell((GridCellValue)new ExpressionCellValue(Optional.of(ExpressionEditorGridRowTest.this.view))));
            }
        };
        ((GridRow)Mockito.doReturn((Object)cells).when((Object)row)).getCells();
        Assertions.assertThat((double)row.getHeight()).isGreaterThan(48.0);
    }
}

