/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.model;

import java.util.Optional;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridCell;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;

@RunWith(value=MockitoJUnitRunner.class)
public class GridCellTupleTest {
    @Mock
    private GridWidget gridWidget;
    @Mock
    private GridColumn gridColumn;
    @Mock
    private BaseExpressionGrid existingEditor;
    private GridData gridData;
    private GridCellTuple tuple;

    @Before
    public void setup() {
        this.tuple = new GridCellTuple(0, 0, this.gridWidget);
        this.gridData = new BaseGridData(false);
        this.gridData.appendColumn(this.gridColumn);
        this.gridData.appendRow((GridRow)new BaseGridRow());
        Mockito.when((Object)this.gridWidget.getModel()).thenReturn((Object)this.gridData);
    }

    @Test
    public void testProposeContainingColumnWidthWhenLargerThanExisting() {
        Mockito.when((Object)this.gridColumn.getWidth()).thenReturn((Object)100.0);
        this.tuple.proposeContainingColumnWidth(200.0, BaseExpressionGrid.RESIZE_EXISTING);
        ((GridColumn)Mockito.verify((Object)this.gridColumn)).setWidth(200.0);
    }

    @Test
    public void testProposeContainingColumnWidthWhenSmallerThanExisting() {
        Mockito.when((Object)this.gridColumn.getWidth()).thenReturn((Object)100.0);
        this.tuple.proposeContainingColumnWidth(50.0, BaseExpressionGrid.RESIZE_EXISTING);
        ((GridColumn)Mockito.verify((Object)this.gridColumn)).setWidth(50.0);
    }

    @Test
    public void testProposeContainingColumnWidthWhenSmallerThanExistingEditor() {
        this.gridData.setCell(0, 0, () -> new DMNGridCell((GridCellValue)new ExpressionCellValue(Optional.of(this.existingEditor))));
        Mockito.when((Object)this.existingEditor.getPadding()).thenReturn((Object)10.0);
        Mockito.when((Object)this.existingEditor.getMinimumWidth()).thenReturn((Object)200.0);
        Mockito.when((Object)this.gridColumn.getWidth()).thenReturn((Object)100.0);
        this.tuple.proposeContainingColumnWidth(50.0, BaseExpressionGrid.RESIZE_EXISTING_MINIMUM);
        ((GridColumn)Mockito.verify((Object)this.gridColumn)).setWidth(220.0);
    }

    @Test
    public void testProposeContainingColumnWidthWhenLargerThanExistingEditor() {
        this.gridData.setCell(0, 0, () -> new DMNGridCell((GridCellValue)new ExpressionCellValue(Optional.of(this.existingEditor))));
        Mockito.when((Object)this.existingEditor.getPadding()).thenReturn((Object)10.0);
        Mockito.when((Object)this.existingEditor.getMinimumWidth()).thenReturn((Object)200.0);
        Mockito.when((Object)this.gridColumn.getWidth()).thenReturn((Object)100.0);
        this.tuple.proposeContainingColumnWidth(300.0, BaseExpressionGrid.RESIZE_EXISTING);
        ((GridColumn)Mockito.verify((Object)this.gridColumn)).setWidth(300.0);
    }

    @Test
    public void testOnResizeSetsColumnWidth() {
        Mockito.when((Object)this.gridColumn.getWidth()).thenReturn((Object)100.0);
        this.tuple.onResize();
        ((GridColumn)Mockito.verify((Object)this.gridColumn)).setWidth(100.0);
    }
}

