/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.layer;

import com.ait.lienzo.client.core.Context2D;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.widgets.layer.InverseGridWidgetClipper;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;

@RunWith(value=LienzoMockitoTestRunner.class)
public class InverseGridWidgetClipperTest {
    private static final double OUTER_WIDTH = 1000.0;
    private static final double OUTER_HEIGHT = 500.0;
    private static final double OUTER_ABSOLUTE_X = 0.0;
    private static final double OUTER_ABSOLUTE_Y = 0.0;
    private static final double INNER_WIDTH = 200.0;
    private static final double INNER_HEIGHT = 50.0;
    private static final double INNER_ABSOLUTE_X = 100.0;
    private static final double INNER_ABSOLUTE_Y = 75.0;
    @Mock
    private Context2D context2D;
    @Mock
    private GridWidget outer;
    @Mock
    private GridWidget inner;
    private InverseGridWidgetClipper clipper;

    @Before
    public void setUp() throws Exception {
        this.setupClipper(1000.0, 500.0, 0.0, 0.0, 200.0, 50.0, 100.0, 75.0);
    }

    @Test
    public void testIsActive() {
        this.clipper.setActive(true);
        Assertions.assertThat((boolean)this.clipper.isActive()).isTrue();
        this.clipper.setActive(false);
        Assertions.assertThat((boolean)this.clipper.isActive()).isFalse();
    }

    @Test
    public void testClip() {
        this.clipper.clip(this.context2D);
        ((Context2D)Mockito.verify((Object)this.context2D)).beginPath();
        ((Context2D)Mockito.verify((Object)this.context2D)).rect(Matchers.eq((double)0.0), Matchers.eq((double)0.0), Matchers.eq((double)100.0), Matchers.eq((double)501.0));
        ((Context2D)Mockito.verify((Object)this.context2D)).rect(Matchers.eq((double)100.0), Matchers.eq((double)0.0), Matchers.eq((double)201.0), Matchers.eq((double)75.0));
        ((Context2D)Mockito.verify((Object)this.context2D)).rect(Matchers.eq((double)100.0), Matchers.eq((double)126.0), Matchers.eq((double)201.0), Matchers.eq((double)375.0));
        ((Context2D)Mockito.verify((Object)this.context2D)).rect(Matchers.eq((double)301.0), Matchers.eq((double)0.0), Matchers.eq((double)700.0), Matchers.eq((double)501.0));
        ((Context2D)Mockito.verify((Object)this.context2D)).clip();
    }

    private void setupClipper(double outerWidth, double outerHeight, double outerAbsoluteX, double outerAbsoluteY, double innerWidth, double innerHeight, double innerAbsoluteX, double innerAbsoluteY) {
        Mockito.when((Object)this.outer.getWidth()).thenReturn((Object)outerWidth);
        Mockito.when((Object)this.outer.getHeight()).thenReturn((Object)outerHeight);
        Point2D outerComputedLocation = new Point2D(outerAbsoluteX, outerAbsoluteY);
        Mockito.when((Object)this.outer.getComputedLocation()).thenReturn((Object)outerComputedLocation);
        Mockito.when((Object)this.inner.getWidth()).thenReturn((Object)innerWidth);
        Mockito.when((Object)this.inner.getHeight()).thenReturn((Object)innerHeight);
        Point2D innerComputedLocation = new Point2D(innerAbsoluteX, innerAbsoluteY);
        Mockito.when((Object)this.inner.getComputedLocation()).thenReturn((Object)innerComputedLocation);
        this.clipper = new InverseGridWidgetClipper(this.outer, this.inner);
    }
}

