/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.decision;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.dmn.client.decision.DecisionNavigatorChildrenTraverse;
import org.kie.workbench.common.dmn.client.decision.DecisionNavigatorItem;
import org.kie.workbench.common.dmn.client.decision.DecisionNavigatorObserver;
import org.kie.workbench.common.dmn.client.decision.events.RefreshDecisionComponents;
import org.kie.workbench.common.dmn.client.decision.factories.DecisionNavigatorItemFactory;
import org.kie.workbench.common.dmn.client.decision.included.components.DecisionComponents;
import org.kie.workbench.common.dmn.client.decision.tree.DecisionNavigatorTreePresenter;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.uberfire.client.annotations.DefaultPosition;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.Position;

@ApplicationScoped
@WorkbenchScreen(identifier="org.kie.dmn.decision.navigator")
public class DecisionNavigatorPresenter {
    public static final String IDENTIFIER = "org.kie.dmn.decision.navigator";
    private final View view;
    private final DecisionNavigatorTreePresenter treePresenter;
    private final DecisionComponents decisionComponents;
    private final DecisionNavigatorObserver decisionNavigatorObserver;
    private final DecisionNavigatorChildrenTraverse navigatorChildrenTraverse;
    private final DecisionNavigatorItemFactory itemFactory;
    private final TranslationService translationService;
    private CanvasHandler handler;

    @Inject
    public DecisionNavigatorPresenter(View view, DecisionNavigatorTreePresenter treePresenter, DecisionComponents decisionComponents, DecisionNavigatorObserver decisionNavigatorObserver, DecisionNavigatorChildrenTraverse navigatorChildrenTraverse, DecisionNavigatorItemFactory itemFactory, TranslationService translationService) {
        this.view = view;
        this.treePresenter = treePresenter;
        this.decisionComponents = decisionComponents;
        this.decisionNavigatorObserver = decisionNavigatorObserver;
        this.navigatorChildrenTraverse = navigatorChildrenTraverse;
        this.itemFactory = itemFactory;
        this.translationService = translationService;
    }

    @WorkbenchPartView
    public View getView() {
        return this.view;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.translationService.format("DecisionNavigatorPresenter.DecisionNavigator", new Object[0]);
    }

    @DefaultPosition
    public Position getDefaultPosition() {
        return CompassPosition.WEST;
    }

    @PostConstruct
    void setup() {
        this.initialize();
        this.setupView();
    }

    public void onRefreshDecisionComponents(@Observes RefreshDecisionComponents events) {
        this.refreshComponentsView();
    }

    public DecisionNavigatorTreePresenter getTreePresenter() {
        return this.treePresenter;
    }

    public Diagram getDiagram() {
        return this.handler.getDiagram();
    }

    public CanvasHandler getHandler() {
        return this.handler;
    }

    public void setHandler(CanvasHandler handler) {
        this.handler = handler;
        this.refreshTreeView();
        this.refreshComponentsView();
    }

    public void addOrUpdateElement(Element<?> element) {
        if (!this.isNode(element)) {
            return;
        }
        this.treePresenter.addOrUpdateItem(this.makeItem(element));
    }

    public void updateElement(Element<?> element) {
        if (!this.isNode(element)) {
            return;
        }
        this.treePresenter.updateItem(this.makeItem(element));
    }

    public void removeElement(Element<?> element) {
        if (!this.isNode(element)) {
            return;
        }
        this.treePresenter.remove(this.makeItem(element));
    }

    public void removeAllElements() {
        this.treePresenter.removeAllItems();
        this.decisionComponents.removeAllItems();
    }

    void initialize() {
        this.view.init(this);
        this.decisionNavigatorObserver.init(this);
    }

    void setupView() {
        this.view.setupMainTree(this.treePresenter.getView());
        this.view.setupDecisionComponents(this.decisionComponents.getView());
    }

    public void refreshTreeView() {
        this.treePresenter.setupItems(this.getItems());
    }

    public void refreshComponentsView() {
        this.getOptionalHandler().ifPresent(handler -> this.decisionComponents.refresh(handler.getDiagram()));
    }

    List<DecisionNavigatorItem> getItems() {
        return this.getGraph().map(this.navigatorChildrenTraverse::getItems).orElse(Collections.emptyList());
    }

    public Optional<Graph> getGraph() {
        return this.getOptionalHandler().map(CanvasHandler::getDiagram).map(Diagram::getGraph);
    }

    Optional<CanvasHandler> getOptionalHandler() {
        return Optional.ofNullable(this.handler);
    }

    DecisionNavigatorItem makeItem(Element<?> element) {
        Node node = element.asNode();
        return this.itemFactory.makeItem((Node<org.kie.workbench.common.stunner.core.graph.content.view.View, Edge>)node);
    }

    private boolean isNode(Element<?> element) {
        return element instanceof Node;
    }

    public void clearSelections() {
        this.getTreePresenter().deselectItem();
    }

    public static interface View
    extends UberElemental<DecisionNavigatorPresenter>,
    IsElement {
        public void setupMainTree(DecisionNavigatorTreePresenter.View var1);

        public void setupDecisionComponents(DecisionComponents.View var1);
    }
}

